<?php
// DATABASE_CONFIG_FLAGͭˤDATABASE_CONFIGϤޤ
//define('DATABASE_CONFIG_FLAG', true);

/**
 * CakeInfo file.
 *
 * PHP versions 4 and 5
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright   Copyright (c) 2007, Masashi Shinbara
 * @link        http://www.1x1.jp/blog/
 * @version     0.1.0
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 */
class CakeInfo {
  /**
   * Configure
   *
   * @var object Configure
   */
  var $conf = null;
  /**
   * version
   *
   * @var string
   */
  var $version = null;
  /**
   * config values
   *
   * @var array
   */
  var $values = array();

  /**
   * construct for php4
   */
  function CakeInfo() {
    $this->__construct();
  }

  /**
   * construct for php5
   */
  function __construct() {
    $this->conf = Configure::getInstance();
    $this->version = $this->conf->version();
  }

  /**
   * make CakeInfo values
   */
  function execute() {
    $this->values = array();
    $this->values['PHP'] = array($this->makePhpValues());
    $this->values['Core'] = array($this->makeCoreValues());
    $this->values['Path'] = array($this->makePathValues());
    $this->values['Database'] = $this->makeDatabaseValues();
    $this->values['Controller'] = $this->makeControllerValues();
    $this->values['Model'] = $this->makeModelValues();
  }

  /**
   * make php values
   *
   * @return array
   */
  function makePhpValues() {
    $array = array();
    $array['VERSION'] = phpversion();
    $array['REQUEST_URI'] = $_SERVER['REQUEST_URI'];
    $array['SERVER_PORT'] = $_SERVER['SERVER_PORT'];
    $array['SCRIPT_FILENAME'] = $_SERVER['SCRIPT_FILENAME'];
    $array['DOCUMENT_ROOT'] = $_SERVER['DOCUMENT_ROOT'];

    return $array;
  }

  /**
   * make core values
   *
   * @return array
   */
  function makeCoreValues() {
    $array = array();
    $array = $this->_getConstants('index.php');
    $array += $this->_getConstants(ROOT . DS . APP_DIR . DS . 'config' . DS . 'core.php');

    return $array;
  }

  /**
   * make path values
   *
   * @return array
   */
  function makePathValues() {
    $array = array();

    $paths = get_object_vars($this->conf);
    foreach ($paths as $k => $v) {
      if (preg_match("/Path/", $k)) {
        $array[$k] = $v;
      }
    }

    return $array;
  }

  /**
   * make db values
   *
   * @return array
   */
  function makeDatabaseValues() {
    $array = array();

    config('database');
    $db = new DATABASE_CONFIG;
    foreach ($db as $k1 => $v1) {
      foreach ($v1 as $k2 => $v2) {
        $array[$k1][$k2] = $v2;
      }
    }

    return $array;
  }

  /**
   * make controller values
   *
   * @return array
   */
  function makeControllerValues() {
    $array = array();

    $paths = $this->_getFileListDirs($this->conf->controllerPaths);
    foreach ($paths as $path) {
      if (is_file($path) && preg_match("/^(.+)_controller\.php$/", basename($path), $m)) {
        $ctrlName = Inflector::camelize($m[1]);
        loadController($ctrlName);
        $class = $ctrlName . 'Controller';
        $obj = new $class();

        $v = $this->_getClassDiffValues(get_class_vars('Controller'), get_object_vars($obj));
        $v['view'] = $this->_getViewList($ctrlName);

        $array[$ctrlName] = $v;
      }
    }

    return $array;
  }

  /**
   * get view list
   *
   * @param string $ctrlName
   * @return array
   */
  function _getViewList($ctrlName) {
    $array = array();

    foreach ($this->conf->viewPaths as $dirPath) {
      $dirPath .= Inflector::underscore($ctrlName);

      $array[] = sprintf('[%s]', $dirPath);
      $offset = strlen($dirPath) + 1; // add DS character

      $paths = $this->_getFileList($dirPath);
      foreach ($paths as $path) {
        if (is_file($path) && preg_match("/(.ctp|.thtml)$/", $path)) {
          $array[] = substr($path, $offset);
        }
      }
    }

    return $array;
  }

  /**
   * make model values
   *
   * @return array
   */
  function makeModelValues() {
    $array = array();

    $paths = $this->_getFileListDirs($this->conf->modelPaths);
    foreach ($paths as $path) {
      if (is_file($path) && preg_match("/^(.+)\.php$/", basename($path), $m)) {
        $modelName = Inflector::camelize($m[1]);
        loadModel($modelName);

        $v = $this->_getClassDiffValues(get_class_vars('Model'), get_class_vars($modelName));

        $array[$modelName] = $v;
      }
    }

    return $array;
  }


  /**
   * get constants
   *
   * @param string $path
   * @return array
   */
  function _getConstants($path) {
    $contents = file($path);

    $array = array();
    foreach ($contents as $line) {
      if (preg_match("/define\('([^']+)'/", $line , $m)) {
        $name = $m[1];

        if (defined($name)) {
          $array[$name] = constant($name);
        }
      }
    }

    return $array;
  }

  /**
   * make file list
   *
   * @param array $dirPaths
   * @return array
   */
  function _getFileListDirs($dirPaths) {
    $array = array();

    foreach ($dirPaths as $dirPath) {
      $array += $this->_getFileList($dirPath);
    }

    return $array;
  }

  /**
   * make file list
   *
   * @param string $dirPath
   * @return array
   */
  function _getFileList($dirPath) {
    $array = array();

    if (!file_exists($dirPath) || !is_dir($dirPath)) {
      return $array;
    }
    $d = dir($dirPath);

    while ($file = $d->read()) {
      if ($file == '.' || $file == '..') {
        continue;
      }

      if (substr($dirPath, -1) != DS) {
        $dirPath .= DS;
      }
      $path = $dirPath . $file;
      if (is_dir($path)) {
        $array += $this->_getFileList($path);
      }

      $array[] = $path;
    }

    return $array;
  }

  /**
   * get class difference values
   *
   * @param array& $baseVars
   * @param array& $classVars
   * @return array
   */
  function _getClassDiffValues(&$baseVars, &$classVars) {
    $array = array();

    foreach ($classVars as $name => $var) {
      if (@$baseVars[$name] !== $classVars[$name]) {
        $array[$name] = $this->_arrayToString($var);
      }
    }

    return $array;
  }

  /**
   * get value
   *
   * @param mixed &$value
   * @return string
   */
  function _arrayToString(&$value) {
    $str = '';

    if (is_array($value)) {
      foreach ($value as $k => $v) {
        if (!empty($str)) {
          $str .= "<br />";
        }
        if (is_array($v)) {
          $str .= $k;
        } else {
          $str .= (is_numeric($k) ? $v : $k);
        }
      }
    } else {
      $str =  $value;
    }

    return $str;
  }
}


$_GET['url'] = 'favicon.ico';
require_once('index.php');
require_once('cake/libs/sanitize.php');

$info = new CakeInfo();
$info->execute();
if (!defined('DATABASE_CONFIG_FLAG')) {
  unset($info->values['Database']);
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<html><head>
<style type="text/css">
body {background-color: #ffffff; color: #000000;}
body, td, th, h1, h2 {font-family: sans-serif;}
pre {margin: 0px; font-family: monospace;}
a:link {color: #000099; text-decoration: none; background-color: #ffffff;}
a:hover {text-decoration: underline;}
table {border-collapse: collapse;}
.center {text-align: center;}
.center table { margin-left: auto; margin-right: auto; text-align: left;}
.center th { text-align: center !important; }
td, th { border: 1px solid #000000; font-size: 75%; vertical-align: baseline;}
h1 {font-size: 150%;}
h2 {font-size: 125%;}
.p {text-align: left;}
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.h {background-color: #003D4C; font-weight: bold; color: #ffffff;}
.v {background-color: #cccccc; color: #000000;}
.vr {background-color: #cccccc; text-align: right; color: #000000;}
img {float: right; border: 0px;}
hr {width: 600px; background-color: #cccccc; border: 0px; height: 1px; color: #000000;}
</style>
<title>cakeinfo()</title>
</head>

<body><div class="center">
<table border="0" cellpadding="3" width="600">
<tr class="h">
<td>
<a href="http://cakeforge.org/"><img border="0" src="logo-mini.gif" alt="CakePHP Logo" /></a>
<h1 class="p">CakePHP Version <?php echo Sanitize::html($info->version) ?></h1>
</td></tr>
</table><br />
<hr />
<?php foreach ($info->values as $section => $blocks): ?>
<h1><?php echo Sanitize::html($section) ?></h1>
  <?php foreach ($blocks as $name => $values): ?>
    <?php if ($name): ?>
  <h2><?php echo Sanitize::html(Inflector::camelize($name)) ?></h2>
    <?php endif; ?>
  <table border="0" cellpadding="3" width="600">
    <tr class="h"><th>Name</th><th>Value</th></tr>
    <?php foreach ($values as $k => $v): ?>
      <tr>
        <td class="e"><?php echo Sanitize::html($k) ?></td>
        <td class="v"><?php Sanitize::html($v); echo (is_array($v) ? implode('<br />', $v) : $v); ?></td>
      </tr>
    <?php endforeach; ?>
  </table>
  <?php endforeach; ?>
<br />
<?php endforeach; ?>
<hr />
</body>
</html>
