<?php
class HolidayHelper extends Helper {

//	http://blog.aidream.jp/codeigniter/codeigniter-japanese-holiday-class-1291.html

// if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 5.1.6 or newer
 *
 * @package     CodeIgniter
 * @author      ExpressionEngine Dev Team
 * @copyright   Copyright (c) 2008 - 2011, EllisLab, Inc.
 * @license     http://codeigniter.com/user_guide/license.html
 * @link        http://codeigniter.com
 * @since       Version 1.0
 * @filesource
 */
 
// ------------------------------------------------------------------------
 
/**
 * Japanese Holiday Class
 *
 * {̍̋xEU֋xEx
 *
 * t{ȕjɊւ@v
 * http://www8.cao.go.jp/chosei/shukujitsu/gaiyou.html
 *ut̓vƁuH̓v́wCۈH vZ Vݕ֗x
 * http://www.h3.dion.ne.jp/~sakatsu/sekki24_topic.htm
 *
 * @package     CodeIgniter
 * @subpackage  Libraries
 * @category    Libraries
 * @author
 * @link       
 */
/*
// Rg[̋Lq
$this->load->library(array('calendar'));
$config = array(1 => 'xA', 15 => 'xB');
$holidays = $this->holiday->get(2011, 6, $config, TRUE);
 
 
 
*/
//class Holiday {
     
    /**
     * Y̋xƐU֋x擾
     *
     * @access public
     * @param integer $year N
     * @param integer $month 
     * @param array $data [U`xf[^
     * @param bool $flg U֋x擾邩ۂ̐^Ul
     * @param string $substitute_public_holiday_name U֋x\ۂ̖
     */
    public function is_holiday($year = '', $month = '', $hi='', &$out)	//$data = array(), $flg = TRUE, $substitute_public_holiday_name = 'U֋x')
    {
		$data = array();
		$flg = TRUE;
		$substitute_public_holiday_name = 'U֋x';

        // 𐮌`
        $year = (int)$year;
        $month = (int)$month;
         
        // s̏ꍇ FALSE Ԃ
        if (
                ! is_int($year) OR
                ! is_int($month) OR $month < 1 OR 12 < $month OR
                ! is_array($data) OR
                ! is_bool($flg) OR
                ! is_string($substitute_public_holiday_name)
            )
        {
            return FALSE;
        }
         
        // Y̋xZbg
        $res = $this->set($year, $month);
         
        // U֋xsv̏ꍇ
        if ( ! $flg)
        {
            // [U`f[^ŏ㏑ʂԂ
            //return $data + $res;
            //return $res;
        }
        // U֋xKv  xꍇ
        elseif( ! empty($res))
        {
            for($day = 1; $day < date('t',mktime(0, 0, 0, $month, 1, $year)); $day++)
            {
                $time = mktime(0, 0, 0, $month, $day, $year);
                // j̏ꍇAU֋x`FbN
                if (date('w', $time) == 0)
                {
                    if(
                        ! empty($res[$day]) AND // x
                        empty($res[$day+1]) AND //  xł͂Ȃ
                        $time >= mktime(0, 0, 0, 4, 12, 1973) //  U֋x{s ȍ~
                        )
                    {
                        // U֋xǉ
                        $res[$day+1] = $substitute_public_holiday_name;
                    }
                }
            }
        }
        // [U`f[^ŏ㏑ʂԂ
        //return $data + $res;
        //return $res;
		//print_r($res);
		
		$out = "";
		if (checkdate($month, $hi, $year) == false) {
			return false;
		}
		
		if(isset($res[$hi])){
			//echo $year."-".$month."-".$hi."=".$res[$hi]."<br>";
			$out = $res[$hi];
			return true;
		}
		return false;
    }
     
    /**
     * Y̋x擾
     *
     * @access private
     * @param integer N
     * @param integer 
     */
    private function set($year, $month)
    {
        $res = array();
        $second_monday = $this->second_monday($year, $month);
        $third_monday = $this->third_monday($year, $month);
         
        if(mktime(0,0,0, $month, 20, $year) < mktime(0, 0, 0, 7, 20, 1948))
        {
            return $res;   // j@{s(1948N720)ȑO
        }
        else
        {
            switch ($month)
            {
                case 1:
                    $res[1] = '';
                    if ($year >= 2000)
                    {
                        $res[$second_monday] = 'l̓';
                    }
                    else
                    {
                        $res[15] = 'l̓';
                    }
                    break;
                case 2:
                    if ($year >= 1967)
                    {
                        $res[11] = 'LO̓';
                    }
                    if ($year == 1989)
                    {
                        $res[24] = 'aVc̑r̗';
                    }
                    break;
            case 3:
                $day = $this->get_spring_equinox_day($year);
                if ($day)
                {
                    $res[$day] = 't̓';
                }
                break;
            case 4:
                if ($year >= 2007)
                {
                    $res[29] = 'a̓';
                }
                else
                {
                    if ($year >= 1989)
                    {
                        $res[29] = '݂ǂ̓';
                    }
                    else
                    {
                        $res[29] = 'Vca';
                    }
                }
                if ($year == 1959)
                {
                    $res[10] = 'cqmě̋V'; // 1959N410
                }
                break;
            case 5:
                $res[3] = '@LO';
                if ($year >= 2007)
                {
                    $res[4] = '݂ǂ̓';
                }
                else
                {
                    if ($year >= 1986)
                    {
                        // 54j̏ꍇ́w̓jxj̏ꍇ́w@LO̐U֋xx(?2006N)
                        if (date('w', mktime(0, 0, 0, 5, 4, $year)) > 1)
                        {
                            $res[4] = '̋x';
                        }
                    }
                }
                $res[5] = 'ǂ̓';
                if ($year >= 2007)
                {
                    if (date('w',mktime(0, 0, 0, 5, 6, $year)) == 2 OR date('w',mktime(0, 0, 0, 5, 6, $year)) == 3)
                    {
                        $res[6] = 'U֋x';    // 53E54j̏ꍇ݂̂Ŕ
                    }
                }
                break;
            case 6:
                if ($year == 1993)
                {
                    $res[9] = 'cqmě̋V';
                }
                break;
            case 7:
                if ($year >= 2003)
                {
                    $res[$third_monday] = 'C̓';
                }
                else
                {
                    if ($year >= 1996)
                    {
                        $res[20] = 'C̓';
                    }
                }
                break;
            case 9:
                //3j(15`21)ƏH(22`24)dȂ鎖͂Ȃ
                $day = $this->get_autumnal_equinox_day($year);
                if ($day)
                {
                    $res[$day] = 'H̓';
                }
                if ($year >= 2003)
                {
                    $res[$third_monday] = 'hV̓';
                    if (date('w',mktime(0, 0, 0, 9, $day, $year)) == 3)
                    {
                        $res[$day-1] = '̋x';
                    }
                }
                else
                {
                    if ($year >= 1966)
                    {
                        $res[15] = 'hV̓';
                    }
                }
                break;
            case 10:
                if ($year >= 2000)
                {
                    $res[$second_monday] = '̈̓';
                }
                else
                {
                    if ($year >= 1966)
                    {
                        $res[10] = '̈̓';
                    }
                }
                break;
            case 11:
                $res[3] = '̓';
                $res[23] = 'ΘJӂ̓';
                if ($year == 1990)
                {
                    $res[12] = 'ʗ琳a̋V';
                }
                break;
            case 12:
                if ($year >= 1989)
                {
                    $res[23] = 'Vca';
                }
                break;
            }
            return $res;
        }
    }
     
    /**
     * 2j
     *
     * @access private
     * @param integer N
     * @param integer 
     */
    private function second_monday($year, $month)
    {
        $w = date('N', mktime(0, 0, 0, $month, 1, $year));
        switch($w)
        {
            case 1:
                return 8;
            default:
                return 14 - ($w - 2);  // 9`14
        }
    }
     
    /**
     * 3j
     *
     * @access private
     * @param integer N
     * @param integer 
     */
    private function third_monday($year, $month)
    {
        $w = date('N', mktime(0, 0, 0, $month, 1, $year));
        switch($w)
        {
            case 1 :
                return 15;
            default :
                return 21 - ($w - 2);  // 16`21
        }
    }
     
    /**
     * t̓
     *
     * @access private
     * @param integer N
     */
    private function get_spring_equinox_day($year)
    {
        $res = FALSE;
        if ($year <= 1947)
        {
            $res = FALSE; // j@{sO
        }
        else
        {
            if ($year <= 1979)
            {
                $res = intval(20.8357 + (0.242194 * ($year - 1980)) - intval(($year - 1983) / 4));
            }
            else
            {
                if ($year <= 2099)
                {
                    $res = intval(20.8431 + (0.242194 * ($year - 1980)) - intval(($year - 1980) / 4));
                }
                else
                {
                    if ($year <= 2150)
                    {
                        $res = intval(21.851 + (0.242194 * ($year - 1980)) - intval(($year - 1980) / 4));
                    }
                    else
                    {
                        $res = FALSE; // 2151Nȍ~͗Zߕs
                    }
                }
            }
        }
        return $res;
    }
     
    /**
     * H̓
     *
     * @access private
     * @param integer N
     */
    private function get_autumnal_equinox_day($year)
    {
        $res = FALSE;
        if ($year <= 1947)
        {
            $res = FALSE; // j@{sO
        }
        else
        {
            if ($year <= 1979)
            {
                $res = intval(23.2588 + (0.242194 * ($year - 1980)) - intval(($year - 1983) / 4));
            }
            else
            {
                if ($year <= 2099)
                {
                    $res = intval(23.2488 + (0.242194 * ($year - 1980)) - intval(($year - 1980) / 4));
                }
                else
                {
                    if ($year <= 2150)
                    {
                        $res = intval(24.2488 + (0.242194 * ($year - 1980)) - (int) (($year - 1980) / 4));
                    }
                    else
                    {
                        $res = FALSE; // 2151Nȍ~͗Zߕs
                    }
                }
            }
        }
        return $res;
    }
     
    /**
     * Y̒x擾
     * Y̎w肳ꂽj̓zŕԂ
     *
     * @access public
     * @param integer N
     * @param integer 
     * @param array xw肷ji0:, 1:, 2:, 3:, 4:, 5:, 6:yj
     * @param array xcƂ
     * @param string x\ۂ̖
     */
    public function get_regular_holidays($year = '', $month = '', $week_days = array(), $business_days = array(), $business_day_name = 'x')
    {
        // 𐮌`
        $year = (int)$year;
        $month = (int)$month;
         
        // s̏ꍇ FALSE Ԃ
        if (
                ! is_int($year) OR
                ! is_int($month) OR $month < 1 OR 12 < $month OR
                ! is_array($week_days) OR
                ! is_array($business_days) OR
                ! is_string($business_day_name)
            )
        {
            return FALSE;
        }
         
        // xi[
        for ($i = 1; $i <= date('t',mktime(0, 0, 0, $month, 1, $year)); $i++)
        {
            $week_day = date('w',mktime(0, 0, 0, $month, $i, $year));
            if (in_array($week_day, $week_days) AND ! in_array($week_day, $business_days))
            {
                $res[$i] = 'x';
            }
        }
        return $res;
    }

}	//end of class
