<?php
//	参照：　http//hayo0914.hatenablog.com/category/CakePHP

class UsersController extends AppController {
    public $name = 'Users';
	public $uses = array('User');

	public $components = array('Auth', 'Common');	//'Session', , 'Mail', 'Email', 'Qdmail', 'Excel'
	public $helpers = array('Common', 'Html', 'Form');	//'Javascript', , 'Tabular', 'Calender', 'Holiday'
    public $layout = 'login';

	private $debug = false;

    function beforeFilter() {
		if(($_SERVER['REMOTE_ADDR'] == "113.41.129.140") || ($_SERVER['REMOTE_ADDR'] == "113.41.129.155") || ($_SERVER['REMOTE_ADDR'] == "118.15.186.42")){
			Configure::write('debug', 2);
			$this->debug = true;
		}else
			Configure::write('debug', 0);

        /*
         * ログアウトのアクションも許可しておかなければならない。
         * ログアウトを認証必須にすると、以下のような現象が起きた。
         *     ログインしていないときにログアウトを実行し、次にログインをしようとすると、
         *     ログイン処理の後にそのままログアウトにリダイレクトしてしまい、ログインできない。
         */

        $this->Auth->allow('add', 'logout');
        $this->Auth->authError = "まだログインしていません。";
        $this->Auth->loginError = "ログインできませんでした。ユーザIDとパスワードを正しく入力してください";
        $this->Auth->authorize = 'controller'; // 認証成功後の追加処理を行う場所を指定
        $this->Auth->loginAction = array('admin' => false, 'controller' => 'users', 'action' => 'login' ); // ログインしていないときのリダイレクト先

        //$this->Auth->loginRedirect = array('controller' => 'quotation', 'action' => 'index' ); // ログイン成功後のリダイレクト先
        //$this->Auth->loginRedirect = array('controller' => 'mailauth', 'action' => 'mail_authorize' ); // ログイン成功後のリダイレクト先
        $this->Auth->loginRedirect = array('controller' => 'mailauth', 'action' => 'top_menu' ); // ログイン成功後のリダイレクト先

        $this->Auth->logoutRedirect = array(Configure::read('Routing.admin') => false, 'controller' => 'users', 'action' => 'login' ); // ログアウト後のリダイレクト先
    }



    /**
     * 認証に成功した際に呼ばれる。(Auth->authorizeに'controller'をセットすることが必要）
     */
    function isAuthorized()  {
        $this->Session->setFlash(
            __('ログインに成功しました。（ユーザ名：' . $this->Auth->user('username') . ')', true)
            );
        return true;
    }

    function login($arg_msg="") {
		$username = null;
		$password = null;
		$this->set('arg_msg', $arg_msg);

		if($this->Common->getPost($this, 'User', 'username')){
	        if ($this->Auth->user()) {
    	        $this->Session->setFlash(
        	        __('既にログインしています。（ユーザ名：' . $this->Auth->user('username') . ')', true)
            	);
        	}else{
				$this->set('login_msg', "ログイン・エラー。");
			}
			$username = $this->Auth->user('username');
			$password = $this->Auth->user('password');
			$this->set('login_msg', "ログイン・エラー。");
		}else{
			$this->set('login_msg', "ログイン画面です。<br />こちらからログインしてください。");
		}

		$this->set('username', $username);
		$this->set('password', $password);
    }

    function succeed(){
		$this->redirect(array('controller'=>'quotation', 'action'=>'index'));
		exit;
    }

    function logout() {
        if ($this->Auth->user()) {
            $this->Session->setFlash(
                __('ログアウトしました。', true)
            );
        } else {
            $this->Session->setFlash(
                __('まだログインしていません。', true)
            );
        }
        $this->redirect($this->Auth->logout());
    }

    function add() {
        if(!empty($this->data)) {
            if ($this->data) {
                $this->User->create();
                // Authコンポーネントを使用してパスワードをハッシュ化する。
                $this->data['User']['password'] = $this->Auth->password($this->data['User']['password_for_validate']); //ハッシュ化
                $this->User->save($this->data);
                if($this->User->validates()) {
                    // バリデーションが問題ない場合はログインページにリダイレクトする。
                    $this->Session->setFlash(
                        __('ユーザを登録しました。ログインしてください', true)
                        );
                    $this->redirect(array('action' => 'login'));
                }
            }
        }
    }



	/* =================== ログイン管理修正 ======================= */
	function login_user(){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'users','action'=>'index'));
		}
		$this->set('main_title', 'ログイン情報設定');
		$this->set('sub_title', 'ログイン・ユーザー情報');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'User', 'search');
		$id = $this->Common->getPost($this, 'User', 'id');
		$username = $this->Common->getPost($this, 'User', 'username');
		$password = $this->Common->getPost($this, 'User', 'password');
		$category = $this->Common->getPost($this, 'User', 'category');

		$name1 = $this->Common->getPost($this, 'User', 'name1');
		$name2 = $this->Common->getPost($this, 'User', 'name2');
		$kana1 = $this->Common->getPost($this, 'User', 'kana1');
		$kana2 = $this->Common->getPost($this, 'User', 'kana2');
		$email = $this->Common->getPost($this, 'User', 'email');
		$role = $this->Common->getPost($this, 'User', 'role');
		$accessed = $this->Common->getPost($this, 'User', 'accessed');
		$modified = $this->Common->getPost($this, 'User', 'modified');

		$is_deleted = $this->Common->getPost($this, 'User', 'is_deleted');
		$ip_address = $this->Common->getPost($this, 'User', 'ip_address');
		$password2 = $this->Common->getPost($this, 'User', 'password2');
		$birthday = $this->Common->getPost($this, 'User', 'birthday');
		$entry_date = $this->Common->getPost($this, 'User', 'entry_date');
		$tel = $this->Common->getPost($this, 'User', 'tel');

		if(!$enable){
			$enable = 0;
			$this->set('enable', $enable);
		}

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'User', 'page');
		$direction = $this->Common->getPost($this, 'User', 'direction');
		$sort = $this->Common->getPost($this, 'User', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($username)
			$condition = array_merge_recursive($condition, array( "username like" => $username));
		if(intval($category) > 0)
			$condition = array_merge_recursive($condition, array( "category" => $category));
		if($role)
			$condition = array_merge_recursive($condition, array( "role like" => $role));
		if($name1)
			$condition = array_merge_recursive($condition, array( "name1 like" => $name1));
		if($name2)
			$condition = array_merge_recursive($condition, array( "name2 like" => $name2));
		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "username" => urlencode($username),
				     "category" => urlencode($category),
				     "role" => urlencode($role),
				     "name1" => urlencode($name1),
				     "name2" => urlencode($name2),
		);
		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		/* ページネーションの作成 */
		$this->paginate = array('User' => array('conditions' => $condition, 'limit'=>50, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('User');
		//$this->data = $this->Common->utf82sjis($this->data);
		$this->set('data', 	$this->data);
		$this->set('category', $user0['User']['category']);
		$this->set('user0', $user0['User']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'users','action'=>'login_user', 'page:1/direction:asc/sort:id'));
		}
	}

	/* =================== ログイン管理修正 ======================= */
	function login_user_edit($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'users','action'=>'index'));
		}

		$this->set('main_title', 'ログイン情報設定');
		$this->set('sub_title', 'ログイン・ユーザー管理　＞　修正');

		if($arg)
			$this->User->id = $arg;
		else
			$this->User->id = $this->Common->getPost($this, 'User', 'id');

		if(empty($this->data)){
			$this->data = $this->User->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
print_r($this->data);
exit();
			$count = $this->User->find('count', array('conditions' => array('username LIKE' => $this->data['User']['username'],
																		'id !=' => $this->User->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}
			$p1 = $this->Common->getPost($this, 'User', 'password');
			$p2 = AuthComponent::password($this->data['User']['password2']);
//echo "p1=[".$p1."]<br>";
//echo "p2=[".$p2."]<br>";
//print_r($this->data);
			if($p1 == $p2){
echo "p1=[".$p1."]<br>";
			//	if(true){		//更新
				if(!$this->User->save($this->data)){		//更新
					$errors = $this->User->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);
					$this->set('data', $this->data);
				}else{
print_r($this->data);
	//				$this->redirect(array('controller'=>'users','action'=>'login_user'));
				}
			}else{
//echo("パスワードが異なります。");
				$this->set('error_message', "パスワードが異なります。");
				$this->set('data', $this->data);
			}
		}
		$this->set('category', $user0['User']['category']);
		$this->set('user0', $user0['User']);
	}

	/* =================== ログイン管理削除 ======================= */
	function login_user_delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'users','action'=>'index'));
		}

		$this->set('main_title', 'ログイン情報設定');
		$this->set('sub_title', 'ログイン・ユーザー管理　＞　削除');

		if($arg)
			$this->User->id = $arg;
		else
			$this->User->id = $this->Common->getPost($this, 'User', 'id');

		if(empty($this->data)){
			$this->data = $this->User->read();	//読み出し
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->User->delete($this->User->id)){		//削除
				$errors = $this->User->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'users','action'=>'login_user'));
		}
		$this->set('category', $user0['User']['category']);
	}
	/* =================== ログイン管理新規作成 ======================= */
	function login_user_new(){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'users','action'=>'index'));
		}

		$this->set('main_title', 'ログイン情報設定');
		$this->set('sub_title', 'ログイン・ユーザー管理　＞　新規作成');

		if(empty($this->data)){
			$this->data['User']['username'] = null;
			$this->data['User']['password'] = null;
			$this->data['User']['category'] = 0;
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);

			$count = $this->User->find('count', array('conditions' => array('username LIKE' => $this->data['User']['username'])));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}

			$this->data['User']['id'] = null;
//print_r($this->data); echo "<br>";
			if(!$this->User->save($this->data)){		//新規作成
				$errors = $this->User->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
			}else
				$this->redirect(array('controller'=>'users','action'=>'login_user'));
		}
		$this->set('category', $user0['User']['category']);
	}



}