<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/Trafficfee/

class TrafficfeeController extends AppController {
	public $name = 'Trafficfee';
	public $uses = array('User', 'Trafficfee', 'Quotation', 'Logs');
	public $layout = 'dafault';

	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'
	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;
	private $debug = false;
	private $flag = false;

    function beforeFilter() {
	//	define("Classes", $_SERVER["DOCUMENT_ROOT"]."/cakephp/class/");
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");
		
		if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
		}

		$this->set('main_title', "通行料金");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Trafficfee
		$this->set('URL_SELF', $this->URL_SELF);

		//$username = $this->Auth->user('username');
		//$this->set('username', $username);
		
		//$username = $this->User->field('User', array('username' => $username));
		//$this->set('username', $username);
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/Trafficfee_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "通行料金",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "通行料金";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}



	/* =================== 　通行料金検索　 ======================= */
	public function search($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		//if($user0['User']['category'] == 0){
		//	$this->set('error_message', "このメニューは利用ができません。");
		//	//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		//}
		$this->set('main_title', '通行料金(一覧)');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Trafficfee', 'search');
		$id = $this->Common->getPost($this, 'Trafficfee', 'id');
		
		$use_date1 = $this->Common->getPost($this, 'Trafficfee', 'use_date1');
		$use_date2 = $this->Common->getPost($this, 'Trafficfee', 'use_date2');

		if(!$use_date1){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			$use_date1 = $a[0];
			$this->set('use_date1', 	$use_date1);
		}
//debug($use_date1);

		if(!$use_date2){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			$use_date2 = $a[count($a)-1];
			$this->set('use_date2', 	$use_date2);
		}
//debug($use_date2);

		$car_plate = $this->Common->getPost($this, 'Trafficfee', 'car_plate');
		$use_section = $this->Common->getPost($this, 'Trafficfee', 'use_section');
		$amount = $this->Common->getPost($this, 'Trafficfee', 'amount');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Trafficfee', 'page');
		$direction = $this->Common->getPost($this, 'Trafficfee', 'direction');
		$sort = $this->Common->getPost($this, 'Trafficfee', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));

		if($use_date1 and $use_date2)
			$condition = array_merge_recursive($condition, array('use_date BETWEEN ? AND ?' => array($use_date1, $use_date2)));

		if($car_plate)
			$condition = array_merge_recursive($condition, array( "car_plate like" => '%'.$car_plate.'%'));

		if($use_section)
			$condition = array_merge_recursive($condition, array( "use_section like" => '%'.$use_section.'%'));

		if($user0['User']['id'] > 3){
			$condition = array_merge_recursive($condition, array( "car_plate Not like" => '%6667%'));
		}


		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "use_date1" => urlencode($use_date1),
				     "use_date2" => urlencode($use_date2),

				     "car_plate" => urlencode($car_plate),
				     "use_section" => urlencode($use_section),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Trafficfee' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Trafficfee');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'trafficfee','action'=>'search', 'page:1/direction:asc/sort:id'));
		}
	}

	/* =================== 　通行料金検索　 ======================= */
	public function search2($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		//if($user0['User']['category'] == 0){
		//	$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		//}
		$this->set('main_title', '通行料金(日毎)');
		$this->set('sub_title', '検索');
		
		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Trafficfee', 'search');
		$id = $this->Common->getPost($this, 'Trafficfee', 'id');
		if($this->flag == false){
			//$this->flag = $this->MakeTrafficfee();
		}
		
		$use_date1 = $this->Common->getPost($this, 'Trafficfee', 'use_date1');
		$use_date2 = $this->Common->getPost($this, 'Trafficfee', 'use_date2');

		if(!$use_date1){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			if(count($a) > 0)
				$use_date1 = $a[0];
			$this->set('use_date1', 	$use_date1);
		}
//debug($use_date1);

		if(!$use_date2){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			if(count($a) > 0)
				$use_date2 = $a[count($a)-1];
			$this->set('use_date2', 	$use_date2);
		}
//debug($use_date2);

		$car_plate = $this->Common->getPost($this, 'Trafficfee', 'car_plate');
		$use_section = $this->Common->getPost($this, 'Trafficfee', 'use_section');
		$amount = $this->Common->getPost($this, 'Trafficfee', 'amount');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Trafficfee', 'page');
		$direction = $this->Common->getPost($this, 'Trafficfee', 'direction');
		$sort = $this->Common->getPost($this, 'Trafficfee', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("ids" => $id));

		if($use_date1 and $use_date2)
			$condition = array_merge_recursive($condition, array('use_date BETWEEN ? AND ?' => array($use_date1, $use_date2)));

		if($car_plate)
			$condition = array_merge_recursive($condition, array( "car_plate like" => '%'.$car_plate.'%'));

		if($use_section)
			$condition = array_merge_recursive($condition, array( "use_section like" => '%'.$use_section.'%'));

		if($user0['User']['id'] > 3){
			$condition = array_merge_recursive($condition, array( "car_plate Not like" => '%6667%'));
		}

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "use_date1" => urlencode($use_date1),
				     "use_date2" => urlencode($use_date2),

				     "car_plate" => urlencode($car_plate),
				     "use_section" => urlencode($use_section),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Trafficfee' => array(
			'fields' => array('GROUP_CONCAT(`id`) as ids', 'car_plate', 'use_date', 'GROUP_CONCAT(`use_section`) as section', 'sum(`amount`) as total'),
			'group' => array('car_plate', 'use_date'),
			'conditions' => $condition, 
			'limit'=>1000, 
			'sort'=>$sort, 
			'direction'=>$direction)
			);
		$this->data = $this->paginate('Trafficfee');
//debug($this->data);
		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'trafficfee','action'=>'search2', 'page:1/direction:asc/sort:id'));
		}
	}


	/* =================== 　通行料金検索　 ======================= */
	public function search3($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		//if($user0['User']['category'] == 0){
		//	$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		//}
		$this->set('main_title', '通行料金(車No毎)');
		$this->set('sub_title', '検索');
		
		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Trafficfee', 'search');
		$id = $this->Common->getPost($this, 'Trafficfee', 'id');
		if($this->flag == false){
			//$this->flag = $this->MakeTrafficfee();
		}
		
		$use_date1 = $this->Common->getPost($this, 'Trafficfee', 'use_date1');
		$use_date2 = $this->Common->getPost($this, 'Trafficfee', 'use_date2');

		if(!$use_date1){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			if(count($a) > 0)
				$use_date1 = $a[0];
			$this->set('use_date1', 	$use_date1);
		}
//debug($use_date1);

		if(!$use_date2){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			if(count($a) > 0)
				$use_date2 = $a[count($a)-1];
			$this->set('use_date2', 	$use_date2);
		}
//debug($use_date2);

		$car_plate = $this->Common->getPost($this, 'Trafficfee', 'car_plate');
		$use_section = $this->Common->getPost($this, 'Trafficfee', 'use_section');
		$amount = $this->Common->getPost($this, 'Trafficfee', 'amount');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Trafficfee', 'page');
		$direction = $this->Common->getPost($this, 'Trafficfee', 'direction');
		$sort = $this->Common->getPost($this, 'Trafficfee', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));

		//if($use_date1 and $use_date2)
		//	$condition = array_merge_recursive($condition, array('use_date BETWEEN ? AND ?' => array($use_date1, $use_date2)));

		if($car_plate)
			$condition = array_merge_recursive($condition, array( "car_plate like" => '%'.$car_plate.'%'));

		if($use_section)
			$condition = array_merge_recursive($condition, array( "use_section like" => '%'.$use_section.'%'));

		if($user0['User']['id'] > 3){
			$condition = array_merge_recursive($condition, array( "car_plate Not like" => '%6667%'));
		}

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "use_date1" => urlencode($use_date1),
				     "use_date2" => urlencode($use_date2),

				     "car_plate" => urlencode($car_plate),
				     "use_section" => urlencode($use_section),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Trafficfee' => array(
			'fields' => array('GROUP_CONCAT(`id`) as ids', 
				'car_plate', 'GROUP_CONCAT(`use_date`) as dates', 
				'GROUP_CONCAT(`use_section`) as sections', 
				'sum(`amount`) as total'),
			'group' => array('car_plate'),
			'conditions' => $condition, 
			'limit'=>100, 
			'sort'=>$sort, 
			'direction'=>$direction)
			);

		$this->data = $this->paginate('Trafficfee');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'trafficfee','action'=>'search3', 'page:1/direction:asc/sort:car_plate'));
		}
	}






	/* =================== 　通行料金検索　 ======================= */
	public function search4($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		//if($user0['User']['category'] == 0){
		//	$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		//}
		$this->set('main_title', '通行料金(車No毎)');
		$this->set('sub_title', '検索');
		
		if(!empty($this->data)){
//debug($this->data);
//exit();
			$this->search_export($this->data);
		}
//debug($use_date1);

		$a = $this->Common->GetModelAll("Trafficfee", "use_date");
		$use_date1 = $a[0];
		$use_date2 = $a[count($a)-1];
		$this->set('use_date1', 	$use_date1);
		$this->set('use_date2',	$use_date2);
//debug($use_date2);

		$car_plate = $this->Common->getPost($this, 'Trafficfee', 'car_plate');
		$use_section = $this->Common->getPost($this, 'Trafficfee', 'use_section');
		$amount = $this->Common->getPost($this, 'Trafficfee', 'amount');

		if($user0['User']['id'] > 3){
			$condition = array( "car_plate Not like" => '%6667%' );
			//$condition = array_merge_recursive($condition, array( "car_plate Not like" => '%2180%'));
			//$condition = array( 'OR' => array("car_plate Not like" => '%6667%', "car_plate Not like" => '%2180%') );
		}

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Trafficfee', 'page');
		$direction = $this->Common->getPost($this, 'Trafficfee', 'direction');
		$sort = $this->Common->getPost($this, 'Trafficfee', 'sort');

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("use_date1" => urlencode($use_date1), "use_date2" => urlencode($use_date2));
		/* ページネーションの作成 */
		$this->paginate = array('Trafficfee' => array(
			'fields' => array('GROUP_CONCAT(`id`) as ids', 
				'car_plate', 'GROUP_CONCAT(`use_date`) as dates', 
				//'GROUP_CONCAT(`use_section`) as sections', 
				'GROUP_CONCAT(`amount`) as amounts', 
				'sum(`amount`) as total'),
			'group' => array('car_plate'),
			//'conditions' => $condition, 
			//'limit'=>100, 
			'sort'=>$sort, 
			'direction'=>$direction)
			);

		$this->data = $this->paginate('Trafficfee');
//debug($this->data);
//exit();
//debug($colspan);

		$colspan = intval(date("m", strtotime($use_date2))) + 3;
		for($i=0; $i<count($this->data); $i++){
//debug($this->data[$i]['Trafficfee']['car_plate']);
			 $mm['2020-12'] =  $mm['2020-11'] =  $mm['2020-10'] = 0;
			for($j=1; $j<=$colspan-3; $j++)
				 $mm['2021-'.sprintf('%02d', $j)] = 0;
			
			$data2 = $this->Trafficfee->find('all', array(
				'fields' => array(
					"DATE_FORMAT(`use_date`, '%Y-%m') as udate",
					//"GROUP_CONCAT(`amount`) as amounts",
					'sum(`amount`) as total',
					"GROUP_CONCAT(`car_plate`) as car_plates"),
				'conditions' => array('car_plate' => $this->data[$i]['Trafficfee']['car_plate']),
				'group' => array( 'car_plate', "DATE_FORMAT(`use_date`, '%Y%m')"),
			));
//$log = $this->User->getDataSource()->getLog(false, false);       
//debug($log);
//debug($data2);
//exit();
			$total[$i] = 0;
			for($j=0; $j<count($data2); $j++){
				foreach( $mm as $key => $value){
					//$this->data[$i]['Trafficfee'][$key] = 0;
					if( $data2[$j][0]['udate'] == $key ){
						$this->data[$i]['Trafficfee'][$key] = intval($data2[$j][0]['total']);
						break;
					}
//debug("★".$data2[$j][0]['udate']."_".$key);					
				}
				$total[$i] += intval($data2[$j][0]['total']);
			}
			$this->data[$i]['Trafficfee']['sub_total'] = $total[$i];
//debug($this->data[$i]['Trafficfee']);
//debug($total[$i]);
//exit();
		}
//debug($this->data[0]['Trafficfee']);
//exit();
//debug($this->data);
//exit();
		$i = 0;
		foreach( $mm as $key => $value){
			$mmm[$i++] = $key;
		}


		$this->set('mmm', $mmm);
		$this->set('colspan', $colspan);
		$this->set('total', $total);

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

	}




	function search_export($data){
		$excel_file0 = "trafficfee.xls";
		$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/trafficfee/ORG/".$excel_file0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$excel_file = date("YmdHis")."_".$excel_file0;
		$excel_file = date("YmdHi")."_".$excel_file0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/trafficfee/".$excel_file);
		//$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/trafficfee/20210516_".$excel_file0);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);

		/** PHPExcelを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		// PHPExcelオブジェクトを生成する
		//$obj = PHPExcel_IOFactory::createReader("Excel2007");
		//$obj = PHPExcel_IOFactory::createReader($book, 'Excel5');
		//$book = $obj->load($xcellFile);

		//$book = new PHPExcel();
		$book = PHPExcel_IOFactory::load($xcellFile);

		//$data = $this->Trafficfee->find('all', array('conditions' => $condition, 'order' => [ 'id'=>'asc'] ));
		
		//$sql = "SELECT * FROM `trafficfee2` WHERE `ApplicationDate` BETWEEN '".$first_date."' and '".$last_date."' ORDER BY `ApplicationDate` asc, `deploy_name` asc, CAST(replace(site_time1, ':', '') AS UNSIGNED) asc, `id` asc ";
		//$data = $this->trafficfee2->query($sql);

//$log = $this->trafficfee2->getDataSource()->getLog(false, false);       
//debug($log);
		$data_count = count($data)-1;
//debug($data_count);
//debug($data);
//exit();

		$sh=0;
		//for($sh=0; $sh<5; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<$data_count; $i++){


				$colspan = $data['Trafficfee']['colspan'];
				$mmm = $data['Trafficfee']['mmm'];
				for($j=0; $j<$colspan; $j++){
					$mm[$j] = $mmm[$j];
				}
//debug($mm);

				$car_plate = $data[$i]['Trafficfee']['car_plate'];
				$m[0] = $data[$i]['Trafficfee']['2020-10'];
				$m[1] = $data[$i]['Trafficfee']['2020-11'];
				$m[2] = $data[$i]['Trafficfee']['2020-12'];
				for($j=1; $j<=($colspan-3); $j++){
					$m[2+$j] = $data[$i]['Trafficfee']['2021-'.sprintf('%02d', $j)];
				}
				$sub_total = $data[$i]['Trafficfee']['sub_total'];

//debug($car_plate );
//debug($m);
//debug($sub_total );
//exit();

				// セルに値をセットする
				//$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i );
				$sheet->setCellValueByColumnAndRow( 1, $i + 2,  $car_plate );
				for($j=0; $j<$colspan; $j++){
					$sheet->setCellValueByColumnAndRow( 2+$j, $i + 2,  $m[$j]);
				}
				$sheet->setCellValueByColumnAndRow( $colspan+2, $i + 2, $sub_total );
//break;
			}
			
			$sheet->setCellValueByColumnAndRow( 0, $i + 2,  "" );
			$sheet->setCellValueByColumnAndRow( 1, $i + 2,  "合計" );
			for($j=0; $j<$colspan; $j++){
				$sheet->setCellValueByColumnAndRow( 2+$j, $i + 2,  $data['Trafficfee']['m_total'][$j] );
			}
			$sheet->setCellValueByColumnAndRow( $colspan+2, $i + 2, $data['Trafficfee']['m_total'][$j] );
			
			//-----------------------------------------------
		
		//}//endfor $sh
		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($book, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel5');
		$writer->save($xcellFile);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		//exit();
	
		//$this->redirect(array('controller'=>'invoice','action'=>'search'));
		
	}







	/* =================== 通行料金詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}

		$this->set('main_title', '通行料金(一覧)');
		$this->set('sub_title', '通行料金　＞　詳細');
		$this->set('sub_title2', '通行料金　＞　詳細');

		if($arg){
			$this->Trafficfee->id = $arg;
		}else{
			$this->Trafficfee->id = $this->Common->getPost($this, 'Trafficfee', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Trafficfee->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->Trafficfee->find('count', array('conditions' => array('category LIKE' => $this->data['Trafficfee']['category'],
																		'id !=' => $this->Trafficfee->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "データが既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'Trafficfee', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			if(false){
				if(!$this->Trafficfee->save($this->data)){		//更新
					$errors = $this->Trafficfee->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
				}
			}
		}
		$this->set('category', $user0['User']['category']);
	}



	/* =================== 通行料金詳細 ======================= */
	function search_detail2($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}
		
		//implode(",", explode(",", $arg));

		$this->set('main_title', '通行料金(日毎)');
		$this->set('sub_title', '通行料金　＞　詳細');
		$this->set('sub_title2', '通行料金　＞　詳細');

		if(empty($this->data)){
			$this->data = $this->Trafficfee->find('all', 
				array('conditions' => array('Trafficfee.id' => explode(",", $arg))
				));
//debug($arg);
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{

		}
		$this->set('category', $user0['User']['category']);
	}


	/* =================== 通行料金詳細 ======================= */
	function search_detail3($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}
		
		//implode(",", explode(",", $arg));

		$this->set('main_title', '通行料金(車No毎)');
		$this->set('sub_title', '通行料金　＞　詳細');
		$this->set('sub_title2', '通行料金　＞　詳細');

		if(empty($this->data)){
			$this->data = $this->Trafficfee->find('all', 
				array('conditions' => array('Trafficfee.id' => explode(",", $arg))
				));
//debug($arg);
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{

		}
		$this->set('category', $user0['User']['category']);
	}



	/* =================== 通行料金修正 ======================= */
	function search_edit($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}

		$this->set('main_title', '通行料金');
		$this->set('sub_title', '通行料金　＞　修正');

		if($arg)
			$this->User->id = $arg;
		else
			$this->User->id = $this->Common->getPost($this, 'User', 'id');

		if(empty($this->data)){
			$this->data = $this->User->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->User->find('count', array('conditions' => array('category LIKE' => $this->data['User']['category'],
																		'id !=' => $this->User->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'User', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			//if(false){
				if(!$this->User->save($this->data)){		//更新
					$errors = $this->User->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
				}
			//}
		}
		$this->set('category', $user0['User']['category']);
	}

	/* =================== 通行料金削除 ======================= */
	function search_delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}

		$this->set('main_title', '通行料金');
		$this->set('sub_title', '通行料金　＞　削除');

		if($arg)
			$this->User->id = $arg;
		else
			$this->User->id = $this->Common->getPost($this, 'User', 'id');

		if(empty($this->data)){
			$this->data = $this->User->read();	//読み出し
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->User->delete($this->User->id)){		//削除
				$errors = $this->User->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
	}
	/* =================== 通行料金新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}

		$this->set('main_title', '通行料金情報');
		$this->set('sub_title', '通行料金　＞　新規作成');

		if(empty($this->data)){
			//$this->data['Trafficfee']['category'] = null;
			//$this->data['Trafficfee']['password'] = null;
			//$this->data['Trafficfee']['use_date'] = 0;
			//$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);

			$count = $this->Trafficfee->find('count', array('conditions' => array('category LIKE' => $this->data['Trafficfee']['category'])));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}

			$this->data['Trafficfee']['id'] = null;
//print_r($this->data); echo "<br>";
			if(!$this->Trafficfee->save($this->data)){		//新規作成
				$errors = $this->Trafficfee->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
			}else
				$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
	}


	
	function download($arg=""){
		$this->set('main_title', "ダウンロード");
		$this->set('sub_title',  '');
		
		if($arg){
			$this->Trafficfee->id = $arg;
		}else{
			$this->Trafficfee->id = $this->Trafficfee->id = $this->Common->getPost($this, 'Trafficfee', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Trafficfee->read();	//読み出し
			$this->xlsx_write_proc();
		}else{
		
		}
//debug($up_file);
		$this->set('data', $this->data);
	}

	private function xlsx_write_proc(){
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/Trafficfee/excel/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/Trafficfee/excel/" );
		//$filename = "Trafficfee_form.xlsx";
		$filename = "Trafficfee_form.xls";

		$excel_file = $path.$filename;
		if(file_exists($excel_file))
			unlink($excel_file);
		copy($path0.$filename, $excel_file);
		
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** IO Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );
//print_r($this->data); echo "<br>";
        //App::import('vendor','phpexcel/phpexcel');

        //ファイルを読み込む
        //$objReader = PHPExcel_IOFactory::createReader('Excel2007');
		$objReader = PHPExcel_IOFactory::createReader('Excel5');

        $objPHPExcel = $objReader->load($excel_file);
		$objPHPExcel->setActiveSheetIndex(0);
		
        $sheet = $objPHPExcel->getActiveSheet();
        //$sheet->setCellValueByColumnAndRow($c, $r+1, $v);

		$sheet->setCellValue('B6', $this->data2['Quotation']['dest_up']);
		$sheet->setCellValue('B7', $this->data2['Quotation']['dest_low']);
		$sheet->setCellValue('M7', $this->data2['Quotation']['address']);

		$sheet->setCellValue('B14', $this->data2['Quotation']['OrderNo_up']);
		$sheet->setCellValue('B17', $this->data2['Quotation']['OrderNo_mid']);
		$sheet->setCellValue('B20', $this->data2['Quotation']['OrderNo_low']);
		
		$sheet->setCellValue('V2', $this->data2['Quotation']['EstimateNo']);
		$sheet->setCellValue('Q6', date('Y年m月d日', strtotime($this->data['Trafficfee']['DeliveryTime'])));
		$sheet->setCellValue('R26', $this->data2['Quotation']['OrderNo']);
		
		$sheet->setCellValue('M28', $this->data2['Quotation']['Total_Amount']);
		
		$a = explode("/", $this->data2['Quotation']['ProductName']);
		$b = explode("/", $this->data2['Quotation']['quantity']);
		$c = explode("/", $this->data2['Quotation']['Qty_assist']);
		$d = explode("/", $this->data2['Quotation']['price']);
		$e = explode("/", $this->data2['Quotation']['Amount_line']);
		$f = explode("/", $this->data2['Quotation']['remark']);

//debug(count($a));
		if(count($a) >= 12)
			$n = 11;
		else
			$n = count($a);

		for($i=0; $i<$n; $i++){
			if(trim($a[$i].$b[$i].$c[$i].$d[$i].$e[$i]) != ""){
	        	$sheet->setCellValueByColumnAndRow(2, 34+$i, $this->zero_check( $a[$i] )); //C24
	        	$sheet->setCellValueByColumnAndRow(9, 34+$i, $this->zero_check( $b[$i] )); //J24
	        	$sheet->setCellValueByColumnAndRow(11, 34+$i, $this->zero_check( $c[$i] )); //L24
	        	$sheet->setCellValueByColumnAndRow(13, 34+$i, $this->zero_check( $d[$i] )); //N24
	        	$sheet->setCellValueByColumnAndRow(16, 34+$i, $this->zero_check( $e[$i] )); //Q24
	        	$sheet->setCellValueByColumnAndRow(20, 34+$i, $this->zero_check( $f[$i] )); //U24
			}
		}
		
		$sheet->setCellValue('I47', $this->zero_check($this->data2['Quotation']['labor_cost']));
		$sheet->setCellValue('I48', $this->zero_check($this->data2['Quotation']['other_expense']));
		$sheet->setCellValue('I43', $this->zero_check($this->data2['Quotation']['discount']));

		$sheet->setCellValue('S47', $this->zero_check($this->data2['Quotation']['subTotal']));
		$sheet->setCellValue('S48', $this->zero_check($this->data2['Quotation']['Tax_calc_frame']));
		$sheet->setCellValue('S49', $this->zero_check($this->data2['Quotation']['Total_Amount']));

		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel5");
		$writer->save($excel_file);

//debug($this->data['Quotation']['dest_up']);
//debug($this->data['Quotation']['dest_low']);
		//$excel_file = $this->ConvPath( WWW_ROOT."files/quotation_form.xlsx" );
		
		$filename = $this->data2['Quotation']['dest_low'];
		if($filename == "")
			$filename = $this->data2['Quotation']['dest_up'];
		//$filename = date("Ymd_", strtotime($this->data2['Quotation']['estimate_date'])) . $filename . "_通行料金.xlsx";
		$filename = date("Ymd_", strtotime($this->data2['Quotation']['estimate_date'])) . $filename . "_通行料金.xls";
		// $this->Common->to_utf8();
		Configure::write('debug', 0);       // debugコードを非表示
		header("Content-disposition: attachment; filename={$filename}");    //ダウンロードさせるため
		header("Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; name={$filename}");
 
		$result = file_get_contents( $excel_file );   // ダウンロードするデータの取得
		print( $result );           // 出力
 //exit();
		return $filename;
	}

	private function zero_check($n){
		if($n == "")
			return "";
		elseif(is_numeric($n))
			return number_format(intval( $n ));
		else
			return $n;
	}

}