<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/Invoice/

class InvoiceController extends AppController {
	public $name = 'Invoice';
	public $uses = array('User', 'Invoice', 'Invoice2', 'Quotation', 'Logs');
	public $layout = 'dafault';

	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'
	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;
	private $debug = false;

    function beforeFilter() {
	//	define("Classes", $_SERVER["DOCUMENT_ROOT"]."/cakephp/class/");
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");
		
		if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
		}

		$this->set('main_title', "商品・請求書");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Invoice
		$this->set('URL_SELF', $this->URL_SELF);

		//$username = $this->Auth->user('username');
		//$this->set('username', $username);
		
		//$username = $this->User->field('User', array('username' => $username));
		//$this->set('username', $username);
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/invoice_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'invoice','action'=>'search'));
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "商品・請求書",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "商品・請求書";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}



	/* =================== 　商品・請求書検索　 ======================= */
	public function search($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'invoice','action'=>'index'));
		}
		$this->set('main_title', '商品・請求書');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Invoice', 'search');
		$id = $this->Common->getPost($this, 'Invoice', 'id');
		$company = $this->Common->getPost($this, 'Invoice', 'company');

		$order_date = $this->Common->getPost($this, 'Invoice', 'order_date');
		$order_dateY = $this->Common->getPost($this, 'Invoice', 'order_dateY');
		$order_dateM = $this->Common->getPost($this, 'Invoice', 'order_dateM');
		$order_dateD = $this->Common->getPost($this, 'Invoice', 'order_dateD');

		$subject = $this->Common->getPost($this, 'Invoice', 'subject');

		$delivery_date = $this->Common->getPost($this, 'Invoice', 'delivery_date');
		$delivery_dateY = $this->Common->getPost($this, 'Invoice', 'delivery_dateY');
		$delivery_dateM = $this->Common->getPost($this, 'Invoice', 'delivery_dateM');
		$delivery_dateD = $this->Common->getPost($this, 'Invoice', 'delivery_dateD');

		$sales_department = $this->Common->getPost($this, 'Invoice', 'sales_department');


		$product_name = $this->Common->getPost($this, 'Invoice', 'product_name');

		$product_code = $this->Common->getPost($this, 'Invoice', 'product_code');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Invoice', 'page');
		$direction = $this->Common->getPost($this, 'Invoice', 'direction');
		$sort = $this->Common->getPost($this, 'Invoice', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($company)
			//$condition = array_merge_recursive($condition, array( "company like" => '%'.mb_convert_encoding($username, "UTF-8", "SJIS").'%'));
			$condition = array_merge_recursive($condition, array( "company like" => '%'.$company.'%'));
		if($order_date)
			$condition = array_merge_recursive($condition, array( "order_date like" => '%'.$order_date.'%'));

	
		if($order_date)
			$condition = array_merge_recursive($condition, array( "order_date like" => $order_date));
		if($order_dateY and !$order_dateM and !$order_dateD)
			$condition = array_merge_recursive($condition, array('order_date BETWEEN ? AND ?' => array($order_dateY.'-01-01', $order_dateY.'-12-31')));

		if($order_dateY and $order_dateM and !$order_dateD){
			$month = $order_dateY."-".$order_dateM;
			$firstDate = date('Y-m-d', strtotime('first day of ' . $month));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $month));
			$condition = array_merge_recursive($condition, array('order_date >=' => $firstDate, 'order_date <=' => $lastDate));
		}

		if($order_dateY and $order_dateM and $order_dateD){
			$condition = array_merge_recursive($condition, array('order_date' => $order_dateY."-".$order_dateM."-".$order_dateD ));
//debug($order_dateY."-".$order_dateM."-".$order_dateD);
		}
	//------------------------------

		if($subject)
			$condition = array_merge_recursive($condition, array( "subject like" => '%'.$subject.'%'));

	//-------------------------
		if($delivery_date)
			$condition = array_merge_recursive($condition, array( "delivery_date like" => $delivery_date));
		if($delivery_dateY and !$delivery_dateM and !$delivery_dateD)
			$condition = array_merge_recursive($condition, array('delivery_date BETWEEN ? AND ?' => array($delivery_dateY.'-01-01', $delivery_dateY.'-12-31')));

		if($delivery_dateY and $delivery_dateM and !$delivery_dateD){
			$month = $delivery_dateY."-".$delivery_dateM;
			$firstDate = date('Y-m-d', strtotime('first day of ' . $month));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $month));
			$condition = array_merge_recursive($condition, array('delivery_date >=' => $firstDate, 'delivery_date <=' => $lastDate));
		}

		if($delivery_dateY and $delivery_dateM and $delivery_dateD){
			$condition = array_merge_recursive($condition, array('delivery_date' => $delivery_dateY."-".$delivery_dateM."-".$delivery_dateD ));
//debug($delivery_dateY."-".$delivery_dateM."-".$delivery_dateD);
		}
	//--------------------------
		if($sales_department)
			$condition = array_merge_recursive($condition, array( "sales_department like" => $sales_department));

		if($product_name)
			$condition = array_merge_recursive($condition, array( "product_name like" => '%'.$product_name.'%'));
		if($product_code)
			$condition = array_merge_recursive($condition, array( "product_code like" => '%'.$product_code.'%'));

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "company" => urlencode($company),

				     "order_date" => urlencode($order_date),
				     "order_dateY" => urlencode($order_dateY),
				     "order_dateM" => urlencode($order_dateM),
				     "order_dateD" => urlencode($order_dateD),

				     "subject" => urlencode($subject),

				     "delivery_date" => urlencode($delivery_date),
				     "delivery_dateY" => urlencode($delivery_dateY),
				     "delivery_dateM" => urlencode($delivery_dateM),
				     "delivery_dateD" => urlencode($delivery_dateD),

				     "sales_department" => urlencode($sales_department),
				     "product_name" => urlencode($product_name),
				     "product_code" => urlencode($product_code),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Invoice' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Invoice');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'invoice','action'=>'search', 'page:1/direction:asc/sort:id'));
		}
	}

	/* =================== 　商品・請求書検索　 ======================= */
	public function search2($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Invoice','action'=>'index'));
		}
		$this->set('main_title', '商品検索2・請求書');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Invoice2', 'search');
		$id = $this->Common->getPost($this, 'Invoice2', 'id');
		$company = $this->Common->getPost($this, 'Invoice2', 'company');
		$product_name = $this->Common->getPost($this, 'Invoice2', 'product_name');
		$product_code = $this->Common->getPost($this, 'Invoice2', 'product_code');
		$products = $this->Common->getPost($this, 'Invoice2', 'products');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Invoice2', 'page');
		$direction = $this->Common->getPost($this, 'Invoice2', 'direction');
		$sort = $this->Common->getPost($this, 'Invoice2', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($company)
			$condition = array_merge_recursive($condition, array( "company like" => '%'.$company.'%'));

		if($product_name)
			$condition = array_merge_recursive($condition, array( "product_name like" => '%'.$product_name.'%'));

		if($product_code)
			$condition = array_merge_recursive($condition, array( "product_code like" => '%'.$product_code.'%'));

		if($products){
			$condition = array_merge_recursive($condition, array( 'OR' => array("product_code like" => '%'.$products.'%', "product_name like" => '%'.$products.'%') ));
		}
		//$this->set('condition', $condition);

//debug($this->params);
		$submit = $this->Common->getPost($this, 'Invoice2', 'submit');
//debug($submit);
		if($submit == "エクセル検索出力"){
			$this->search_export($condition);
		}

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "company" => urlencode($company),
				     "product_name" => urlencode($product_name),
				     "product_code" => urlencode($product_code),
		);
//debug($condition);

		/* ページネーションの作成 */
		$this->paginate = array('Invoice2' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Invoice2');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'Invoice','action'=>'search2', 'page:1/direction:asc/sort:id'));
		}
	}

	function search_export($condition){
		$excel_file0 = "invoice.xls";
		$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/invoice2/ORG/".$excel_file0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$excel_file = date("YmdHis")."_".$excel_file0;
		$excel_file = date("YmdHi")."_".$excel_file0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/invoice2/".$excel_file);
		//$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/invoice/20210516_".$excel_file0);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);

		/** PHPExcelを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		// PHPExcelオブジェクトを生成する
		//$obj = PHPExcel_IOFactory::createReader("Excel2007");
		//$obj = PHPExcel_IOFactory::createReader($book, 'Excel5');
		//$book = $obj->load($xcellFile);

		//$book = new PHPExcel();
		$book = PHPExcel_IOFactory::load($xcellFile);

		$data = $this->Invoice2->find('all', array('conditions' => $condition, 'order' => [ 'id'=>'asc'] ));
		
		//$sql = "SELECT * FROM `invoice2` WHERE `ApplicationDate` BETWEEN '".$first_date."' and '".$last_date."' ORDER BY `ApplicationDate` asc, `deploy_name` asc, CAST(replace(site_time1, ':', '') AS UNSIGNED) asc, `id` asc ";
		//$data = $this->Invoice2->query($sql);

//$log = $this->Invoice2->getDataSource()->getLog(false, false);       
//debug($log);
		$data_count = count($data);
//debug($data_count);
//debug($data);
//exit();

		$sh=0;
		//for($sh=0; $sh<5; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<$data_count; $i++){
				// セルに値をセットする
				//$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $data[$i]['Invoice2']['id']);
				$sheet->setCellValueByColumnAndRow( 1, $i + 2,  $data[$i]['Invoice2']['company']);
				$sheet->setCellValueByColumnAndRow( 2, $i + 2,  $data[$i]['Invoice2']['product_name']);
				$sheet->setCellValueByColumnAndRow( 3, $i + 2,  $data[$i]['Invoice2']['product_code']);
				$sheet->setCellValueByColumnAndRow( 4, $i + 2,  $data[$i]['Invoice2']['unit']);
				$sheet->setCellValueByColumnAndRow( 5, $i + 2,  $data[$i]['Invoice2']['unit_price']);
				$sheet->setCellValueByColumnAndRow( 6, $i + 2,  $data[$i]['Invoice2']['a_unit_price']);
				$sheet->setCellValueByColumnAndRow( 7, $i + 2,  $data[$i]['Invoice2']['discount_rate']);
				//$sheet->setCellValueByColumnAndRow( 8, $i + 2,  $data[$i]['Invoice2']['filename']);
				//$sheet->setCellValueByColumnAndRow( 9, $i + 2,  mb_convert_kana($data[$i]['Invoice2']['pin_id'],'K','utf-8'));
				//$sheet->setCellValueByColumnAndRow( 10, $i + 2,  $data[$i]['Invoice2']['pin_id']);
//break;
			}
			//-----------------------------------------------
		
		//}//endfor $sh
		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($book, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel5');
		$writer->save($xcellFile);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		//exit();
	
		//$this->redirect(array('controller'=>'invoice','action'=>'search'));
		
	}

	/* =================== 商品・請求書詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Invoice','action'=>'index'));
		}

		$this->set('main_title', '商品・請求書');
		$this->set('sub_title', '商品・請求書　＞　詳細');
		$this->set('sub_title2', '見積書　＞　詳細');

		if($arg){
			$this->Invoice->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Invoice->id = $this->Common->getPost($this, 'Invoice', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Invoice->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
			$this->set('data2', $this->data2);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->Invoice->find('count', array('conditions' => array('category LIKE' => $this->data['Invoice']['category'],
																		'id !=' => $this->Invoice->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "データが既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'Invoice', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			if(false){
				if(!$this->Invoice->save($this->data)){		//更新
					$errors = $this->Invoice->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'invoice','action'=>'search'));
				}
			}
		}
		$this->set('category', $user0['User']['category']);
	}
	/* =================== 商品・請求書修正 ======================= */
	function search_edit($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Invoice','action'=>'index'));
		}

		$this->set('main_title', '商品・請求書');
		$this->set('sub_title', '商品・請求書　＞　修正');

		if($arg)
			$this->User->id = $arg;
		else
			$this->User->id = $this->Common->getPost($this, 'User', 'id');

		if(empty($this->data)){
			$this->data = $this->User->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->User->find('count', array('conditions' => array('category LIKE' => $this->data['User']['category'],
																		'id !=' => $this->User->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'User', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			//if(false){
				if(!$this->User->save($this->data)){		//更新
					$errors = $this->User->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'invoice','action'=>'search'));
				}
			//}
		}
		$this->set('category', $user0['User']['category']);
	}

	/* =================== 商品・請求書削除 ======================= */
	function search_delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Invoice','action'=>'index'));
		}

		$this->set('main_title', '商品・請求書');
		$this->set('sub_title', '商品・請求書　＞　削除');

		if($arg)
			$this->User->id = $arg;
		else
			$this->User->id = $this->Common->getPost($this, 'User', 'id');

		if(empty($this->data)){
			$this->data = $this->User->read();	//読み出し
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->User->delete($this->User->id)){		//削除
				$errors = $this->User->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'invoice','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
	}
	/* =================== 商品・請求書新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Invoice','action'=>'index'));
		}

		$this->set('main_title', '商品・請求書情報');
		$this->set('sub_title', '商品・請求書　＞　新規作成');

		if(empty($this->data)){
			//$this->data['Invoice']['category'] = null;
			//$this->data['Invoice']['password'] = null;
			//$this->data['Invoice']['order_date'] = 0;
			//$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);

			$count = $this->Invoice->find('count', array('conditions' => array('category LIKE' => $this->data['Invoice']['category'])));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}

			$this->data['Invoice']['id'] = null;
//print_r($this->data); echo "<br>";
			if(!$this->Invoice->save($this->data)){		//新規作成
				$errors = $this->Invoice->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
			}else
				$this->redirect(array('controller'=>'invoice','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
	}


	
	function download($arg=""){
		$this->set('main_title', "ダウンロード");
		$this->set('sub_title',  '');
		
		if($arg){
			$this->Invoice->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Quotation->id = $this->Invoice->id = $this->Common->getPost($this, 'Invoice', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Invoice->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
			$this->xlsx_write_proc();
		}else{
		
		}
//debug($up_file);
		$this->set('data', $this->data);
	}

	private function xlsx_write_proc(){
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/invoice/excel/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/invoice/excel/" );
		//$filename = "invoice_form.xlsx";
		$filename = "invoice_form.xls";

		$excel_file = $path.$filename;
		if(file_exists($excel_file))
			unlink($excel_file);
		copy($path0.$filename, $excel_file);
		
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** IO Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );
//print_r($this->data); echo "<br>";
        //App::import('vendor','phpexcel/phpexcel');

        //ファイルを読み込む
        //$objReader = PHPExcel_IOFactory::createReader('Excel2007');
		$objReader = PHPExcel_IOFactory::createReader('Excel5');

        $objPHPExcel = $objReader->load($excel_file);
		$objPHPExcel->setActiveSheetIndex(0);
		
        $sheet = $objPHPExcel->getActiveSheet();
        //$sheet->setCellValueByColumnAndRow($c, $r+1, $v);

		$sheet->setCellValue('B6', $this->data2['Quotation']['dest_up']);
		$sheet->setCellValue('B7', $this->data2['Quotation']['dest_low']);
		$sheet->setCellValue('M7', $this->data2['Quotation']['address']);

		$sheet->setCellValue('B14', $this->data2['Quotation']['subject_up']);
		$sheet->setCellValue('B17', $this->data2['Quotation']['subject_mid']);
		$sheet->setCellValue('B20', $this->data2['Quotation']['subject_low']);
		
		$sheet->setCellValue('V2', $this->data2['Quotation']['estimate_no']);
		$sheet->setCellValue('Q6', date('Y年m月d日', strtotime($this->data['Invoice']['delivery_date'])));
		$sheet->setCellValue('R26', $this->data2['Quotation']['order_no']);
		
		$sheet->setCellValue('M28', $this->data2['Quotation']['total_amount']);
		
		$a = explode("/", $this->data2['Quotation']['product_name']);
		$b = explode("/", $this->data2['Quotation']['quantity']);
		$c = explode("/", $this->data2['Quotation']['qty_assist']);
		$d = explode("/", $this->data2['Quotation']['price']);
		$e = explode("/", $this->data2['Quotation']['amount_line']);
		$f = explode("/", $this->data2['Quotation']['remark']);

//debug(count($a));
		if(count($a) >= 12)
			$n = 11;
		else
			$n = count($a);

		for($i=0; $i<$n; $i++){
			if(trim($a[$i].$b[$i].$c[$i].$d[$i].$e[$i]) != ""){
	        	$sheet->setCellValueByColumnAndRow(2, 34+$i, $this->zero_check( $a[$i] )); //C24
	        	$sheet->setCellValueByColumnAndRow(9, 34+$i, $this->zero_check( $b[$i] )); //J24
	        	$sheet->setCellValueByColumnAndRow(11, 34+$i, $this->zero_check( $c[$i] )); //L24
	        	$sheet->setCellValueByColumnAndRow(13, 34+$i, $this->zero_check( $d[$i] )); //N24
	        	$sheet->setCellValueByColumnAndRow(16, 34+$i, $this->zero_check( $e[$i] )); //Q24
	        	$sheet->setCellValueByColumnAndRow(20, 34+$i, $this->zero_check( $f[$i] )); //U24
			}
		}
		
		$sheet->setCellValue('I47', $this->zero_check($this->data2['Quotation']['labor_cost']));
		$sheet->setCellValue('I48', $this->zero_check($this->data2['Quotation']['other_expense']));
		$sheet->setCellValue('I43', $this->zero_check($this->data2['Quotation']['discount']));

		$sheet->setCellValue('S47', $this->zero_check($this->data2['Quotation']['subtotal']));
		$sheet->setCellValue('S48', $this->zero_check($this->data2['Quotation']['tax_calc_frame']));
		$sheet->setCellValue('S49', $this->zero_check($this->data2['Quotation']['total_amount']));

		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel5");
		$writer->save($excel_file);

//debug($this->data['Quotation']['dest_up']);
//debug($this->data['Quotation']['dest_low']);
		//$excel_file = $this->ConvPath( WWW_ROOT."files/quotation_form.xlsx" );
		
		$filename = $this->data2['Quotation']['dest_low'];
		if($filename == "")
			$filename = $this->data2['Quotation']['dest_up'];
		//$filename = date("Ymd_", strtotime($this->data2['Quotation']['estimate_date'])) . $filename . "_見積書.xlsx";
		$filename = date("Ymd_", strtotime($this->data2['Quotation']['estimate_date'])) . $filename . "_見積書.xls";
		// $this->Common->to_utf8();
		Configure::write('debug', 0);       // debugコードを非表示
		header("Content-disposition: attachment; filename={$filename}");    //ダウンロードさせるため
		header("Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; name={$filename}");
 
		$result = file_get_contents( $excel_file );   // ダウンロードするデータの取得
		print( $result );           // 出力
 //exit();
		return $filename;
	}

	private function zero_check($n){
		if($n == "")
			return "";
		elseif(is_numeric($n))
			return number_format(intval( $n ));
		else
			return $n;
	}

}