<?php
class DeliveryController extends AppController {

//	http://vps.waa.jp/delivery/delivery/
//	http://vps.waa.jp/delivery/delivery/test

	public $name = 'Delivery';

	//public $layout = null;
	public $layout = 'dafault';

	//public $autoRender = false;	// View Off

	//public $uses = null;		// Model Off
	public $uses = array('User', 'Client', 'Delicom', 'Delicom2', 'Delidoc', 'Delitable', 'Order', 'Product', 'Logs');

	//public $components = array('Auth', 'Common', 'Mail', 'Email', 'Excel');	//'Session', , 'Qdmail'
	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'

	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;

    function beforeFilter() {
	//	$this->autoRender = false;     // Viewを使わない
	//	Configure::write('debug', 0);  // debugコードを出さない
	//	define("Classes", $_SERVER["DOCUMENT_ROOT"]."/cakephp/class/");
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

		if($this->Common->CheckUserAuth($this->Auth) == false){
	//		$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
		}

		$this->set('main_title', "スケジュール");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/delivery
		$this->set('URL_SELF', $this->URL_SELF);

		$username = $this->Auth->user('username');
		$this->set('username', $username);
		
		$category = $this->User->field('category', array('username' => $username));
		if($category >= 2)
			$is_admin = true;
		else
			$is_admin = false;
		$this->set('is_admin', $is_admin);
	}

	public function index2($menu="", $year=""){

		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/delivery_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();

		$this->redirect(array('controller'=>'delivery','action'=>'search2', $menu, $year));
	}

	public function index($menu="", $year=""){
		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/delivery_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'delivery','action'=>'search', $menu, $year));
	}


	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "納品書",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "納品書";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}


//-------------------------------------------------------------------------------------------------
	public function search($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);
		
		$DeliDataYear = $main_year;

		//$DeliDataYear = $this->Common->getPost($this, 'Delidoc', 'DeliDataYear');
//debug($DeliDataYear);		
		if($DeliDataYear == "2020"){
			//$this->Delidoc->setDataSource('inabou');
			$this->Delidoc->setDataSource('inabou2020');
		}else{
			$this->Delidoc->setDataSource('inabou');
		}


	// 納品書管理システム
	//	住宅用火災警報器の数量表
	//	班・作業予定表
		$this->set('main_title', "納品書管理システム");
		$this->set('sub_title', "納品書・商品検索");

		$cmd = $this->Common->getPost($this, 'Product', 'cmd');
		if( $cmd == "検索" ){
			/* 検索単語の取得 */
			// ID ProductName ProductNum ProductCode Mfg Unit UnitPrice Tax DeliComID
			$search = $this->Common->getPost($this, 'Product', 'search');
			$ID = $this->Common->getPost($this, 'Product', 'ID');

			$Product3item = $this->Common->getPost($this, 'Product', 'Product3item');
			$ProductName = $this->Common->getPost($this, 'Product', 'ProductName');
			$ProductNum = $this->Common->getPost($this, 'Product', 'ProductNum');
			$ProductCode = $this->Common->getPost($this, 'Product', 'ProductCode');
			$Mfg = $this->Common->getPost($this, 'Product', 'Mfg');
			$Unit = $this->Common->getPost($this, 'Product', 'Unit');
			$UnitPrice = $this->Common->getPost($this, 'Product', 'UnitPrice');
			$Tax = $this->Common->getPost($this, 'Product', 'Tax');

			$DeliCom = $this->Common->getPost($this, 'Product', 'DeliCom');
			$DeliComID = $this->Common->getPost($this, 'Product', 'DeliComID');

			$ClientName = $this->Common->getPost($this, 'Product', 'ClientName');
			$ClientID = $this->Common->getPost($this, 'Product', 'ClientID');

			$OrderName = $this->Common->getPost($this, 'Product', 'OrderName');
			$OrderID = $this->Common->getPost($this, 'Product', 'OrderID');

			/* pagenation引数取得 */
			$page = $this->Common->getPost($this, 'Product', 'page');
			$direction = $this->Common->getPost($this, 'Product', 'direction');
			$sort = $this->Common->getPost($this, 'Product', 'sort');
		}else{
			// ID ProductName ProductNum ProductCode Mfg Unit UnitPrice Tax DeliComID
			$search = $this->Common->getPost2($this, 'Product', 'search');
			$ID = $this->Common->getPost2($this, 'Product', 'ID');

			$Product3item = $this->Common->getPost2($this, 'Product', 'Product3item');
			$ProductName = $this->Common->getPost2($this, 'Product', 'ProductName');
			$ProductNum = $this->Common->getPost2($this, 'Product', 'ProductNum');
			$ProductCode = $this->Common->getPost2($this, 'Product', 'ProductCode');
			$Mfg = $this->Common->getPost2($this, 'Product', 'Mfg');
			$Unit = $this->Common->getPost2($this, 'Product', 'Unit');
			$UnitPrice = $this->Common->getPost2($this, 'Product', 'UnitPrice');
			$Tax = $this->Common->getPost2($this, 'Product', 'Tax');

			$DeliCom = $this->Common->getPost2($this, 'Product', 'DeliCom');
			$DeliComID = $this->Common->getPost2($this, 'Product', 'DeliComID');

			$ClientName = $this->Common->getPost2($this, 'Product', 'ClientName');
			$ClientID = $this->Common->getPost2($this, 'Product', 'ClientID');

			$OrderName = $this->Common->getPost2($this, 'Product', 'OrderName');
			$OrderID = $this->Common->getPost2($this, 'Product', 'OrderID');

			/* pagenation引数取得 */
			$page = $this->Common->getPost2($this, 'Product', 'page');
			$direction = $this->Common->getPost2($this, 'Product', 'direction');
			$sort = $this->Common->getPost2($this, 'Product', 'sort');

		}
		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($Product3item)
			$condition = array_merge_recursive($condition, array('OR' => array("ProductName like" => '%'.$Product3item.'%', "ProductNum like" => '%'.$Product3item.'%',"ProductCode like" => '%'.$Product3item.'%') ));
		if($ProductName)
			$condition = array_merge_recursive($condition, array("ProductName like" => '%'.$ProductName.'%'));
		if($ProductNum)
			$condition = array_merge_recursive($condition, array("ProductNum like" => '%'.$ProductNum.'%'));

		if($ProductCode)
			$condition = array_merge_recursive($condition, array("ProductCode like" => '%'.$ProductCode.'%'));
		if($Mfg)
			$condition = array_merge_recursive($condition, array("Mfg like" => $Mfg));

		if($DeliCom){
			$DeliComID = $this->GetDeliComID($DeliCom);
			$condition = array_merge_recursive($condition, array('DeliComID' => $DeliComID ));
		}
		if($ClientName){
			$ids = $this->FromClientName($ClientName);
			$condition = array_merge_recursive($condition, array('ID' =>  $ids ));
		}

		if($OrderName){
			$ids = $this->FromOrderName($OrderName);
//debug($ids);
			$condition = array_merge_recursive($condition, array('ID' =>  $ids ));
		}
		//	$condition = array_merge_recursive($condition, array( "Unit like" => '%'.$Unit.'%'));

		$this->set('condition', $condition);
//print_r($condition);
		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
				     "Product3item" => urlencode($Product3item),
				     "ProductName" => urlencode($ProductName),
				     "ProductNum" => urlencode($ProductNum),
				     "ProductCode" => urlencode($ProductCode),
				     "Mfg" => urlencode($Mfg),

				     "DeliCom" => urlencode($DeliCom),
				     "ClientName" => urlencode($ClientName),
				     "OrderName" => urlencode($OrderName)
		);
		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));
		if(!$sort)
			//$sort = array('ProductID', 'ProductName', 'ProductNum', 'ProductCode');
			$sort = array('ProductName', 'ProductNum', 'ProductCode');

		if(!$direction)
			$direction = 'asc';
//debug($sort);
//debug($direction);

		/* ページネーションの作成 */
		$this->paginate = array('Product' => array('conditions' => $condition, 
													'limit' => 100, 
													'order' => $sort,
													'sort' => $sort, 
													'direction' => $direction
													));
		$this->data = $this->paginate('Product');
		$this->set('data', 	$this->data);
		$this->set('delivery', $this);

		$user0 = $this->Auth->user();
		$this->set('category', $user0['User']['category']);

		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
	}

	function detail($ProductID){
		$this->set('main_title', "商品検索");
		$this->set('sub_title', '詳細');
		if(!$ProductID){
			$this->set('error_message', "製品IDがありません。");
			return;
		}

		$this->Product->id = $ProductID;
		$this->data = $this->Product->read();
		$this->set('data', $this->data);
		$this->set('delivery', $this);

		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
	}

//-------------------------------------------------------------------------------------------------

	public function search2($main_menu="", $main_year="") {	//納品書検索
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);
		
		$DeliDataYear = $main_year;

		//$DeliDataYear = $this->Common->getPost($this, 'Delidoc', 'DeliDataYear');
//debug($DeliDataYear);		
	//	if(($DeliDataYear == "") or ($DeliDataYear == "2021")){
			$DeliDataYear = "2021";
			$this->Delidoc->setDataSource('inabou');
	//	}elseif($DeliDataYear == "2020"){
	//		$this->Delidoc->setDataSource('inabou2020');
	//	}

//$r = $this->Common->GetDeliComAll();
//debug($r);


	// 納品書管理システム
		$this->set('main_title', "納品書管理システム");
		$this->set('sub_title', "納品書検索");

		$cmd = $this->Common->getPost($this, 'Delidoc', 'cmd');
		if( $cmd == "検索" ){
			/* 検索単語の取得 */
			// ID 伝票番号 納品会社ID 出荷先ID 担当ID 日付 納品日 備考 合計金額
			// ID DeliNum DeliComID ClientID OrderID DeliDate DeliDate2 Note Total
			$search = $this->Common->getPost($this, 'Delidoc', 'search');
			$ID = $this->Common->getPost($this, 'Delidoc', 'ID');

			$DeliNum = $this->Common->getPost($this, 'Delidoc', 'DeliNum');	//伝票

			$DeliCom = $this->Common->getPost($this, 'Delidoc', 'DeliCom');	//納品会社
			$ClientName = $this->Common->getPost($this, 'Delidoc', 'ClientName');	//出荷先
			$OrderName = $this->Common->getPost($this, 'Delidoc', 'OrderName');		//発注担当

			$DeliDate = $this->Common->getPost($this, 'Delidoc', 'DeliDate');
			$DeliDate1a = $this->Common->getPost($this, 'Delidoc', 'DeliDate1a');
			$DeliDate1b = $this->Common->getPost($this, 'Delidoc', 'DeliDate1b');

			$DeliDate2 = $this->Common->getPost($this, 'Delidoc', 'DeliDate2');
			$Note = $this->Common->getPost($this, 'Delidoc', 'Note');

			$Total = $this->Common->getPost($this, 'Delidoc', 'Total');

			$DeliComID = $this->Common->getPost($this, 'Delidoc', 'DeliComID');
			$ClientID = $this->Common->getPost($this, 'Delidoc', 'ClientID');
			$OrderID = $this->Common->getPost($this, 'Delidoc', 'OrderID');

			/* pagenation引数取得 */
			$page = $this->Common->getPost($this, 'Delidoc', 'page');
			$direction = $this->Common->getPost($this, 'Delidoc', 'direction');
			$sort = $this->Common->getPost($this, 'Delidoc', 'sort');
		}else{
			// ID DeliComID DelidocNum ClientID OrderID DeliDate DeliDatePrice Note TotalID
			$search = $this->Common->getPost2($this, 'Delidoc', 'search');
			$ID = $this->Common->getPost2($this, 'Delidoc', 'ID');

			$DeliNum = $this->Common->getPost2($this, 'Delidoc', 'DeliNum');	//伝票

			$DeliCom = $this->Common->getPost2($this, 'Delidoc', 'DeliCom');	//納品会社
			$ClientName = $this->Common->getPost2($this, 'Delidoc', 'ClientName');	//出荷先
			$OrderName = $this->Common->getPost2($this, 'Delidoc', 'OrderName');		//発注担当

			$DeliDate = $this->Common->getPost2($this, 'Delidoc', 'DeliDate');
			$DeliDate1a = $this->Common->getPost2($this, 'Delidoc', 'DeliDate1a');
			$DeliDate1b = $this->Common->getPost2($this, 'Delidoc', 'DeliDate1b');

			$DeliDate2 = $this->Common->getPost2($this, 'Delidoc', 'DeliDate2');
			$Note = $this->Common->getPost2($this, 'Delidoc', 'Note');

			$Total = $this->Common->getPost2($this, 'Delidoc', 'Total');

			$DeliComID = $this->Common->getPost2($this, 'Delidoc', 'DeliComID');
			$ClientID = $this->Common->getPost2($this, 'Delidoc', 'ClientID');
			$OrderID = $this->Common->getPost2($this, 'Delidoc', 'OrderID');

			/* pagenation引数取得 */
			$page = $this->Common->getPost2($this, 'Delidoc', 'page');
			$direction = $this->Common->getPost2($this, 'Delidoc', 'direction');
			$sort = $this->Common->getPost2($this, 'Delidoc', 'sort');

		}
		if(!$DeliDate1a){
			$a = $this->Common->GetModelAll("Delidoc", "DeliDate");
			if(count($a) > 0)
				$DeliDate1a = $a[0];
			$this->set('DeliDate1a', $DeliDate1a);
		}
//debug($ApplicationDate1);
		if(!$DeliDate1b){
			$a = $this->Common->GetModelAll("Delidoc", "DeliDate");
			if(count($a) > 0)
				$DeliDate1b = $a[count($a)-1];
			$this->set('DeliDate1b', $DeliDate1b);
		}

//		$sort = "REPLACE(REPLACE('Delicom', '株式会社', ''), '有限会社', '')";
//		$ret = $this->Delicom->find('all', array('fields' => array('DeliCom'), 'conditions' => array('ID >' => 0), 'order' => array("REPLACE('Delicom', '株式会社', '')" => 'asc')));

//$log = $this->Delicom->getDataSource()->getLog(false, false);       
//debug($log);
//$ret = $this->Common->GetDeliComAll();
//debug($ret);
//exit();
				
		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($ID)
			$condition = array_merge_recursive($condition, array("ID" => $ID));
		if($DeliNum)
			$condition = array_merge_recursive($condition, array("DeliNum" => $DeliNum));
		if($DeliCom){
			$DeliComID = $this->GetDeliComID($DeliCom);
			$condition = array_merge_recursive($condition, array("DeliComID" => $DeliComID));
		}
		if($ClientName){
			$ClientID = $this->GetClientID($ClientName);
			$condition = array_merge_recursive($condition, array("ClientID" => $ClientID));
		}
		if($OrderName){
			$OrderID = $this->GetOrderID($OrderName);
			$condition = array_merge_recursive($condition, array("OrderID like" => $OrderID));
		}
		if($DeliDate)
			$condition = array_merge_recursive($condition, array('DeliDate LIKE' => '%'.$DeliDate.'%' ));

		if( ($DeliDate1a <> "") and ($DeliDate1b <> "") )
			$condition = array_merge_recursive($condition, array('DeliDate BETWEEN ? AND ?' => array($DeliDate1a, $DeliDate1b) ));

		if($DeliDate2)
			$condition = array_merge_recursive($condition, array('DeliDate LIKE' => '%'.$DeliDate2.'%' ));

		if($Note)
			$condition = array_merge_recursive($condition, array('Note LIKE' => $Note ));
		if($Total)
			$condition = array_merge_recursive($condition, array('Total' => $Total ));

		$this->set('condition', $condition);
//print_r($condition);
		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
				     "ID" => urlencode($ID),
				     "DeliNum" => urlencode($DeliNum),
				     "DeliCom" => urlencode($DeliCom),
				     "ClientName" => urlencode($ClientName),
				     "OrderName" => urlencode($OrderName),
				     "DeliDate" => urlencode($DeliDate),
				     "DeliDate1a" => urlencode($DeliDate1a),
				     "DeliDate1b" => urlencode($DeliDate1b),
				     "DeliDate2" => urlencode($DeliDate2),
				     "Note" => urlencode($Note),
				     "Total" => urlencode($Total)
		);
		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));
		if(!$sort)
			//$sort = array('DelidocID', 'DeliComID', 'DelidocNum', 'ClientID');
			$sort = array('ID',  'DeliNum', 'DeliComID', 'ClientID', 'OrderID');

		if(!$direction)
			$direction = 'asc';
//debug($sort);
//debug($direction);

		/* ページネーションの作成 */
		$this->paginate = array('Delidoc' => array('conditions' => $condition, 
													'limit' => 100, 
													'order' => $sort,
													'sort' => $sort, 
													'direction' => $direction
													));
		$this->data = $this->paginate('Delidoc');
		$this->set('data', 	$this->data);
		$this->set('delivery', $this);

		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
	}

	function detail2($DelidocID){
		$this->set('main_title', "納品書検索");
		$this->set('sub_title', '詳細');
		if(!$DelidocID){
			$this->set('error_message', "製品IDがありません。");
			return;
		}

		$this->Delidoc->id = $DelidocID;
		$this->data = $this->Delidoc->read();
		$this->set('data', $this->data);
		$this->set('delivery', $this);

		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
	}

//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------


	private function GetClientID($ClientName){
		$sql = "SELECT `ID` FROM `client` WHERE `ClientName` LIKE '".$ClientName."'";
		$ret = $this->Client->query($sql);
		return $ret[0]['client']['ID'];
	}

	function GetClientName2($ClientID){
		$sql = "SELECT `ClientName` FROM `client` WHERE `ID` =".$ClientID;
		$ret = $this->Client->query($sql);
		return $ret[0]['client']['ClientName'];
	}


	function GetClientName( $ProductID ){
		if($ProductID == 0)
			return "";
		$sql = "SELECT distinct(`DeliDocID`) FROM `delitable` WHERE `ProductID`=".$ProductID." order by `DeliDocID`";
//debug($sql);
		$sql = "SELECT distinct(`ClientID`) FROM `delidoc` WHERE `ID` IN(".$sql.") order by `ClientID`";
		$ret = $this->Delidoc->query($sql);
		$count = count($ret);
		if($count == 0)
			return "";

		$sql = "SELECT distinct(`ClientName`) FROM `client` WHERE `ID` IN(".$sql.") order by `ClientName`";
		$ret = $this->Client->query($sql);
		$count = count($ret);
		if($count == 0)
			return "";
		$s = "";
		for($i=0; $i<$count; $i++){
			if($i <> 0)
				$s = $s . ",";
			$s = $s . $ret[$i]['client']['ClientName'];
		}
		return $s;
	}
	
	function GetOrderID($OrderName){
		$sql = "SELECT `ID` FROM `order` WHERE `OrderName` LIKE "."'%".$OrderName."%'";
		$ret = $this->Order->query($sql);
		return $ret[0]['order']['ID'];
	}

	function GetOrderName2( $OrderID ){
		$sql = "SELECT `OrderName` FROM `order` WHERE `ID` =".$OrderID;
		$ret = $this->Order->query($sql);
		return $ret[0]['order']['OrderName'];
	}

	function GetOrderName( $ProductID ){
		if($ProductID == 0)
			return "";
		$sql = "SELECT distinct(`DeliDocID`) FROM `delitable` WHERE `ProductID`=".$ProductID." order by `DeliDocID`";
//debug($sql);
		$sql = "SELECT distinct(`OrderID`) FROM `delidoc` WHERE `ID` IN(".$sql.") order by `OrderID`";
		$ret = $this->Delidoc->query($sql);
		$count = count($ret);
		if($count == 0)
			return "";
		
		$sql = "SELECT distinct(`OrderName`) FROM `order` WHERE `ID` IN(".$sql.") order by `OrderName`";

		$ret = $this->Order->query($sql);
		$count = count($ret);
		if($count == 0)
			return "";
		$s = "";
		for($i=0; $i<$count; $i++){
			if($i <> 0)
				$s = $s . ",";
			$s = $s . $ret[$i]['order']['OrderName'];
		}
		return $s;
	}

	function GetQty( $ProductID ){
		if($ProductID == 0)
			return "";
		$sql = "SELECT sum(`Qty`) as qty FROM `delitable` WHERE `ProductID`=".$ProductID;
//debug($sql);
		$ret = $this->Delitable->query($sql);
//print_r($ret);
		return $ret[0][0]['qty'];
	}

	function GetDeliDocID( $ProductID ){
		if($ProductID == 0)
			return "";
		$sql = "SELECT distinct(`DeliDocID`) FROM `delitable` WHERE `ProductID`=".$ProductID." order by `DeliDocID`;";
//debug($sql);
		$ret = $this->Delitable->query($sql);
		$count = count($ret);
		$s = "";
		for($i=0; $i<$count; $i++){
			if($i <> 0)
				$s = $s . ",";
			$s = $s . $ret[$i]['delitable']['DeliDocID'];
		}
		return $s;
	}

	function GetDeliDocID2( $ProductID ){
		$sql = "SELECT distinct(`DeliDocID`) FROM `delitable` WHERE `ProductID`=".$ProductID." order by `DeliDocID`;";
//debug($sql);
		$ret = $this->Delitable->query($sql);
		$count = count($ret);
		$s = $ret[0]['delitable']['DeliDocID'];
		if($count > 1)
			return $s = $s . "*";
		else
			return $s;
	}

	function ClientName(){
		$sql = "SELECT `ClientName` FROM `client` WHERE 1 ORDER BY `ClientName`";
		$ret = $this->Client->query($sql);
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['client']['ClientName'];
		}
		return $names;
	}

	function OrderName(){
		$sql = "SELECT `OrderName` FROM `order` WHERE 1 ORDER BY `OrderName`";
		$ret = $this->Order->query($sql);
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['order']['OrderName'];
		}
		return $names;
	}

	private function FromClientName($ClientName){
		$sql = "SELECT `ID` FROM `client` WHERE `ClientName` like '%". $ClientName."%'";
//debug($sql);
		//$ret = $this->Order->query($sql);
//print_r($ret);
		//$OrderID = $ret[0]['order']['ID'];
		//$count = count($ret);
//debug($count);
//print_r($ret);
		$sql = "SELECT distinct(`ProductID`) FROM `delitable` WHERE `ClientID` IN(". $sql . ")";
		$ret = $this->Delitable->query($sql);
		for($i=0; $i<count($ret); $i++){
			//if($i <> 0)
			//	$s = $s . ",";
			$a[$i] = $ret[$i]['delitable']['ProductID'];
		}
//debug($s);
		return $a;
	}
	
	private function FromOrderName($OrderName){
		$sql = "SELECT `ID` FROM `order` WHERE `OrderName` like '". $OrderName."%'";
//debug($sql);
		//$ret = $this->Order->query($sql);
//print_r($ret);
		//$OrderID = $ret[0]['order']['ID'];
		//$count = count($ret);
//debug($count);
		$sql = "SELECT `ID` FROM `delidoc` WHERE OrderID IN(". $sql . ")";
//debug($sql);
		$ret = $this->Delidoc->query($sql);
//print_r($ret);
		$sql = "SELECT distinct(`ProductID`) FROM `delitable` WHERE `DeliDocID` IN(". $sql . ")";
		
		$ret = $this->Delitable->query($sql);
		for($i=0; $i<count($ret); $i++){
			//if($i <> 0)
			//	$s = $s . ",";
			$a[$i] = $ret[$i]['delitable']['ProductID'];
		}
//debug($s);
		return $a;
	}


	private function GetDeliComID($DeliCom){
//debug($DeliCom);
		$sql = "SELECT ID FROM delicom WHERE DeliCom LIKE '%".$DeliCom."%'";
//debug($sql);
		$ret = $this->Delicom->query($sql);
		
		$count = count($ret);
//debug($count);
		if($count > 1)
		{
			$s = "";
			for($i=0; $i<$count; $i++)
			{
				if($i <> 0)
					$s = $s . ",";
				$s = $s . $ret[$i]['DeliCom']['ID'];
			}
//debug($s);
			//return $s;
			return $ret[0]['delicom']['ID'];
		}
		else
			return $ret[0]['delicom']['ID'];
	}

	function GetDeliCom($DeliComID){
//debug($DeliComID);
		if($DeliComID == 0)
			return "";
		else
			$sql = "SELECT DeliCom FROM delicom WHERE ID=".$DeliComID;
//debug($sql);
		$ret = $this->Delicom->query($sql);
		$count = count($ret);
//debug($count);
		if($count > 0)
			return $ret[0]['Delicom']['DeliCom'];
		else
			return "";
	}

	function GetDeliComAll(){
//debug($DeliComID);
		$sql = "SELECT DeliCom2 FROM delicom2 WHERE 1 ORDER BY SortKey";
//debug($sql);
		$ret = $this->Delicom2->query($sql);
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Delicom2']['DeliCom2'];
		}
		return $names;
	}

	function GetMfgAll(){
//debug($DeliComID);
		$sql = "SELECT distinct(`Mfg`) FROM `product` WHERE `Mfg` <> '' order by `Mfg`";
//debug($sql);
		$ret = $this->Product->query($sql);
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Product']['Mfg'];
		}
		return $names;
	}



}	// end of class
