<?php
//	http://localhost/inabou/camera
class CameraController extends AppController {
	public $name = 'Camera';
	public $uses = array('User', 'Camera');
	//public $layout = 'mailauth1';
	public $layout = 'dafault';

	//public $autoRender = false;	// View Off
	
	public $components = array('Common');	//'Session', , 'Mail', 'Email', 'Qdmail', 'Excel'  
	public $helpers = array('Common', 'Html', 'Form');	//'Javascript', , 'Tabular', 'Calender', 'Holiday'
	public $URL_SELF;

	function beforeFilter(){
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

		if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
		}

		$this->set('main_title', "カメラ");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Camera
		$this->set('URL_SELF', $this->URL_SELF);
		date_default_timezone_set('Asia/Tokyo');
	}

	function index(){		//http://localhost/inabou/camera/
		$this->RecieveMail();
		$this->redirect(array('controller'=>'camera','action'=>'search'));
	}

	/* =================== 　発注書検索　 ======================= */
	public function search() {
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'camera','action'=>'index'));
		}
		$this->set('main_title', 'カメラ撮影');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Camera', 'search');
		$id = $this->Common->getPost($this, 'Camera', 'id');
		
		//`id`, `date_time`, `user`, `domain`, `ip`, `attach_file`, `name`
		$date_time = $this->Common->getPost($this, 'Camera', 'date_time');
		$date_time1 = $this->Common->getPost($this, 'Camera', 'date_time1');
		$date_time2 = $this->Common->getPost($this, 'Camera', 'date_time2');
//debug($date_time);
//debug($date_time2);

		$user = $this->Common->getPost($this, 'Camera', 'user');
		$domain = $this->Common->getPost($this, 'Camera', 'domain');

		$ip = $this->Common->getPost($this, 'Camera', 'ip');

		$attach_file = $this->Common->getPost($this, 'Camera', 'attach_file');
		$name = $this->Common->getPost($this, 'Camera', 'name');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Camera', 'page');
		$direction = $this->Common->getPost($this, 'Camera', 'direction');
		$sort = $this->Common->getPost($this, 'Camera', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($date_time)
			$condition = array_merge_recursive($condition, array( "date_time" => $date_time ));

	//------------------------------
		//if($date_time)
		//	$condition = array_merge_recursive($condition, array( "date_time like" => $date_time));
		if($date_time1 and $date_time2)
			$condition = array_merge_recursive($condition, array('date_time BETWEEN ? AND ?' => array($date_time1, $date_time2)));
	//------------------------------
		if($user)
			$condition = array_merge_recursive($condition, array( "user like" => '$user'));
		if($domain)
			$condition = array_merge_recursive($condition, array( "domain like" => '$domain' ));

		if($ip)
			$condition = array_merge_recursive($condition, array( "ip like" => '$ip'));

		if($attach_file)
			$condition = array_merge_recursive($condition, array( "attach_file like" => '$attach_file'));

		if($name)
			$condition = array_merge_recursive($condition, array( "name like" => '$name'));

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "date_time" => urlencode($date_time),
				     "user" => urlencode($user),
				     "domain" => urlencode($domain),

				     "ip" => urlencode($ip),

				     "attach_file" => urlencode($attach_file),
				     "name" => urlencode($name),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Camera' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		//$this->paginate = array('Camera' => array('conditions' => $condition, 'limit'=>100, 'order'=>array('id desc', 'date_time desc')));

		$this->data = $this->paginate('Camera');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);
		$this->set('user_id', $user0['User']['id']);
		$this->set('login_user', $user0['User']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'camera','action'=>'search', 'page:1/direction:asc/sort:id'));
		}
	}
	
	
	
	function RecieveMail(){
		//$this->autoRender = false; // Viewを使わないように
		//Configure::write('debug', 0); // debugコードを出さないように
		//$this->redirect(array('controller'=>'users','action'=>'login'));
		
		//App::Import('Vendor', 'QdmailReceiver.php');
		//App::Import('Vendor', Classes.'qdmail_receiver.php');
		require_once $this->Common->ConvPath( Classes."qdmail_receiver.php" );

		$popServer = 'mail.inabous.net';
		$popUser = 'camera@inabous.net';
		$popPassword = 'es10Um818';

		//接続
		$server = array(
			'protocol'=>'pop3',
			'host'=>$popServer,
			'user'=>$popUser,
			'pass'=>$popPassword,
		);
		$receiver = QdmailReceiver::start('pop', $server);
debug($receiver->count());
		for($i = 1 ; $i <= $receiver->count() ; $i++){
			print $receiver->text()."<br>\n";
			
			//echo( $receiver->header['delivered-to'])."<br>\n";
			//echo( $receiver->header['subject']['value'])."<br>\n";
			//echo( $receiver->header['message-id'])."<br>\n";

			//添付ファイルの取得
			$attach = $receiver->attach();
 
			foreach($attach as $att){
				$path = $this->Common->ConvPath( WWW_ROOT."files/camera/mail_attach/");
    			$fp=fopen( $path . $att['filename_safe'], 'w' );
    			fputs($fp,$att['value']);
    			fclose($fp);
			}
			
			$this->SaveDB($receiver->text(), $att['filename_safe']);

			$pointer =  $receiver->pointer(); // 現在のメールIDを取得
////		$receiver->delete($pointer); // 現在のメールを削除

			$receiver->next();
		}
		$receiver->done(); // メールの削除を確定

		//exit();
	}

	function SaveDB( $mail_body, $attach_file){
		$a = explode("\r\n", $mail_body);
		for($i=0; $i<count($a); $i++){
			//debug($a[$i]);
			//DATE:2021/08/20	TIME:15:26:12	USER:YOSHIKURA	DOMAIN:JPH049CBC2	IP:192.168.1.109	
			if(strstr($a[$i], "DATE:")){
				$b = explode(":", $a[$i]);
				$date = $b[1];
			}elseif(strstr($a[$i], "TIME:")){
				$b = explode("E:", $a[$i]);
				$time = $b[1];
			}elseif(strstr($a[$i], "USER:")){
				$b = explode(":", $a[$i]);
				$user = $b[1];
			}elseif(strstr($a[$i], "DOMAIN:")){
				$b = explode(":", $a[$i]);
				$domain = $b[1];
			}elseif(strstr($a[$i], "IP:")){
				$b = explode(":", $a[$i]);
				$ip = $b[1];
			}
		}
		
		$name = $this->GetName($domain);
		
		$sql = "TRUNCATE `camera`";
		$ret = $this->Camera->query($sql);
		
		$sql = "INSERT INTO `camera` (`id`, `date_time`, `user`, `domain`, `ip`, `attach_file`, `name`) VALUES (NULL, ";
		$sql .= "'$date $time','$user', '$domain', '$ip', '$attach_file', '$name');";
debug($sql);		
		$ret = $this->Camera->query($sql);

	}

	function GetName($domain){
		switch ($domain){
			case "MARI":
    			return "真理";
			case "ASAI-PC":
				return "高野";
			case "DIGINNOS":
				return "矢次";
			case "DIGINNOS":
				return "多映子";
			case "JPH049CBC2":
				return "吉倉";;

			case "JPH049CBC2":
				return "吉倉";;
			default:
				return "不明";
		}	
	}






	function send_mail($data, $app){
//debug($data);
		//$user0 = $this->Auth->user();
		
		$a = explode(" ", $data['user']);
		$ret = $this->User->find('first', array('fields' => array('email'), 'conditions' => array('name1' => $a[0], 'name2' => $a[1])));

		$from = "yn.inabou@docomo.ne.jp";
		$name_from = "奈良部 義彦";

//debug($from);
//debug($name_from);
//exit();
		//if(strstr($_SERVER['SERVER_NAME'], "p5.yoshikura.com")){
		if(strstr($_SERVER['SCRIPT_FILENAME'], "p5.yoshikura.com/inabou/")){
			$to = $ret['User']['email'];
			$name_to = $data['user'];
			$cc = "nakanishi@inabou.co.jp";		//"yy@yoshikura.com";	//"nakanishi@inabou.co.jp"
			$bcc = "yoji@yoshikura.com";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";
		}else{
			$to = "yoji@yoshikura.com";
			$name_to = $data['user'];
			$cc = "yoshikura229@icloud.com";		//"yy@yoshikura.com";	//"nakanishi@inabou.co.jp"
			$bcc = "yy@yoshikura.com";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";
		}
//debug($to);
		if($app == "yes"){
			$subject = "発注内容が承認されました。";
			$mailbody = "発注内容が承認されました。\r\n\r\n";
		}else{
			$subject = "発注内容が否認されました。";
			$mailbody = "発注内容が否認されました。\r\n\r\n";
		}
		$mailbody .= $name_from."<".$from.">\r\n\r\n";
		
		$mailbody .= "☆☆☆発注内容☆☆☆"."\r\n";
		
		$mailbody .= "ID= ".$data['id']."\r\n";
		$mailbody .= "登録日= ".$data['date_time']."\r\n";
		$mailbody .= "登録者= ".$data['user']."\r\n";
		$mailbody .= "承認日= ".$data['domain']."\r\n";
		$mailbody .= "材料使用日= ".$data['ip']."\r\n";
		$mailbody .= "発注者= ".$data['attach_file']."\r\n";
		$mailbody .= "発注分類= ".$data['name']."\r\n";
		$mailbody .= "発注先= ".$data['Supplier']."\r\n";
		$mailbody .= "請求先= ".$data['SupplierName']."\r\n";
		$mailbody .= "件名= ".mb_convert_kana($data['Subject'],'K','utf-8')."\r\n";
		$mailbody .= "納期= ".$data['DeliveryTime']."\r\n";
		$mailbody .= "支払方法= ".$data['PaymentTerms']."\r\n";
		$mailbody .= "見積書No= ".$data['EstimateNo']."\r\n";
		$mailbody .= "品名= ".mb_convert_kana($data['ProductName'],'K','utf-8')."\r\n";
		$mailbody .= "型番= ".mb_convert_kana($data['ModelNo'],'K','utf-8')."\r\n";
		$mailbody .= "コード= ".mb_convert_kana($data['ProductCode'],'K','utf-8')."\r\n";
		
		$mailbody .= "数量= ".$this->Common->number_format2( $data['Qty'] )."\r\n";
		$mailbody .= "単価= ".$this->Common->number_format2( $data['UnitPrice'] )."\r\n";
		$mailbody .= "金額= ".$this->Common->number_format2( $data['Amount'] )."\r\n";
		
		$mailbody .= "小計= ".number_format( $data['SubTotal'] )."\r\n";
		$mailbody .= "税金= ".number_format( $data['Tax'] )."\r\n";
		$mailbody .= "合計金額= ".number_format( $data['Total'] )."\r\n";
		$mailbody .= "備考= ".$data['Note']."\r\n";
		if( $data['Attachment'] <> "" ){
			$mailbody .= "添付= ".$data['Attachment']."\r\n";
		}
		//$name_from .= "<".$from.">";

		//$this->set('send_mail', nl2br($to."\n------------------\n".$subject."\n-----------------\n".$mailbody."\n-----------------\n"));

		// $this->Qdmail->debug = $debug;
		$param = array(
		    'host' => 'b41.coreserver.jp',	//メールサーバー
		    'port' => 587,					//これはSMTPAuthの例。認証が必要ないなら　25　でＯＫ。
			'from' => 'yoji@yoshikura.com',	//　Return-path: になります。
			'protocol' => 'SMTP_AUTH',		// 認証が必要ないなら、'SMTP'
		    'user' => 'yoji@yoshikura.com',	//SMTPサーバーのユーザーID
		    'pass' => 'es10Um888'			//SMTPサーバーの認証パスワード
		);
		$this->Qdmail->smtpServer($param);
		$this->Qdmail->to( $to, $name_to );
		$this->Qdmail->cc( $cc, '中西' );
		$this->Qdmail->bcc( $bcc, 'bcc吉倉' );
		
		$this->Qdmail->replyto($from, $name_from );
		$this->Qdmail->subject($subject);
		$this->Qdmail->from($from, $name_from );
		$this->Qdmail->text( $mailbody );
		$return_flag = $this->Qdmail->send();
//debug($return_flag);

		if(!$return_flag){
			$this->set('error_message', "メール送信エラー");
debug("メール送信エラー");
			//return false;
		}else{
			//$this->set('error_message', "メール送信完了");
//debug("メール送信完了");
			//return true;
		}
//exit();
//		$this->redirect(array('controller'=>'users','action'=>'login'));

	}





}
?>