<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/Workreport/

class WorkreportController extends AppController {
	public $name = 'Workreport';
	public $uses = array('User', 'Workreport', 'Workphoto', 'Logs');	//
	public $layout = 'dafault';

	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'
	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;
	private $debug = false;

    function beforeFilter() {
		//define("Classes", $_SERVER["DOCUMENT_ROOT"]."/cakephp/class/");
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

		if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
		}

		$this->set('main_title', "工事報告");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Workreport
		$this->set('URL_SELF', $this->URL_SELF);

		//$username = $this->Auth->user('username');
		//$this->set('username', $username);
		
		//$username = $this->User->field('User', array('username' => $username));
		//$this->set('username', $username);
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);
	
		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/Workreport_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'workreport','action'=>'search'));	//search
		//$this->redirect(array('controller'=>'workreport','action'=>'excel_image'));
		
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "工事報告",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "工事報告";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}


	public function excel_image(){
		/** PHPExcelを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );
		// PHPExcelオブジェクトを生成

		$objPHPExcel = new PHPExcel();
		// テンプレートをオープン
		$objReader = PHPExcel_IOFactory::createReader('Excel2007');///.xlsの場合は（）ないにExcel5を
		
		//----------------------------------
		$image_file1 = $this->Common->ConvPath( WWW_ROOT."files/workreport/20200722_131043.jpg" );
		$image_file2 = $this->Common->ConvPath( WWW_ROOT."files/workreport/image_file2.jpg" );
		if(file_exists( $image_file2 ))
			unlink($image_file2);
		list($w1, $h1, $type) = getimagesize( $image_file1 ); // 元の画像名を指定してサイズを取得
		//画像ロード
		$image1 = imagecreatefromjpeg( $image_file1 );	// 元の画像から新しい画像を作る準備

		$w2 = 13 * 37 + 3;	//485;
		$h2 = 8 * 42 + 2;	//339;
		$image2 = ImageCreateTrueColor($w2, $h2);
		//縮小しながらコピー
		imagecopyresampled($image2, $image1, 0, 0, 0, 0, $w2, $h2, $w1, $h1);
		//JPEG 品質85で保存
		imagejpeg($image2, $image_file2, 85);

		//----------------------------------
		//$objPHPExcel = $objReader->load("templates/test_template.xlsx");///これが実際のファイル名
		$objPHPExcel = $objReader->load( $this->Common->ConvPath( WWW_ROOT."files/workreport/Workreport_form.xlsx" ) ); ///これが実際のファイル名

		$objPHPExcel->setActiveSheetIndex(0);////シートの1番目に移動

		///画像用のオプジェクト作成
		$objDrawing = new PHPExcel_Worksheet_Drawing();
		$objDrawing->setPath( $image_file2 ); ///貼り付ける画像のパスを指定

		//↓これが必要
		$objDrawing->setResizeProportional(false);
		//↑これが必要
		$objDrawing->setWidth( $w2 );////画像の幅を指定
		$objDrawing->setHeight( $h2 );////画像の高さを指定
		///画像のプロパティを見たときに表示される情報を設定
		$objDrawing->setName('Nozomi Sasaki');////ファイル名
		$objDrawing->setDescription('Nozomi Sasak');////画像の概要

		$objDrawing->setCoordinates('K5');///位置
		$objDrawing->setOffsetX(0);////横方向へ何ピクセルずらすかを指定
		//$objDrawing->setRotation(25);//回転の角度
		//$objDrawing->getShadow()->setVisible(true);////ドロップシャドウをつけるかどうか。
		// $drawing->getShadow()->setDirection(45); // ドロップシャドウの方向
		///PHPExcelオブジェクトに張り込み
		$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

		// エクセルファイルをブラウザに書き出し
		//ヘッダーの設定
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="image_test.xlsx"');
		header('Cache-Control: max-age=0');
		//出力
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;	
	}



	/* =================== 　アクセス・ログ検索　 ======================= */
	public function accesslogs(){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Logs','action'=>'index'));
		}
		$this->set('main_title', 'アクセス・ログ');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Logs', 'search');
		$id = $this->Common->getPost($this, 'Logs', 'id');
		$contents = $this->Common->getPost($this, 'Logs', 'contents');
		$username = $this->Common->getPost($this, 'Logs', 'username');
		$name1 = $this->Common->getPost($this, 'Logs', 'name1');
		$name2 = $this->Common->getPost($this, 'Logs', 'name2');
		$ip_address = $this->Common->getPost($this, 'Logs', 'ip_address');
		$accessed = $this->Common->getPost($this, 'Logs', 'accessed');
		$accessedY = $this->Common->getPost($this, 'Logs', 'accessedY');
		$accessedM = $this->Common->getPost($this, 'Logs', 'accessedM');
		$accessedD = $this->Common->getPost($this, 'Logs', 'accessedD');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Logs', 'page');
		$direction = $this->Common->getPost($this, 'Logs', 'direction');
		$sort = $this->Common->getPost($this, 'Logs', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($contents)
			//$condition = array_merge_recursive($condition, array( "contents like" => '%'.mb_convert_encoding($username, "UTF-8", "SJIS").'%'));
			$condition = array_merge_recursive($condition, array( "contents like" => '%'.$contents.'%'));
		if($username)
			$condition = array_merge_recursive($condition, array( "username like" => '%'.$username.'%'));
		if($name1)
			$condition = array_merge_recursive($condition, array( "name1 like" => '%'.$name1.'%'));
		if($name2)
			$condition = array_merge_recursive($condition, array( "name2 like" => '%'.$name2.'%'));
		if($ip_address)
			$condition = array_merge_recursive($condition, array( "ip_address like" => '%'.$ip_address.'%'));

		if($accessed){
			//$condition = array_merge_recursive($condition, array( "accessed" => $accessed ));
			$date1 = $accessed.' 00:00:00';
			$date2 = $accessed.' 23:59:59';
			$condition = array_merge_recursive($condition, array('accessed BETWEEN ? AND ?' => array($date1, $date2)));
		}

		if($accessedY and !$accessedM and !$accessed){
			$date1 = $accessedY.'-01-01 00:00:00';
			$date2 = $accessedY.'-12-31 23:59:59';
			$condition = array_merge_recursive($condition, array('accessed BETWEEN ? AND ?' => array($date1, $date2)));
		}
		if($accessedY and $accessedM and !$accessedD){
			$month = $accessedY."-".$accessedM;
			$date1 = date('Y-m-d', strtotime('first day of ' . $month)).' 00:00:00';
			$date2 = date('Y-m-d', strtotime( 'last day of ' . $month)).' 23:59:59';
//debug($date1);
//debug($date2);
			//$condition = array_merge_recursive($condition, array('accessed BETWEEN ? AND ?' => array($date1, $date2)));
			$condition = array_merge_recursive($condition, array('accessed >=' => $date1, 'accessed <=' => $date2));
		}

		if($accessedY and $accessedM  and $accessedD){
			$date1 = $accessedY."-".$accessedM."-".$accessedD.' 00:00:00';
			$date2 = $accessedY."-".$accessedM."-".$accessedD.' 23:59:59';
//debug($date1);
//debug($date2);
			//$condition = array_merge_recursive($condition, array('accessed BETWEEN ? AND ?' => array($date1, $date2)));
			$condition = array_merge_recursive($condition, array( 'accessed >=' => $date1, 'accessed <=' => $date2 ));
//debug($accessedY."-".$accessedM."-".$accessedD);
		}


		$this->set('condition', $condition);

		// 検索単語に基づき引数作成 
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "contents" => urlencode($contents),
				     "username" => urlencode($username),
				     "name1" => urlencode($name1),
				     "name2" => urlencode($name2),
				     "ip_address" => urlencode($ip_address),
				     "accessed" => urlencode($accessed),
				     "accessedY" => urlencode($accessedY),
				     "accessedM" => urlencode($accessedM),
				     "accessedD" => urlencode($accessedD),
		);
		// ページネーションの作成 
		$this->paginate = array('Logs' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Logs');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'workreport','action'=>'accesslogs', 'page:1/direction:asc/sort:id'));
		}

	}



	/* =================== 　工事報告検索　 ======================= */
	public function search($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		}
		$this->set('main_title', '工事報告');
		$this->set('sub_title', '検索');

		$cmd = $this->Common->getPost($this, 'Workreport', 'cmd');
		if($cmd == "クリア")
			$this->redirect(array('controller'=>'workreport','action'=>'index'));

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Workreport', 'search');

		$id = $this->Common->getPost($this, 'Workreport', 'id');	//	id
		$js_no = $this->Common->getPost($this, 'Workreport', 'js_no');	//	JS No.
		$resident_name = $this->Common->getPost($this, 'Workreport', 'resident_name');	//	居住者名
		$branch = $this->Common->getPost($this, 'Workreport', 'branch');	//	支店
		$unit_number = $this->Common->getPost($this, 'Workreport', 'unit_number');	//	住戸番号
		$apartment_name = $this->Common->getPost($this, 'Workreport', 'apartment_name');	//	団地名
		$repair_subject = $this->Common->getPost($this, 'Workreport', 'repair_subject');	//	補修件名
		$repair_detail1 = $this->Common->getPost($this, 'Workreport', 'repair_detail1');	//	補修内容1

/*
		$get_host = $this->Common->getPost($this, 'Workreport', 'get_host');	//	ホスト取得
		$recycle_seal = $this->Common->getPost($this, 'Workreport', 'recycle_seal');	//	リサイクルシール
		$recycle_seal_qty = $this->Common->getPost($this, 'Workreport', 'recycle_seal_qty');	//	リサイクルシール個数
		$record_no = $this->Common->getPost($this, 'Workreport', 'record_no');	//	レコードｎ
		$record_total = $this->Common->getPost($this, 'Workreport', 'record_total');	//	レコード総数
		$sales_office_no = $this->Common->getPost($this, 'Workreport', 'sales_office_no');	//	営業所 No.
		$work_cost_subtotal = $this->Common->getPost($this, 'Workreport', 'work_cost_subtotal');	//	工事費小計

		$tax_rate = $this->Common->getPost($this, 'Workreport', 'tax_rate');	//	消費税率
		$qty = $this->Common->getPost($this, 'Workreport', 'qty');	//	数量
		$unit_price = $this->Common->getPost($this, 'Workreport', 'unit_price');	//	単価
		$discount = $this->Common->getPost($this, 'Workreport', 'discount');	//	値引き
		$list_price = $this->Common->getPost($this, 'Workreport', 'list_price');	//	定価
		$phone = $this->Common->getPost($this, 'Workreport', 'phone');	//	電話
		$remarks = $this->Common->getPost($this, 'Workreport', 'remarks');	//	備考

		$repair_detail10 = $this->Common->getPost($this, 'Workreport', 'repair_detail10');	//	補修内容10
		$repair_detail11 = $this->Common->getPost($this, 'Workreport', 'repair_detail11');	//	補修内容11
		$repair_detail12 = $this->Common->getPost($this, 'Workreport', 'repair_detail12');	//	補修内容12
		$repair_detail13 = $this->Common->getPost($this, 'Workreport', 'repair_detail13');	//	補修内容13
		$repair_detail14 = $this->Common->getPost($this, 'Workreport', 'repair_detail14');	//	補修内容14
		$repair_detail15 = $this->Common->getPost($this, 'Workreport', 'repair_detail15');	//	補修内容15

		$repair_detail2 = $this->Common->getPost($this, 'Workreport', 'repair_detail2');	//	補修内容2
		$repair_detail3 = $this->Common->getPost($this, 'Workreport', 'repair_detail3');	//	補修内容3
		$repair_detail4 = $this->Common->getPost($this, 'Workreport', 'repair_detail4');	//	補修内容4
		$repair_detail5 = $this->Common->getPost($this, 'Workreport', 'repair_detail5');	//	補修内容5
		$repair_detail6 = $this->Common->getPost($this, 'Workreport', 'repair_detail6');	//	補修内容6
		$repair_detail7 = $this->Common->getPost($this, 'Workreport', 'repair_detail7');	//	補修内容7
		$repair_detail8 = $this->Common->getPost($this, 'Workreport', 'repair_detail8');	//	補修内容8
		$repair_detail9 = $this->Common->getPost($this, 'Workreport', 'repair_detail9');	//	補修内容9
*/
		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Workreport', 'page');
		$direction = $this->Common->getPost($this, 'Workreport', 'direction');
		$sort = $this->Common->getPost($this, 'Workreport', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($js_no)		// $js_no
			$condition = array_merge_recursive($condition, array( "js_no like" => '%'.$js_no.'%'));
		if($resident_name)	// 居住者名
			$condition = array_merge_recursive($condition, array( "resident_name like" => '%'.resident_name.'%'));
		if($branch)	//	支店
			$condition = array_merge_recursive($condition, array( "branch like" => '%'.$branch.'%'));
		if($unit_number)	//	住戸番号
			$condition = array_merge_recursive($condition, array( "unit_number like" => '%'.$unit_number.'%'));
		if($apartment_name)	//	団地名
			$condition = array_merge_recursive($condition, array( "apartment_name like" => '%'.$apartment_name.'%'));
		if($repair_subject)	//	補修件名
			$condition = array_merge_recursive($condition, array( "repair_subject like" => '%'.$repair_subject.'%'));
		if($repair_detail1)	//	補修内容1
			$condition = array_merge_recursive($condition, array( "repair_detail1 like" => '%'.$repair_detail1.'%'));

		$this->set('condition', $condition);
//debug($resident_name);
//debug($condition);
		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "js_no" => urlencode($js_no),
				     "resident_name" => urlencode($resident_name),
				     "branch" => urlencode($branch),
				     "unit_number" => urlencode($unit_number),
				     "apartment_name" => urlencode($apartment_name),
				     "repair_subject" => urlencode($repair_subject),
				     "repair_detail1" => urlencode($repair_detail1)
		);
		/* ページネーションの作成 */
		$this->paginate = array('Workreport' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Workreport');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'workreport','action'=>'search', 'page:1/direction:asc/sort:id'));
		}
	}
	
	
	
	function search_proc1($arg="", $first_flag=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		}

		$this->set('main_title', '工事報告');
		$this->set('sub_title', '工事内訳書1');

		if($first_flag)
			$this->jpg_dir_delete();

		if($arg)
			$this->Workreport->id = $arg;
		else
			$this->Workreport->id = $this->Common->getPost($this, 'Workreport', 'id');

		if(!empty($this->data)){
			for($i=0; $i<15; $i++){
				$a[$i] = $this->data['Workreport']['list_price'][$i];
				$b[$i] = $this->data['Workreport']['qty'][$i];
				$c[$i] = $this->data['Workreport']['unit_price'][$i];
				$e[$i] = $this->data['Workreport']['remarks'][$i];
			}
			$this->data['Workreport']['list_price'] = [];
			$this->data['Workreport']['qty'] = [];
			$this->data['Workreport']['unit_price'] = [];
			$this->data['Workreport']['remarks'] = [];

			$this->data['Workreport']['list_price'] = implode("/", $a);
			$this->data['Workreport']['qty'] = implode("/", $b);
			$this->data['Workreport']['unit_price'] = implode("/", $c);
			$this->data['Workreport']['remarks'] = implode("/", $e);
			
			//$this->data['Workreport']['labor_cost'] = str_replace(',','', $this->data['Workreport']['labor_cost']);

			if(!$this->Workreport->save($this->data)){		//更新
				$errors = $this->Workreport->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				//$this->set('data', $this->data);
			}else{
				//更新正常
				$this->save_blob($this->Workreport->id);
				//$this->redirect(array('controller'=>'workreport','action'=>'search'));
			}
		}

		$this->data = $this->Workreport->read();	//読み出し

		$photo_data = $this->read_blob($this->Workreport->id);
		for($i=1; $i<=4; $i++){
			for($j=1; $j<=3; $j++){
				$this->data['Workphoto']['no'][$i][$j] = "";
				$this->data['Workphoto']['msg'][$i][$j] = "";
				$this->data['Workphoto']['judgment'][$i][$j] = "";
				for($k=0; $k<count($photo_data); $k++){
					if($photo_data[$k]['Workphoto']['page'] == intval($i.$j)){
						$this->data['Workphoto']['no'][$i][$j] = $photo_data[$k]['Workphoto']['no'];
						$this->data['Workphoto']['msg'][$i][$j] = $photo_data[$k]['Workphoto']['msg'];
						$this->data['Workphoto']['judgment'][$i][$j] = $photo_data[$k]['Workphoto']['judgment'];
					}
				}
			}
		}
		
//print_r($this->data);
		//$this->data = $this->Common->utf82sjis($this->data);
		$this->set('data', $this->data);

		$this->set('category', $user0['User']['category']);
		//----------------------------------
		$this->set('error_message', "");
		$this->set('upload_file', "");
		$this->set('file_name', "");
		$this->set('up_file', "");
		$this->set('up_url', "");
		//----------------------------------
	}
	

	
	function search_proc2($arg="", $first_flag=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		}

		$this->set('main_title', '工事報告');
		$this->set('sub_title', '工事内訳書2');

		if($first_flag)
			$this->jpg_dir_delete();

		if($arg)
			$this->Workreport->id = $arg;
		else
			$this->Workreport->id = $this->Common->getPost($this, 'Workreport', 'id');

		if(!empty($this->data)){
			for($i=0; $i<15; $i++){
				$a[$i] = $this->data['Workreport']['list_price'][$i];
				$b[$i] = $this->data['Workreport']['qty'][$i];
				$c[$i] = $this->data['Workreport']['unit_price'][$i];
				$e[$i] = $this->data['Workreport']['remarks'][$i];
			}
			$this->data['Workreport']['list_price'] = [];
			$this->data['Workreport']['qty'] = [];
			$this->data['Workreport']['unit_price'] = [];
			$this->data['Workreport']['remarks'] = [];

			$this->data['Workreport']['list_price'] = implode("/", $a);
			$this->data['Workreport']['qty'] = implode("/", $b);
			$this->data['Workreport']['unit_price'] = implode("/", $c);
			$this->data['Workreport']['remarks'] = implode("/", $e);
			
			//$this->data['Workreport']['labor_cost'] = str_replace(',','', $this->data['Workreport']['labor_cost']);

			if(!$this->Workreport->save($this->data)){		//更新
				$errors = $this->Workreport->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				//$this->set('data', $this->data);
			}else{
				//更新正常
				$this->save_blob($this->Workreport->id);
				//$this->redirect(array('controller'=>'workreport','action'=>'search'));
			}
		}

		$this->data = $this->Workreport->read();	//読み出し

		$photo_data = $this->read_blob($this->Workreport->id);
		for($i=1; $i<=4; $i++){
			for($j=1; $j<=3; $j++){
				$this->data['Workphoto']['no'][$i][$j] = "";
				$this->data['Workphoto']['msg'][$i][$j] = "";
				$this->data['Workphoto']['judgment'][$i][$j] = "";
				for($k=0; $k<count($photo_data); $k++){
					if($photo_data[$k]['Workphoto']['page'] == intval($i.$j)){
						$this->data['Workphoto']['no'][$i][$j] = $photo_data[$k]['Workphoto']['no'];
						$this->data['Workphoto']['msg'][$i][$j] = $photo_data[$k]['Workphoto']['msg'];
						$this->data['Workphoto']['judgment'][$i][$j] = $photo_data[$k]['Workphoto']['judgment'];
					}
				}
			}
		}
		
//print_r($this->data);
		//$this->data = $this->Common->utf82sjis($this->data);
		$this->set('data', $this->data);

		$this->set('category', $user0['User']['category']);
		//----------------------------------
		$this->set('error_message', "");
		$this->set('upload_file', "");
		$this->set('file_name', "");
		$this->set('up_file', "");
		$this->set('up_url', "");
		//----------------------------------
	}
	



	
	function search_proc3($arg="", $first_flag=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		}

		$this->set('main_title', '工事報告');
		$this->set('sub_title', '緊急処理報告書');

		if($first_flag)
			$this->jpg_dir_delete();

		if($arg)
			$this->Workreport->id = $arg;
		else
			$this->Workreport->id = $this->Common->getPost($this, 'Workreport', 'id');

		if(!empty($this->data)){
			
			//$this->data['Workreport']['labor_cost'] = str_replace(',','', $this->data['Workreport']['labor_cost']);

			if(!$this->Workreport->save($this->data)){		//更新
				$errors = $this->Workreport->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				//$this->set('data', $this->data);
			}else{
				//更新正常
				$this->save_blob($this->Workreport->id);
				//$this->redirect(array('controller'=>'workreport','action'=>'search'));
			}
		}

		$this->data = $this->Workreport->read();	//読み出し

		$photo_data = $this->read_blob($this->Workreport->id);
		for($i=1; $i<=4; $i++){
			for($j=1; $j<=3; $j++){
				$this->data['Workphoto']['no'][$i][$j] = "";
				$this->data['Workphoto']['msg'][$i][$j] = "";
				$this->data['Workphoto']['judgment'][$i][$j] = "";
				for($k=0; $k<count($photo_data); $k++){
					if($photo_data[$k]['Workphoto']['page'] == intval($i.$j)){
						$this->data['Workphoto']['no'][$i][$j] = $photo_data[$k]['Workphoto']['no'];
						$this->data['Workphoto']['msg'][$i][$j] = $photo_data[$k]['Workphoto']['msg'];
						$this->data['Workphoto']['judgment'][$i][$j] = $photo_data[$k]['Workphoto']['judgment'];
					}
				}
			}
		}
		
//print_r($this->data);
		//$this->data = $this->Common->utf82sjis($this->data);
		$this->set('data', $this->data);

		$this->set('category', $user0['User']['category']);
		//----------------------------------
		$this->set('error_message', "");
		$this->set('upload_file', "");
		$this->set('file_name', "");
		$this->set('up_file', "");
		$this->set('up_url', "");
		//----------------------------------
	}
	




	
	function search_proc4($arg="", $first_flag=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		}

		$this->set('main_title', '工事報告');
		$this->set('sub_title', '補修等施工完了報告書');

		if($first_flag)
			$this->jpg_dir_delete();

		if($arg)
			$this->Workreport->id = $arg;
		else
			$this->Workreport->id = $this->Common->getPost($this, 'Workreport', 'id');

		if(!empty($this->data)){
			for($i=0; $i<2; $i++){
				$a[$i] = $this->data['Workreport']['insulation_ohm1'][$i];
				$b[$i] = $this->data['Workreport']['insulation_ohm2'][$i];
				$c[$i] = $this->data['Workreport']['insulation_ohm3'][$i];
				$d[$i] = $this->data['Workreport']['insulation_ohm4'][$i];
			}
			$this->data['Workreport']['insulation_ohm1'] = [];
			$this->data['Workreport']['insulation_ohm2'] = [];
			$this->data['Workreport']['insulation_ohm3'] = [];
			$this->data['Workreport']['insulation_ohm4'] = [];

			$this->data['Workreport']['insulation_ohm1'] = implode("/", $a);
			$this->data['Workreport']['insulation_ohm2'] = implode("/", $b);
			$this->data['Workreport']['insulation_ohm3'] = implode("/", $c);
			$this->data['Workreport']['insulation_ohm4'] = implode("/", $d);
			
			//$this->data['Workreport']['labor_cost'] = str_replace(',','', $this->data['Workreport']['labor_cost']);

			if(!$this->Workreport->save($this->data)){		//更新
				$errors = $this->Workreport->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				//$this->set('data', $this->data);
			}else{
				//更新正常
				$this->save_blob($this->Workreport->id);
				//$this->redirect(array('controller'=>'workreport','action'=>'search'));
			}
		}

		$this->data = $this->Workreport->read();	//読み出し

		$photo_data = $this->read_blob($this->Workreport->id);
		for($i=1; $i<=4; $i++){
			for($j=1; $j<=3; $j++){
				$this->data['Workphoto']['no'][$i][$j] = "";
				$this->data['Workphoto']['msg'][$i][$j] = "";
				$this->data['Workphoto']['judgment'][$i][$j] = "";
				for($k=0; $k<count($photo_data); $k++){
					if($photo_data[$k]['Workphoto']['page'] == intval($i.$j)){
						$this->data['Workphoto']['no'][$i][$j] = $photo_data[$k]['Workphoto']['no'];
						$this->data['Workphoto']['msg'][$i][$j] = $photo_data[$k]['Workphoto']['msg'];
						$this->data['Workphoto']['judgment'][$i][$j] = $photo_data[$k]['Workphoto']['judgment'];
					}
				}
			}
		}
		
//print_r($this->data);
		//$this->data = $this->Common->utf82sjis($this->data);
		$this->set('data', $this->data);

		$this->set('category', $user0['User']['category']);
		//----------------------------------
		$this->set('error_message', "");
		$this->set('upload_file', "");
		$this->set('file_name', "");
		$this->set('up_file', "");
		$this->set('up_url', "");
		//----------------------------------
	}
	


	
	public function photo_msg($arg1="", $arg2=""){
//debug($this->data['Workphoto']);
//debug($arg1);
//debug($arg2);
		for($i=1; $i<=4; $i++){
			for($j=1; $j<=3; $j++){

				$data = $this->Workphoto->find('first', array('conditions' => array('wr_id' => $arg2, 'page' => intval($i.$j)) ));
//debug($data['Workphoto']['id']);
				if(!empty($data['Workphoto']['id'])){
					$this->data['Workphoto']['id'] = $data['Workphoto']['id'];
				}else{
					//$this->data['Workphoto']['id'] = null;
					//debug("写真説明　IDがない");
					//exit();
					continue;
				}
//debug($data['Workphoto']['id']);
				if(!empty($this->data['Workphoto']['no'][intval($i.$j)])){
					$data['Workphoto']['no'] = $this->data['Workphoto']['no'][intval($i.$j)];
					//unset($this->data['Workphoto']['no'][intval($i.$j)];
				}
				//else
				//	$this->data['Workphoto']['no'] = null;

				if(!empty($this->data['Workphoto']['msg'][intval($i.$j)])){
					$data['Workphoto']['msg'] = $this->data['Workphoto']['msg'][intval($i.$j)];
					//unset($this->data['Workphoto']['msg'][intval($i.$j)];
				}
				//else
				//	$this->data['Workphoto']['msg'] = null;

				if(!empty($this->data['Workphoto']['judgment'][intval($i.$j)])){
					$data['Workphoto']['judgment'] = $this->data['Workphoto']['judgment'][intval($i.$j)];
					//unset($this->data['Workphoto']['judgment'][intval($i.$j)];
				}
				//else
				//	$this->data['Workphoto']['judgment'] = null;

				//unset($this->data['Workphoto']['wr_id']);
				//unset($this->data['Workphoto']['photo_name']);
				//unset($this->data['Workphoto']['photo_blob']);
				//$this->data['Workphoto']['page'] = intval($i.$j);
//debug($data['Workphoto']);
				$this->Workphoto->save($data); // 新規登録or更新
			}
		}
//		exit();
		$this->redirect(array('controller'=>'workreport','action'=>$arg1, $arg2.'#photo2'));
	}
	
	private function read_blob($Workreport_id){
		//DBから写真ファイルの作成
		$path = $this->Common->ConvPath( WWW_ROOT."files/workreport/jpg/" );	//D:\xampp\htdocs\inabou\app\webroot\files\workreport\jpg
		$photo_data = $this->Workphoto->find('all', array('conditions' => array('wr_id' => $Workreport_id), 'order' => array('page' => 'asc')));
		for($i=0; $i<count($photo_data); $i++){
//debug($photo_data[$i]['Workphoto']['id']);
			$photo_name = $photo_data[$i]['Workphoto']['photo_name'];
			$photo_blob = $photo_data[$i]['Workphoto']['photo_blob'];

			//$size = file_put_contents($path . $photo_name, $photo_blob);
		    if (!$handle = fopen($path . $photo_name, 'w')) {
	       		echo "Cannot open file ($photo_name)";
        		exit;
    		}
	    	// オープンしたファイルに$somecontentを書き込みます
    		if (fwrite($handle, base64_decode($photo_blob)) === FALSE) {
	       		echo "Cannot write to file ($photo_name)";
        		exit;
    		}
		    //echo "Success, wrote ($somecontent) to file ($filename)";
			fclose($handle);
		}
		return $photo_data;
	}

	private function save_blob($wr_id){	//, $data
		//BLOB[(M)]最大長が 65,535 (216 ? 1) バイト。オプションの長さ M を指定できる。MEDIUMBLOB最大長が 16,777,215 (224 ? 1) バイト。

		$path = $this->Common->ConvPath( WWW_ROOT."files/workreport/jpg/" );	//D:\xampp\htdocs\inabou\app\webroot\files\workreport\jpg
		for($i=1; $i<=4; $i++){
			for($j=1; $j<=3; $j++){
				$photo_name = $this->Common->GetPhotoName($i, $j);
				if($photo_name){
//debug($photo_name);
//debug(substr($photo_name, 0, 3));
 				   // バイナリデータ
    				$fp = fopen($path.$photo_name, "rb");
    				$imgdat = fread($fp, filesize($path.$photo_name));
    				fclose($fp);
    				//----------------------------------
					//$imgdat = addslashes($imgdat);
					//$imgdat = mysql_real_escape_string($imgdat);
					$imgdat = base64_encode($imgdat);
    				//----------------------------------
					$data = $this->Workphoto->find('first', array('conditions' => array('wr_id' => $wr_id, 'page' => intval($i.$j)) ));
//debug($data['Workphoto']['id']);
//debug(count($data));
					if(!empty($data['Workphoto']['id']))
						$this->data['Workphoto']['id'] = $data['Workphoto']['id'];
					else
						$this->data['Workphoto']['id'] = null;
					$this->data['Workphoto']['wr_id'] = $wr_id;
					$this->data['Workphoto']['photo_name'] = $photo_name;
					$this->data['Workphoto']['photo_blob'] = $imgdat;
					$this->data['Workphoto']['page'] = intval($i.$j);
					if(!empty($this->data['Workphoto']['no'][$i][$j]))
						$this->data['Workphoto']['no'] = $this->data['Workphoto']['no'][$i][$j];
					if(!empty($this->data['Workphoto']['msg'][$i][$j]))
						$this->data['Workphoto']['msg'] = $this->data['Workphoto']['msg'][$i][$j];
					if(!empty($this->data['Workphoto']['judgment'][$i][$j]))
						$this->data['Workphoto']['judgment'] = $this->data['Workphoto']['judgment'][$i][$j];
					
					$this->Workphoto->save($this->data); // 新規登録or更新
					
					unlink($path.$photo_name);
				}
			}
		}
	}
	
	
	private function jpg_dir_delete(){
		$path = $this->Common->ConvPath( WWW_ROOT."files/workreport/jpg/" );	//D:\xampp\htdocs\inabou\app\webroot\files\workreport\jpg
		foreach (glob($path.'*.jpg') as $file) {
 		  // globで取得したファイルをunlinkで1つずつ削除していく
		  unlink($file);
		  // 削除済みのメッセージを表示
		  //echo $file.'を削除しました。<br>';
		}
	}

	/* =================== 工事報告詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		}

		$this->set('main_title', '工事報告');
		$this->set('sub_title', '詳細');

		if($arg)
			$this->Workreport->id = $arg;
		else
			$this->Workreport->id = $this->Common->getPost($this, 'Workreport', 'id');

		if(empty($this->data)){
			$this->data = $this->Workreport->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->Workreport->find('count', array('conditions' => array('category LIKE' => $this->data['Workreport']['category'],
																		'id !=' => $this->Workreport->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'Workreport', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			//if(false){
				if(!$this->Workreport->save($this->data)){		//更新
					$errors = $this->Workreport->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'workreport','action'=>'search'));
				}
			//}
		}
		$this->set('category', $user0['User']['category']);
	}

	/* =================== ログイン管理修正 ======================= */
	function search_edit($arg=""){
		$user0 = $this->Auth->user();
		//if($user0['User']['category'] == 0){
		//	$this->set('error_message', "このメニューは利用ができません。");
		//	//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		//}

		$this->set('main_title', '工事報告情報');
		$this->set('sub_title', '工事報告　＞　編集');

		if($arg)
			$this->Workreport->id = $arg;
		else
			$this->Workreport->id = $this->Common->getPost($this, 'Workreport', 'id');

		if(empty($this->data)){
			$this->data = $this->Workreport->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			for($i=0; $i<2; $i++){
				$a[$i] = $this->data['Workreport']['insulation_ohm1'][$i];
				$b[$i] = $this->data['Workreport']['insulation_ohm2'][$i];
				$c[$i] = $this->data['Workreport']['insulation_ohm3'][$i];
				$d[$i] = $this->data['Workreport']['insulation_ohm4'][$i];
			}
			$this->data['Workreport']['insulation_ohm1'] = [];
			$this->data['Workreport']['insulation_ohm2'] = [];
			$this->data['Workreport']['insulation_ohm3'] = [];
			$this->data['Workreport']['insulation_ohm4'] = [];

			$this->data['Workreport']['insulation_ohm1'] = implode("/", $a);
			$this->data['Workreport']['insulation_ohm2'] = implode("/", $b);
			$this->data['Workreport']['insulation_ohm3'] = implode("/", $c);
			$this->data['Workreport']['insulation_ohm4'] = implode("/", $d);


			for($i=0; $i<15; $i++){
				$a[$i] = $this->data['Workreport']['list_price'][$i];
				$b[$i] = $this->data['Workreport']['qty'][$i];
				$c[$i] = $this->data['Workreport']['unit_price'][$i];
				$e[$i] = $this->data['Workreport']['remarks'][$i];
			}
			$this->data['Workreport']['list_price'] = [];
			$this->data['Workreport']['qty'] = [];
			$this->data['Workreport']['unit_price'] = [];
			$this->data['Workreport']['remarks'] = [];

			$this->data['Workreport']['list_price'] = implode("/", $a);
			$this->data['Workreport']['qty'] = implode("/", $b);
			$this->data['Workreport']['unit_price'] = implode("/", $c);
			$this->data['Workreport']['remarks'] = implode("/", $e);

			//if(false){
				if(!$this->Workreport->save($this->data)){		//更新
					$errors = $this->Workreport->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					//$this->redirect(array('controller'=>'workreport','action'=>'search'));
					$this->data = $this->Workreport->read();	//読み出し
					$this->set('data', $this->data);
				}
			//}
		}
		$this->set('category', $user0['User']['category']);
	}

	/* =================== ログイン管理削除 ======================= */
	function search_delete($arg=""){
		$user0 = $this->Auth->user();
		//if($user0['User']['category'] != 2){
		//	$this->set('error_message', "このメニューは利用ができません。");
		//	//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		//}

		$this->set('main_title', '工事報告情報');
		$this->set('sub_title', '工事報告　＞　削除');

		if($arg)
			$this->Workreport->id = $arg;
		else
			$this->Workreport->id = $this->Common->getPost($this, 'Workreport', 'id');

		if(empty($this->data)){
			$this->data = $this->Workreport->read();	//読み出し
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->Workreport->delete($this->Workreport->id)){		//削除
				$errors = $this->Workreport->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'workreport','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
	}




	/* =================== 新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();
		//if($user0['User']['category'] != 2){
		//	$this->set('error_message', "このメニューは利用ができません。");
		//	//$this->redirect(array('controller'=>'workreport','action'=>'index'));
		//}

		$this->set('main_title', '工事報告情報');
		$this->set('sub_title', '工事報告　＞　新規作成');

		if(empty($this->data)){
			$n = $this->Workreport->find('first', array("fields" => "MAX(id) as max_id"));
			$this->Workreport->id = $n[0]['max_id'];
//debug($this->Workreport->id);
			$this->data = $this->Workreport->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			for($i=0; $i<2; $i++){
				$a[$i] = $this->data['Workreport']['insulation_ohm1'][$i];
				$b[$i] = $this->data['Workreport']['insulation_ohm2'][$i];
				$c[$i] = $this->data['Workreport']['insulation_ohm3'][$i];
				$d[$i] = $this->data['Workreport']['insulation_ohm4'][$i];
			}
			$this->data['Workreport']['insulation_ohm1'] = [];
			$this->data['Workreport']['insulation_ohm2'] = [];
			$this->data['Workreport']['insulation_ohm3'] = [];
			$this->data['Workreport']['insulation_ohm4'] = [];

			$this->data['Workreport']['insulation_ohm1'] = implode("/", $a);
			$this->data['Workreport']['insulation_ohm2'] = implode("/", $b);
			$this->data['Workreport']['insulation_ohm3'] = implode("/", $c);
			$this->data['Workreport']['insulation_ohm4'] = implode("/", $d);


			for($i=0; $i<15; $i++){
				$a[$i] = $this->data['Workreport']['list_price'][$i];
				$b[$i] = $this->data['Workreport']['qty'][$i];
				$c[$i] = $this->data['Workreport']['unit_price'][$i];
				$e[$i] = $this->data['Workreport']['remarks'][$i];
			}
			$this->data['Workreport']['list_price'] = [];
			$this->data['Workreport']['qty'] = [];
			$this->data['Workreport']['unit_price'] = [];
			$this->data['Workreport']['remarks'] = [];

			$this->data['Workreport']['list_price'] = implode("/", $a);
			$this->data['Workreport']['qty'] = implode("/", $b);
			$this->data['Workreport']['unit_price'] = implode("/", $c);
			$this->data['Workreport']['remarks'] = implode("/", $e);

			$this->data['Workreport']['id'] = null;
//print_r($this->data); echo "<br>";
			if(!$this->Workreport->save($this->data)){		//新規作成
				$errors = $this->Workreport->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
			}else
				$this->redirect(array('controller'=>'workreport','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
	}







	public function upload() {
		$this->set('main_title', "アップロード");
		$this->set('sub_title',  '');
		$file_name = $this->Common->upload_proc("upload", $this, $up_file);
		if($file_name){
			if(strstr($file_name, ".xlsx")){
				$this->xlsx_save_proc($up_file);
				$this->redirect(array('controller'=>'workreport','action'=>'search'));
			}else
				$this->set('error_message', "ファイルのアップロードに失敗しました。[".$this->data['Upload']['file_name']['name']."]");
		}
	}

	public function upload1($arg1="", $arg2="", $page="", $no="") {
		//$this->set('main_title', "アップロード");
		//$this->set('sub_title',  '');
		$file_name = $this->Common->upload_proc("workreport/jpg", $this, $up_file);
		if($file_name){
			$info = pathinfo($up_file);
			$dirname = $this->Common->ConvPath( $info['dirname'].'/' );
			$file_name = $info['basename'];

			if(!empty( glob($dirname.$page.'_'.$no.'_*.jpg')) ){
				foreach(glob($dirname.$page.'_'.$no.'_*.jpg') as $file) {
    				unlink( $file );
				}
			}

			rename($up_file, $dirname.$page.'_'.$no.'_'.$file_name);
			$file_name2 = $page.'_'.$no.'_'.$file_name;
		
			$this->photo_resize($file_name2);

			if($file_name){
				if(strstr($file_name, ".jpg") or strstr($file_name, ".JPG")){
			//		$this->redirect(array('controller'=>'workreport','action'=>'search'));
				}else
					$this->set('error_message', "ファイルのアップロードに失敗しました。[".$this->data['Upload']['file_name']['name']."]");
			}
		}
		$this->redirect(array('controller'=>'workreport','action'=>$arg1, $arg2.'#photo'));
	}

	public function photo_delete($arg1="", $arg2="", $page="", $no=""){
		$path = $this->Common->ConvPath( WWW_ROOT."files/workreport/jpg/" );	//D:\xampp\htdocs\inabou\app\webroot\files\workreport\jpg
		$photo_name = $this->Common->GetPhotoName($page, $no);
		if($photo_name){
//debug($photo_name);
			unlink($path.$photo_name);
		
			if(!$this->Workphoto->deleteAll(array('wr_id' => $arg2, 'page' => intval($page.$no)) )){	//削除
				debug("削除エラー");
debug($photo_name);
exit();
			}
		}
		$this->redirect(array('controller'=>'workreport','action'=>$arg1, $arg2.'#photo'));
	}




	private function xlsx_save_proc($up_file){
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** IO Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		//Configure::write('debug', 2);  // debugコードを出す
		$sql = "TRUNCATE TABLE `workreport2`";
//===============================================
		$this->Workreport->query($sql);
//===============================================
        //データの読み込み
        $readData = $this->Excel->readXls($up_file, 56, 108);	
		// param string $filepath,  int $colCount (Optional),  int $rowCount (Optional),  mix $sheetIndex (Optional)
//debug($readData[0]['data']);

//debug($readData[0]['data'][2][0]);
//debug(PHPExcel_Style_NumberFormat::toFormattedString($readData[0]['data'][2][0], PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD2));
//$js_no = date("Y-m-d", intval($readData[0]['data'][6][0])+1180523197);
//debug($readData[0]['data'][6][0]);
//debug(intval($readData[0]['data'][6][0]));
//debug($js_no);
//debug(strtotime("2007-5-31"));
//debug(1180562400 - 39203 );
//exit();
		$k = 0;
		$data = array();
		for($i=2; $i<=count($readData[0]['data']); $i++){
			//if( $readData[0]['data'][$i][4] == null)	//record_no
			//	break;

			$data['Workreport'][] = array(
						'receptionist' => $readData[0]['data'][$i][0],		// '受付者',
						'contact_person' => $readData[0]['data'][$i][1],		//  '団地内連絡者',
						'destination1' => $readData[0]['data'][$i][2],		//  '宛先１',
						'destination2' => $readData[0]['data'][$i][3],		//  '宛先２',
						'accident' => $readData[0]['data'][$i][4],		//  '事故内容',
						'receipt_no' => $readData[0]['data'][$i][5],		//  '受付番号',
						'receipt_time' => $readData[0]['data'][$i][6],		//  '受付時間',
						'reported' => $readData[0]['data'][$i][7],		//  '報告済',
						'cause' => $readData[0]['data'][$i][8],		//  '原因',
						'process_date' => $readData[0]['data'][$i][9],		//  '処理日',

						'processor' => $readData[0]['data'][$i][10],		//  '処理者',
						'arrival_time' => $readData[0]['data'][$i][11],		//  '到着時間',
						'finish_time' => $readData[0]['data'][$i][12],		//  '完了時間',
						'processing' => $readData[0]['data'][$i][13],		//  '処理内容',
						'place' => $readData[0]['data'][$i][14],		//  '場所',
						'requester' => $readData[0]['data'][$i][15],		//  '依頼者',
						'request_date' => $readData[0]['data'][$i][16],		//  '依頼日',
						'work_date' => $readData[0]['data'][$i][17],		//  '施工日',
						'insulation_ohm1' => $this->ConvStr( $readData[0]['data'][$i][18]),		//  '絶縁抵抗1',
						'insulation_ohm2' => $this->ConvStr( $readData[0]['data'][$i][19]),		//  '絶縁抵抗2',

						'insulation_ohm3' => $this->ConvStr( $readData[0]['data'][$i][20]),		//  '絶縁抵抗3',
						'insulation_ohm4' => $this->ConvStr( $readData[0]['data'][$i][21]),		//  '絶縁抵抗4',
						'request' => $readData[0]['data'][$i][22],		//  '依頼内容',
						'branch' => $this->ConvStr( $readData[0]['data'][$i][23] ),		//  '支店',
						'apartment_name' => $this->ConvStr($readData[0]['data'][$i][24]),		//  '団地名',
						'unit_number' => $this->ConvStr( $readData[0]['data'][$i][25] ),		//  '住戸番号',

						'resident_name' => $this->ConvStr( $readData[0]['data'][$i][26]),		//  '居住者名',
						'phone' => $this->ConvStr( mb_convert_kana( $readData[0]['data'][$i][27], "ask")),	//  '電話',
						'repair_subject' => $this->ConvStr( $readData[0]['data'][$i][28] ),		//  '補修件名',
						'js_no' => $this->ConvStr( mb_convert_kana( $readData[0]['data'][$i][29], "ask")),		//  'JS No.',

						'sales_office_no' => $readData[0]['data'][$i][30],		//  '営業所 No.',

						'repair_detail1' => $this->ConvStr( $readData[0]['data'][$i][31] ),		//  '補修内容1',
						'qty' => $this->ConvStr( $readData[0]['data'][$i][32] ),		//  '数量',
						'unit_price' => $this->ConvStr( $readData[0]['data'][$i][33] ),		//  '単価',
						'remarks' => $this->ConvStr( $readData[0]['data'][$i][34] ),		//  '備考',

						'repair_detail2' => $this->ConvStr($readData[0]['data'][$i][35]),		//  '補修内容2',
						'repair_detail3' => $this->ConvStr($readData[0]['data'][$i][36]),		//  '補修内容3',
						'repair_detail4' => $this->ConvStr($readData[0]['data'][$i][37]),		//  '補修内容4',
						'repair_detail5' => $this->ConvStr($readData[0]['data'][$i][38]),		//  '補修内容5',
						'repair_detail6' => $this->ConvStr($readData[0]['data'][$i][39]),		//  '補修内容6',

						'repair_detail7' => $this->ConvStr($readData[0]['data'][$i][40]),		//  '補修内容7',
						'repair_detail8' => $this->ConvStr($readData[0]['data'][$i][41]),		//  '補修内容8',
						'repair_detail9' => $this->ConvStr($readData[0]['data'][$i][42]),		//  '補修内容9',
						'repair_detail10' => $this->ConvStr($readData[0]['data'][$i][43]),		//  '補修内容10',
						'repair_detail11' => $this->ConvStr($readData[0]['data'][$i][44]),		//  '補修内容11',
						'repair_detail12' => $this->ConvStr($readData[0]['data'][$i][45]),		//  '補修内容12',
						'repair_detail13' => $this->ConvStr($readData[0]['data'][$i][46]),		//  '補修内容13',
						'repair_detail14' => $this->ConvStr($readData[0]['data'][$i][47]),		//  '補修内容14',
						'repair_detail15' => $this->ConvStr($readData[0]['data'][$i][48]),		//  '補修内容15',
						'list_price' => $this->ConvStr( $readData[0]['data'][$i][49] ),		//  '定価',

						'repair_true' => $this->ConvStr( $readData[0]['data'][$i][50]),		//  '補修内容・真',
						'discount' => $readData[0]['data'][$i][51],		//  '値引き',
						'tax_rate' => $readData[0]['data'][$i][52],		//  '消費税率',
						'recycle_seal' => $readData[0]['data'][$i][53],		//  'リサイクルシール',
						'recycle_seal_qty' => $readData[0]['data'][$i][54],		//  'リサイクルシール個数',
						'work_cost_subtotal' => $readData[0]['data'][$i][55]		//  '工事費小計'
						);
			$k++;
		}
//debug($data);
//		if(false){
		if(!$this->Workreport->saveAll($data['Workreport'], array('atomic' => false))){		//更新
			$errors = $this->Workreport->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
		}else{
			if($this->Workreport->find('count') > 0){
				$this->set('error_message', "ファイル・アップロードに成功しました。");
			}else{
				$this->set('error_message', "ファイル・アップロードに失敗しました。");
debug($this->Workreport->getAffectedRows());
			}

		}

	}

	private function csv_save_proc($up_file){
		$sql = "TRUNCATE TABLE `Workreport`";
//		$this->Workreport->query($sql);

		$handle = @fopen($up_file, "r");
		if ($handle) {
			$line = "";
		    while (!feof($handle)) {
		        $buf = fgets($handle, 4096);
//echo "buf=[".$buf."]<hr>";
				$last = substr($buf, -3);
//echo "last=[".$last."]<hr>";
//echo "last=[".bin2hex($last)."]<hr>";
				if(($last == "\x22\x0d\x0a") || ($last == "\x22\x0a")){
					$line .= "\x22";
//echo $line."<hr>";
		//			$this->Common->save_csv_line($this->Workreport, $line);
					$line = "";
				}else
					$line .= $buf;
		    }
		    fclose($handle);
			$this->set('error_message', "ファイル・アップロードに成功しました。");
		}
	}


	private function ConvStr($s){
		if($s == "")
			return "";
		if($s == null)
			return "";
		//$s = $common->mbTrim($s);
		$s = trim($s);
		if($s == "")
			return "";

		$NowPos = 0;
		$buf = "";
		for($i=1; $i <= mb_strlen($s); $i++){
			$c = mb_substr($s, $NowPos, 1);
        	$n = ord($c);
        	// debug($c);
        	// debug($n);
        	If( $c == "'"){
            	$buf = $buf . "\'";
        	}elseif( $c == chr(10)){
            	$buf = $buf . chr(10);
        	}elseif( $c == chr(29)){
            	$buf = $buf . "/";

        	}elseif( $n == 9 ){
            	$buf = $buf . "_";
debug("UnknownCH：[".$c."][".$n."][".$s."]");
exit();

        	}elseif( $c == "/" ){
            	$buf = $buf . "／";
debug("UnknownCH：[".$c."][".$n."][".$s."]");
exit();

        	}elseif($n > 0 and $n <= 30){
debug("UnknownCH：[".$c."][".$n."][".$s."]");
exit();
            	$buf = $buf . "?";
        	}else{
            	$buf = $buf . $c;
        	}
        	$NowPos = $NowPos + 1;
    	}
    	return $buf;
	}

	
	function download($arg1="", $arg2=""){
		if($arg2)
			$this->Workreport->id = $arg2;
		else
			$this->Workreport->id = $this->Common->getPost($this, 'Workreport', 'id');

		$data1 = $this->Workreport->read();	//読み出し
		$data2 = $this->Workphoto->find('all', array('conditions' => array('wr_id' => $data1['Workreport']['id']), 'order' => array('page' => 'asc')));
//debug($data1);
//debug($data2);
//exit();
		$filename = $this->xlsx_write_proc($arg1, $data1, $data2);

		$path = $this->Common->ConvPath( WWW_ROOT."files/workreport/excel/" );
		$excel_file = $path.$filename;

		if($arg1 == "search_proc1"){
			//$filename = "工事内訳書.xlsx";
			$filename = "工事内訳書.xls";
		}elseif($arg1 == "search_proc2"){
			//$filename = "工事内訳書2.xlsx";
			$filename = "工事内訳書2.xls";
		}elseif($arg1 == "search_proc3"){
			//$filename = "緊急処理報告書.xlsx";
			$filename = "緊急処理報告書.xls";
		}elseif($arg1 == "search_proc4"){
			//$filename = "補修等施工完了報告書.xlsx";
			$filename = "補修等施工完了報告書.xls";
		}elseif($arg1 == "search_proc_all"){
			//$filename = "全工事報告書.xlsx";
			$filename = "全工事報告書.xls";
		}
		$download_filename = date("Ymd_") . $data1['Workreport']['id'] ."_". $filename;

		Configure::write('debug', 0);       // debugコードを非表示
		header("Content-disposition: attachment; filename={$download_filename}");    //ダウンロードさせるため
		header("Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; name={$download_filename}");
 
		$result = file_get_contents( $excel_file );   // ダウンロードするデータの取得
		print( $result );           // 出力
 exit();
//debug($up_file);
		if($file_name){
			if(strstr($file_name, ".xlsx")){
				//$this->csv_save_proc($up_file);
				//$this->xlsx_save_proc($up_file);
				//$this->redirect(array('controller'=>'workreport','action'=>$arg1, $arg2));
			}else
				$this->set('error_message', "ファイルのダウンロードに失敗しました。[".$this->data['Upload']['file_name']['name']."]");
		}
	}

	private function xlsx_write_proc($action, $data1, $data2){
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/workreport/excel/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/workreport/excel/" );
		if($action == "search_proc1"){
			//$filename = "doc1_work1.xlsx";
			$filename = "doc1_work1.xls";
		}elseif($action == "search_proc2"){
			//$filename = "doc2_work2.xlsx";
			$filename = "doc2_work2.xls";
		}elseif($action == "search_proc3"){
			//$filename = "doc3_emerg.xlsx";
			$filename = "doc3_emerg.xls";
		}elseif($action == "search_proc4"){
			//$filename = "doc4_repair.xlsx";
			$filename = "doc4_repair.xls";
		}elseif($action == "search_proc_all"){
			//$filename = "doc4_repair.xlsx";
			$filename = "doc5_all_work.xls";
		}
		$excel_file0 = $path0.$filename;
		$excel_file = $path.$filename;
		
		if(file_exists($excel_file))
			unlink($excel_file);
		copy($excel_file0, $excel_file);
		
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** IO Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );
//print_r($this->data); echo "<br>";
        //App::import('vendor','phpexcel/phpexcel');

        //ファイルを読み込む
        //$objReader = PHPExcel_IOFactory::createReader('Excel2007');
		$objReader = PHPExcel_IOFactory::createReader('Excel5');
        $objPHPExcel = $objReader->load($excel_file);


		if($action == "search_proc_all"){
			$objPHPExcel->setActiveSheetIndex(0);
			//$objPHPExcel->getSheetByName("Sheet1");
        	$sheet = $objPHPExcel->getActiveSheet();
			$this->sheet_write_proc("search_proc1", $sheet, $data1);

			$objPHPExcel->setActiveSheetIndex(5);
			//$objPHPExcel->getSheetByName("Sheet6");
        	$sheet = $objPHPExcel->getActiveSheet();
			$this->sheet_write_proc("search_proc2", $sheet, $data1);

			$objPHPExcel->setActiveSheetIndex(6);
			//$objPHPExcel->getSheetByName("Sheet7");
        	$sheet = $objPHPExcel->getActiveSheet();
			$this->sheet_write_proc("search_proc3", $sheet, $data1);

			$objPHPExcel->setActiveSheetIndex(7);
			//$objPHPExcel->getSheetByName("Sheet8");
        	$sheet = $objPHPExcel->getActiveSheet();
			$this->sheet_write_proc("search_proc4", $sheet, $data1);

		}else{
			$objPHPExcel->setActiveSheetIndex(0);
			//$objPHPExcel->getSheetByName("Sheet1");
        	$sheet = $objPHPExcel->getActiveSheet();
        	//$sheet->setCellValueByColumnAndRow($c, $r+1, $v);

			$this->sheet_write_proc($action, $sheet, $data1);
		}

		// ページ２以降の写真
		$data3 = array();
		for($i=1; $i<=4; $i++){
			for($k=0; $k<count($data2); $k++){
				if(($data2[$k]['Workphoto']['page'] >= intval($i."1")) and ($data2[$k]['Workphoto']['page'] <= intval($i."3"))){
					$data3 = $data2[$k]['Workphoto'];
					break;
				}
			}
//debug(empty($data3));
//debug($data3);
			if(empty($data3)){
				// Excel2007形式で保存する
				//$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
				$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel5");
				$writer->save($excel_file);
				return $filename;
			}
			
			
			if(($data3['page'] >= intval($i."1")) and ($data3['page'] <= intval($i."3"))){
//debug($i."=arrayは正常です。");
			}else{
//debug($i."=arrayは空です。");
				continue;
			}

			$photoRightTop =array("", "K5", "K56", "K107");
			$no_posi =array("", "BA4", "BA55", "BA106");
			$ap_name =array("", "AY7", "AY58", "AY109");
			$unit_no =array("", "AY11", "AY62", "AY113");
			$msg_posi =array("", "AY14", "AY65", "AY116");
			$judgment_posi =array("", "BB47", "BB98", "BB149");
			for($j=1; $j<=3; $j++){
				for($k=0; $k<count($data2); $k++){
					if($data2[$k]['Workphoto']['page'] == intval($i.$j)){
						$data3 = $data2[$k]['Workphoto'];
						break;
					}
				}
				if($data3['page'] == intval($i.$j)){
//debug($i.$j."=arrayは正常です。");
				}else{
//debug($i.$j."=arrayは空です。");
					continue;
				}
				
				$objPHPExcel->setActiveSheetIndex($i);
				//$objPHPExcel->getSheetByName("Sheet".$i);
        		$sheet = $objPHPExcel->getActiveSheet();

				$sheet->setCellValue($no_posi[$j], $data3['no']);
				$sheet->setCellValue($ap_name[$j], $data1['Workreport']['apartment_name']);
				$sheet->setCellValue($unit_no[$j], $data1['Workreport']['unit_number']);
				$sheet->setCellValue($msg_posi[$j], $data3['msg']);
				$sheet->setCellValue($judgment_posi[$j], $data3['judgment']);

				$photo_name = $data3['photo_name'];
				$photo_blob = $data3['photo_blob'];
				$image_file = $path.$photo_name;
				//---------------------------------------------------
				//写真ファイル保存
				//$size = file_put_contents($path . $photo_name, $photo_blob);
			    if (!$handle = fopen($path . $photo_name, 'w')) {
	    	   		echo "Cannot open file ($photo_name)";
        			exit;
    			}
	    		// オープンしたファイルに$somecontentを書き込みます
    			if (fwrite($handle, base64_decode($photo_blob)) === FALSE) {
	       			echo "Cannot write to file ($photo_name)";
        			exit;
    			}
		    	//echo "Success, wrote ($somecontent) to file ($filename)";
				fclose($handle);
				
				//---------------------------------------------------
				//$w2 = 13 * 37 + 3;	//485;
				//$h2 = 8 * 42 + 2;	//339;
				$w2 = intval(13 * 30.5);	//485;
				$h2 = 8 * 44;	//339;
				//写真ファイルをエクセル貼り付け

				///画像用のオプジェクト作成
				$objDrawing = new PHPExcel_Worksheet_Drawing();
				$objDrawing->setPath( $image_file ); ///貼り付ける画像のパスを指定

				//↓これが必要
				$objDrawing->setResizeProportional(false);
				//↑これが必要
				$objDrawing->setWidth( $w2 );////画像の幅を指定
				$objDrawing->setHeight( $h2 );////画像の高さを指定
				///画像のプロパティを見たときに表示される情報を設定
				$objDrawing->setName('Yoji Yoshikura');////ファイル名
				$objDrawing->setDescription('Yoji Yoshikura');////画像の概要

				$objDrawing->setCoordinates( $photoRightTop[$j] );///位置
				$objDrawing->setOffsetX(0);////横方向へ何ピクセルずらすかを指定
				//$objDrawing->setRotation(25);//回転の角度
				//$objDrawing->getShadow()->setVisible(true);////ドロップシャドウをつけるかどうか。
				// $drawing->getShadow()->setDirection(45); // ドロップシャドウの方向
				///PHPExcelオブジェクトに張り込み
				$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

			}
		}
//exit();
		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel5");
		$writer->save($excel_file);
		return $filename;

//debug($this->data['Workreport']['recycle_seal']);
//debug($this->data['Workreport']['dest_low']);


	}


	private function sheet_write_proc($action, $sheet, $data1){
		if(is_null($sheet)){
			debug("エクセル・シート　エラー");
			return;
		}
	
		if(($action == "search_proc1") or ($action == "search_proc2")){
			$sheet->setCellValue('E4', $data1['Workreport']['branch']);
			$sheet->setCellValue('D6', $data1['Workreport']['apartment_name']);
			$sheet->setCellValue('D8', $data1['Workreport']['unit_number']);
			$sheet->setCellValue('D10', $data1['Workreport']['resident_name']);
			$sheet->setCellValue('D12', $data1['Workreport']['phone']);
			$sheet->setCellValue('D14', $data1['Workreport']['repair_subject']);

			$sheet->setCellValue('J9', $data1['Workreport']['js_no']);
			$sheet->setCellValue('J11', $data1['Workreport']['sales_office_no']);	//date('Y年m月d日', strtotime($data1['Workreport']['js_no'])));

			$sheet->setCellValue('C20', $data1['Workreport']['repair_detail1']);
			$sheet->setCellValue('C21', $data1['Workreport']['repair_detail2']);
			$sheet->setCellValue('C22', $data1['Workreport']['repair_detail3']);
			$sheet->setCellValue('C23', $data1['Workreport']['repair_detail4']);
			$sheet->setCellValue('C24', $data1['Workreport']['repair_detail5']);
			$sheet->setCellValue('C25', $data1['Workreport']['repair_detail6']);
			$sheet->setCellValue('C26', $data1['Workreport']['repair_detail7']);
			$sheet->setCellValue('C27', $data1['Workreport']['repair_detail8']);
			$sheet->setCellValue('C28', $data1['Workreport']['repair_detail9']);
			$sheet->setCellValue('C29', $data1['Workreport']['repair_detail10']);
			$sheet->setCellValue('C30', $data1['Workreport']['repair_detail11']);

			$sheet->setCellValue('C31', $data1['Workreport']['repair_detail12']);
			$sheet->setCellValue('C32', $data1['Workreport']['repair_detail13']);
			$sheet->setCellValue('C33', $data1['Workreport']['repair_detail14']);
			$sheet->setCellValue('C34', $data1['Workreport']['repair_detail15']);

//debug($data1['Workreport']['list_price']);
			$a = explode("/", $data1['Workreport']['list_price']);
			$b = explode("/", $data1['Workreport']['qty']);
			$c = explode("/", $data1['Workreport']['unit_price']);
			$e = explode("/", $data1['Workreport']['remarks']);
		
			for($i=0; $i<15; $i++){
				$sheet->setCellValue('E'.strval(20 + $i), $a[$i]);
				$sheet->setCellValue('G'.strval(20 + $i), $b[$i]);	//floatval($data1['Workreport']['qty']));

				$sheet->setCellValue('I'.strval(20 + $i), $c[$i]);
				if(($b[$i] * $c[$i]) > 0)
					$sheet->setCellValue('J'.strval(20 + $i), ($b[$i] * $c[$i]));
				$sheet->setCellValue('K'.strval(20 + $i), $e[$i]);
			}
		
			$discount =  floatval($data1['Workreport']['discount']);
			$sheet->setCellValue('I39', ($discount * -1));
		
			$sub_total = intval($data1['Workreport']['work_cost_subtotal']);
			$sheet->setCellValue('I40', $sub_total);
		
			$tax = intval($sub_total * intval($data1['Workreport']['tax_rate']) / 100);
			$sheet->setCellValue('I41', $tax);
			if($action == "search_proc1"){
				$sheet->setCellValue('I42', $sub_total + $tax);
			}else{
				$sheet->setCellValue('I42', $data1['Workreport']['recycle_seal_qty']);
				$sheet->setCellValue('I43', $sub_total + $tax);
			}
		}elseif($action == "search_proc3"){
			$sheet->setCellValue('D5', $data1['Workreport']['receptionist']);
			$sheet->setCellValue('G5', $data1['Workreport']['branch']);
			
			$sheet->setCellValue('D7', $data1['Workreport']['apartment_name']);
			$sheet->setCellValue('H7', $data1['Workreport']['place']);
			$sheet->setCellValue('D8', $data1['Workreport']['contact_person']);
			$sheet->setCellValue('H8', $data1['Workreport']['phone']);
			$sheet->setCellValue('D9', $data1['Workreport']['receipt_time']);
			$sheet->setCellValue('H9', $data1['Workreport']['receipt_no']);
			$sheet->setCellValue('C11', $data1['Workreport']['accident']);

			$sheet->setCellValue('D13', $data1['Workreport']['process_date']);
			$sheet->setCellValue('H13', $data1['Workreport']['processor']);
			$sheet->setCellValue('D14', $data1['Workreport']['arrival_time']);
			$sheet->setCellValue('H14', $data1['Workreport']['finish_time']);
			$sheet->setCellValue('C16', $data1['Workreport']['cause']);
			
			$sheet->setCellValue('C19', $data1['Workreport']['processing']);
			$sheet->setCellValue('I20', $data1['Workreport']['reported']);

		}elseif($action == "search_proc4"){
			$sheet->setCellValue('C3', $data1['Workreport']['apartment_name']);
			$sheet->setCellValue('G3', $data1['Workreport']['place']);
			$sheet->setCellValue('B5', $data1['Workreport']['request']);
			$sheet->setCellValue('G4', $data1['Workreport']['requester']);
			$sheet->setCellValue('G5', $data1['Workreport']['request_date']);
			$sheet->setCellValue('H6', $data1['Workreport']['work_date']);
			$sheet->setCellValue('B7', $data1['Workreport']['repair_true']);

			$a = explode("/", $data1['Workreport']['insulation_ohm1']);
			$b = explode("/", $data1['Workreport']['insulation_ohm2']);
			$c = explode("/", $data1['Workreport']['insulation_ohm3']);
			$d = explode("/", $data1['Workreport']['insulation_ohm4']);
			$sheet->setCellValue('D8', $a[0]);
			$sheet->setCellValue('D9', $a[1]);
			$sheet->setCellValue('F8', $b[0]);
			$sheet->setCellValue('F9', $b[1]);
			$sheet->setCellValue('G8', $c[0]);
			$sheet->setCellValue('G9', $c[1]);
			$sheet->setCellValue('H8', $d[0]);
			$sheet->setCellValue('H9', $d[1]);
			
		}
	}


	private function zero_check($n){
		if($n == "")
			return "";
		elseif(is_numeric($n))
			return number_format(intval( $n ));
		else
			return $n;
	}
	
	private function photo_resize($photo_name){
		$path = $this->Common->ConvPath( WWW_ROOT."files/workreport/jpg/" );
		$image_file1 = $path.$photo_name;
		$image_file2 = $path."temp.jpg";
		if(file_exists( $image_file2 ))
			unlink($image_file2);
		list($w1, $h1, $type) = getimagesize( $image_file1 ); // 元の画像名を指定してサイズを取得
		//画像ロード
		$image1 = imagecreatefromjpeg( $image_file1 );	// 元の画像から新しい画像を作る準備

		//$w2 = 13 * 37 + 3;	//485;
		//$h2 = 8 * 42 + 2;	//339;
		$w2 = intval(13 * 30.5);	//485;
		$h2 = 8 * 44;	//339;

		$image2 = ImageCreateTrueColor($w2, $h2);
		//縮小しながらコピー
		imagecopyresampled($image2, $image1, 0, 0, 0, 0, $w2, $h2, $w1, $h1);
		//JPEG 品質85で保存
		imagejpeg($image2, $image_file2, 85);
		
		unlink($image_file1);
		rename($image_file2, $image_file1);
		return $image_file1;
	}

}