<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/scheduley/

class ScheduleyController extends AppController {
	public $name = 'Scheduley';
	public $uses = array('User', 'Scheduley', 'Logs');
	public $layout = 'dafault';

	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'
	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;
	private $debug = false;

    function beforeFilter() {
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

		$this->set('main_title', "予定表(工事)");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Scheduley
		$this->set('URL_SELF', $this->URL_SELF);

		//$username = $this->Auth->user('username');
		//$this->set('username', $username);
		
		//$username = $this->User->field('User', array('username' => $username));
		//$this->set('username', $username);
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/Scheduley_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'scheduley','action'=>'search'));
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "予定表(工事)",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "予定表(工事)";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}



	/* =================== 　予定表(工事)検索　 ======================= */
	public function search() {
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'scheduley','action'=>'index'));
		}
		$this->set('main_title', '予定表(工事)');
		$this->set('sub_title', '検索');

//****		//$this->MakeWorkIntervalTime();

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Scheduley', 'search');
		$id = $this->Common->getPost($this, 'Scheduley', 'id');

		$work_date = $this->Common->getPost($this, 'Scheduley', 'work_date');

		$work_date1 = $this->Common->getPost($this, 'Scheduley', 'work_date1');
		$work_date2 = $this->Common->getPost($this, 'Scheduley', 'work_date2');
		if(!$work_date1){
			$a = $this->Common->GetModelAll("Scheduley", "work_date");
			if(count($a) > 0)
				$work_date1 = $a[0];
			$this->set('work_date1', 	$work_date1);
		}
//debug($work_date1);

		if(!$work_date2){
			$a = $this->Common->GetModelAll("Scheduley", "work_date");
			if(count($a) > 0)
				$work_date2 = $a[count($a)-1];
			$this->set('work_date2', 	$work_date2);
		}
//debug($work_date2);

		$work_group = $this->Common->getPost($this, 'Scheduley', 'work_group');

		$site_name = $this->Common->getPost($this, 'Scheduley', 'site_name');
		$site_color = $this->Common->getPost($this, 'Scheduley', 'site_color');
		$site_time1 = $this->Common->getPost($this, 'Scheduley', 'site_time1');
		$site_time2 = $this->Common->getPost($this, 'Scheduley', 'site_time2');
		$car_no = $this->Common->getPost($this, 'Scheduley', 'car_no');

		$deploy_name = $this->Common->getPost($this, 'Scheduley', 'deploy_name');

		$note = $this->Common->getPost($this, 'Scheduley', 'note');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Scheduley', 'page');
		$direction = $this->Common->getPost($this, 'Scheduley', 'direction');
		$sort = $this->Common->getPost($this, 'Scheduley', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($work_date)
			$condition = array_merge_recursive($condition, array( "work_date like" => '%'.$work_date.'%'));
		if(($work_date1) and ($work_date2))
			$condition = array_merge_recursive($condition, array( 'work_date BETWEEN ? AND ?' => array($work_date1, $work_date2)));

		if($work_group)
			$condition = array_merge_recursive($condition, array( "work_group like" => $work_group));
		if($deploy_name)
			$condition = array_merge_recursive($condition, array( "deploy_name like" => '%'.$deploy_name.'%'));
		if($site_name)
			$condition = array_merge_recursive($condition, array( "site_name like" => '%'.$site_name.'%'));
		if($site_color)
			$condition = array_merge_recursive($condition, array( "site_color like" => '%'.$site_color.'%'));

		if($site_time1)
			$condition = array_merge_recursive($condition, array( "site_time1 like" => $site_time1));
		if($site_time2)
			$condition = array_merge_recursive($condition, array( "site_time2 like" => $site_time2));
		if($car_no)
			$condition = array_merge_recursive($condition, array( "car_no like" => '%'.$car_no.'%'));
		if($note)
			$condition = array_merge_recursive($condition, array( "note like" => '%'.$note).'%');


		$this->set('condition', $condition);
//debug($condition);
		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "work_date" => urlencode($work_date),
				     "work_date1" => urlencode($work_date1),
				     "work_date2" => urlencode($work_date2),
				     "work_group" => urlencode($work_group),
				     "deploy_name" => urlencode($deploy_name),
				     "site_name" => urlencode($site_name),
				     "site_color" => urlencode($site_color),
				     "site_time1" => urlencode($site_time1),
				     "site_time2" => urlencode($site_time2),
				     "car_no" => urlencode($car_no),
				     "note" => urlencode($note),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Scheduley' => array('conditions' => $condition, 'limit'=>100, 
				'order'=>['work_date'=>'asc', 'deploy_name'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc']
				));		//'sort2'=>$sort, 'direction'=>$direction
		$this->data = $this->paginate('Scheduley');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);
		$this->set('login_user', $user0['User']);

		$this->set('ExportDateY', date("Y"));
		$this->set('ExportDateM', date("m"));

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			//if(!$search)
			//	$this->redirect(array('controller'=>'scheduley','action'=>'search', 'page:1/direction:asc/sort2:work_date'));
		}
//debug($sort);
	}

	function search_update(){
		$this->MakeWorkIntervalTime();
		$this->redirect(array('controller'=>'scheduley','action'=>'search'));
	}

	function MakeWorkIntervalTime(){
		//$data = $this->Scheduley->find('all', array('order' => ['work_date'=>'asc', 'deploy_name'=>'desc', "CAST( DATE_FORMAT(site_time1, '%H%i') AS UNSIGNED)" =>'desc'] ));
		$data = $this->Scheduley->find('all', array('order' => ['work_date'=>'asc', 'deploy_name'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc'] ));
			 //'fields' => array('site_time1', "CAST(replace(site_time1, ':', '') AS UNSIGNED) as time"),
//debug($this->Scheduley->getDataSource()->getLog(false, false));
//debug($data);
//exit();
		$work_group = 1;
		for($i=0; $i<count($data); $i++){
			$site_time1 = $data[$i]['Scheduley']['site_time1'];
			$site_time2 = $data[$i]['Scheduley']['site_time2'];
			
			$n1 = strtotime($site_time1);
			$n2 = strtotime($site_time2);
			$h = $n2 - $n1;
			if($h > 0){
				$h += strtotime('2012/01/01');
				$work_time = date("H:i", $h);
			}else{
			  	$work_time = "?";
			}
			$this->Scheduley->set('id', $data[$i]['Scheduley']['id']);
			$this->Scheduley->saveField('work_time', $work_time);

			$work_interval = "";
			if(isset($data[$i+1]['Scheduley']['work_date'])){
				if( ($data[$i+1]['Scheduley']['work_date'] == $data[$i]['Scheduley']['work_date'])
					and ($data[$i+1]['Scheduley']['deploy_name'] == $data[$i]['Scheduley']['deploy_name']) ){
			
					$next_site_time1 = $data[$i+1]['Scheduley']['site_time1'];
			
					if($next_site_time1 <> ""){
						$n1 = strtotime($site_time2);
						$n2 = strtotime($next_site_time1);		//strtotime($data['Scheduley']['site_time1']);
						$h = $n2 - $n1;

//debug($i);
//debug($h);
//debug($site_time2);
//debug($n1);
//debug($next_site_time1);
//debug($n2);

						if($h >= 0){
							$h += strtotime('2012/01/01');
							$work_interval = date("H:i", $h);
						}else{
					  		$work_interval  = "?";		//"?"
//debug($data[$i]['Scheduley']['work_date']);
//debug($site_time2);
//debug($next_site_time1);
//exit();
						}
					}
				}
			}

			if(isset($data[$i-1]['Scheduley']['work_date'])){
				if($data[$i-1]['Scheduley']['work_date'] != $data[$i]['Scheduley']['work_date']){
					$work_group = 1;
				}elseif( ($data[$i-1]['Scheduley']['work_date'] == $data[$i]['Scheduley']['work_date'])
					and ($data[$i-1]['Scheduley']['deploy_name'] != $data[$i]['Scheduley']['deploy_name']) ){
					$work_group += 1;
				}
			}else{
				$work_group = 1;
			}
			$this->Scheduley->set('id', $data[$i]['Scheduley']['id']);
			$this->Scheduley->saveField('work_interval', $work_interval);
			$this->Scheduley->saveField('work_group', $work_group);
		}//end for
		
		$SqlStr = "SET @n := 0";
		$ret = $this->Scheduley->query($SqlStr);
		$SqlStr = "UPDATE scheduley SET id = (@n := @n +1)";
		$ret = $this->Scheduley->query($SqlStr);
		//$this->DispTable($data);
	
	}
	
	function search_export(){
		$year = $this->Common->getPost($this, 'Scheduley', 'ExportDateY');
		if($year == "")
			$year = "2021";
		// 月を指定
		$month = $this->Common->getPost($this, 'Scheduley', 'ExportDateM');
		if($month == "")
			$month = '04';
		$first_date = date('Y-m-d', strtotime('first day of ' . $year."-".$month));
//debug($first_date);
		$week_num = date("w", strtotime($first_date));
//debug($week_num);
		if ($week_num == 0){
			//日曜日だった場合
  			$monday1 = date('Y/m/d', strtotime("-6 day", strtotime($first_date)));
		}else{
  			$monday1 = date('Y/m/d', strtotime("-{$week_num} day", strtotime($first_date) + 24*60*60));
		}
//debug($monday1);
//exit();
		$last_date = date('Y-m-d', strtotime('last day of ' . $year."-".$month));
//debug("指定月の初日：" . $first_date);
//debug("指定月の末日：" . $last_date);

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		//----------------------------
		//$excel_fil0e = "schedule.xlsx";
		$excel_file0 = "schedule.xls";
		//----------------------------
		$xcellFile0 = $_SERVER['DOCUMENT_ROOT']."/inabou/app/webroot/files/scheduley/ORG/".$excel_file0;
		//$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/scheduley/ORG/".$excel_file0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$excel_file = date("YmdHis")."_".$excel_file0;
		$excel_file = date("Ym", strtotime($first_date))."_".$excel_file0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/scheduley/".$excel_file);
		//$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/scheduley/20210512_".$excel_file);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);

		/** PHPExcelを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		// PHPExcelオブジェクトを生成する
		//$obj = PHPExcel_IOFactory::createReader("Excel2007");
		//$obj = PHPExcel_IOFactory::createReader('Excel5');
		
		//$book = $obj->load($xcellFile);
		//$book = new PHPExcel();
		$book = PHPExcel_IOFactory::load($xcellFile);

		$data = $this->Scheduley->find('all', array('conditions' => array( 'work_date BETWEEN ? AND ?' => array($first_date, $last_date)), 
					'order' => ['work_date'=>'asc', 'deploy_name'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc'] ));
		
		//$sql = "SELECT * FROM `scheduley` WHERE `work_date` BETWEEN '".$first_date."' and '".$last_date."' ORDER BY `work_date` asc, `deploy_name` asc, CAST(replace(site_time1, ':', '') AS UNSIGNED) asc, `id` asc ";
		//$data = $this->Scheduley->query($sql);

//$log = $this->Scheduley->getDataSource()->getLog(false, false);       
//debug($log);
		$data_count = count($data);
//debug($data_count);
//debug($data);
//exit();
		$a = ["A2", "A18", "A34", "G2", "G18", "G34", "G50"]; //'日にちの配列
		$b = ["A12", "A28", "A44", "G12", "G28", "G44", "G54"]; //'曜日にちの配列
		$c = ["月", "火", "水", "木", "金", "土", "日"]; //'日にちの配列

		for($sh=0; $sh<6; $sh++){
//$sh=0;
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<count($a); $i++){
				// セルに値をセットする
				if($i == 0){
//debug( date("n/d", strtotime($monday1)) );
					$sheet->setCellValue($a[$i], date("n/d", strtotime($monday1)));
				}else{
					$sheet->setCellValue($a[$i], date("n/d", strtotime("+{$i} day", strtotime($monday1))));
				}
				$sheet->setCellValue($b[$i], $c[$i]);
			}
			$monday1 = date('Y/m/d', strtotime( "+{$i} day", strtotime($monday1) ));
			//-----------------------------------------------
		}//endfor
//exit();		
		
        //$rows = [4, 18, 32, 4, 18, 32, 46];
        $rows = [2, 18, 34, 2, 18, 34, 50, 56];
        $cols = [2,  2,  2, 8,  8,  8, 8];
		
		$n = 0;
		$old_deploy_name = "";
		for($sh=0; $sh<6; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<count($a); $i++){
				$work_date1 = $year."/".$sheet->getCell( $a[$i] )->getValue();
				for($j=0; $j<16; ){		//1日分の行数
					//$data[$n]['Scheduley'] = $data[$n]['scheduley'];
					if(isset($data[$n]['Scheduley']['work_date']) == false){
//debug($data);
//exit();
						break;
					}
					$work_date2 = $data[$n]['Scheduley']['work_date'];
//debug($work_date1);
//debug($work_date2);
//exit();
					if(strtotime($work_date1) == strtotime($work_date2)){
						if($data[$n]['Scheduley']['deploy_name'] != $old_deploy_name){
						// セルに値をセットする
//debug(($cols[$i] -1)."･".($rows[$i] + $j));
//debug($data[$n]['Scheduley']['site_name']);

//debug($data[$n]['Scheduley']['site_color']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $data[$n]['Scheduley']['site_name']);
							$site_color_str = $data[$n]['Scheduley']['site_color'];
							$sheet->getStyleByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getFont()->getColor()->setRGB( $site_color_str );
							
							$sheet->setCellValueByColumnAndRow( $cols[$i] , $rows[$i] + $j, $data[$n]['Scheduley']['car_no']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] +1, $rows[$i] + $j, $data[$n]['Scheduley']['deploy_name']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] +2, $rows[$i] + $j, $data[$n]['Scheduley']['note']);

							$j++;
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $data[$n]['Scheduley']['site_time1']."-".$data[$n]['Scheduley']['site_time2']);
							$j++;
							$old_deploy_name = $data[$n]['Scheduley']['deploy_name'];
//exit();
						}else{
							$j -= 2;
//debug(($cols[$i] -1)."･".($rows[$i] + $j));
							$site_name_str = $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue();
							$site_name_str .= "|".$data[$n]['Scheduley']['site_name'];
							$site_names = explode("|", $site_name_str);
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $site_name_str);

							$site_color_str .= "|".$data[$n]['Scheduley']['site_color'];
							$site_colors = explode( "|", $site_color_str );
							//======================================================================================
//if("コムネット府中美好町（共用部のみ）,横浜チラシ")
							//  リッチテキストで前半はサイズ12で、後半はサイズ20で設定
							$objRichText = new PHPExcel_RichText();
							
							for($k=0; $k<count($site_names); $k++){
								if($k <> 0){
									$objTextElm = $objRichText->createTextRun( "|" );
									$objTextElm->getFont()->getColor()->setRGB( "000000" );
								}
								//  リッチテキストに文字列設定
								$objTextElm = $objRichText->createTextRun( $site_names[$k] );
								//  フォントカラー設定
								$objTextElm->getFont()->getColor()->setRGB( $site_colors[$k] );
 							}
							
							//  [xx]セルに設定
							$sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->setValue($objRichText);
							//======================================================================================

							$j++;
							$site_time =  $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue();
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $site_time."|".$data[$n]['Scheduley']['site_time1']."-".$data[$n]['Scheduley']['site_time2']);
							$j++;
						}
						$n++;
					}else{
						break;
					}
					if($n >= $data_count) break;
				}	//end og for $j
				if($i == 8){
					debug("ループ・エラー". $i);
					exit();
				}
				if($n >= $data_count) break;
			}// end of for $i
			//-----------------------------------------------
			if($n >= $data_count) break;
		}//endfor $sh
		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($book, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel5');
		$writer->save($xcellFile);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		exit();
	
		$this->redirect(array('controller'=>'scheduley','action'=>'search'));
	}
	
	
	function DispTable($list){
		//		https://teratail.com/questions/73006

		$header = ["id"=>"id","work_date"=>"作業日","work_group"=>"グループ","deploy_num"=>"配置No",  "deploy_name"=>"配置名",
			"site_name"=>"現場名", "site_color"=>"現場色", "site_time1"=>"現場時間1", "site_time2"=>"現場時間2",
			"work_time"=>"作業時間", "work_interval"=>"作業間隔",
			"car_no"=>"車No", "note"=>"備考"];

		$str="";
		$str.="<table>\n";
		$str.="<thead>\n";
		if(is_array($header)){
  			$str.="<tr>\n";
  			foreach($header as $val){$str.="<td>".htmlspecialchars($val)."</td>\n";}
  				$str.="</tr>\n";
		}
		$str.="</thead>\n";
		$str.="<tbody>\n";
		if(is_array($list)){
  			foreach($list as $row){
    			$str.="<tr>\n";
//print_r($row);
    			foreach($row['Scheduley'] as $val){
      				$str.="<td>".htmlspecialchars($val)."</td>\n";
    			}
    			$str.="</tr>\n";
  			}
		}
		$str.="</tbody>\n";
		$str.="</table>\n";
		print $str;
	
	}
	



	function search_import($cmd){
		$excel_file = "K3.5.xls";
		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/scheduley/R/".$excel_file);

		if(file_exists($xcellFile) == false){
			debug("ファイルが存在しない：".$xcellFile);
			exit();
		}
		if($cmd == "new"){
			$sql = "TRUNCATE TABLE `scheduley`";
			$this->Scheduley->query($sql);
		}
		/** PHPExcelを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );
		$book = PHPExcel_IOFactory::load($xcellFile);

        //$a = array("A4", "A18", "A32", "G4", "G18", "G32", "G46");	//'配列
        $a = array("A2", "A18", "A34", "G2", "G18", "G34", "G50");	//'配列

        //$rows = [4, 18, 32, 4, 18, 32, 46];
        //$rows = [2, 18, 34, 2, 18, 34, 50, 56];
        $rows = [2, 18, 34, 2, 18, 34, 50];

        $cols = [2,  2,  2, 8,  8,  8, 8];
		
		$year = "2021";
		$n = 0;
		$old_deploy_name = "";
		$site_colors = array();
		
		for($sh=0; $sh<5; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<count($a); $i++){
				$date_val = $sheet->getCell( $a[$i] )->getCalculatedValue();
				if ( $date_val != '' ) {
					$this->data['Scheduley']['work_date'] = PHPExcel_Style_NumberFormat::toFormattedString( $date_val, PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD2 );
				}else{
					$this->data['Scheduley']['work_date'] = "";
				}
				for($j=0; $j<16; $j++){		//1日分の行数

					$site_name1 = trim( $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue() );
					$site_names = explode("／", $site_name1);
					$site_color1 = $sheet->getStyleByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getFont()->getColor()->getRGB();
					for($k=0; $k<count($site_names); $k++){
						$site_colors[$k] = $site_color1;
					}
					
					$colvl= $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue();
					if ($colvl instanceof PHPExcel_RichText){
    					if (is_array($colvl->getRichTextElements()) ){
							$vla = $colvl->getRichTextElements();
							for( $k=0; $k<count($vla); $k++){
								$vl = $vla[$k];
								if( $vl->getFont() <> "" ){
									$site_colors[$k] = $vl->getFont()->getColor()->getRGB();
								}
							}
						}
					}

					// 000000 黒
					// 92D050 緑
					// 00B0F0 青
					// FFC000 橙
					// 000000 黒
					
					$this->data['Scheduley']['car_no'] = $car_no = trim( $sheet->getCellByColumnAndRow( $cols[$i], $rows[$i] + $j )->getValue() );
					
					$deploy_name = trim( $sheet->getCellByColumnAndRow( $cols[$i] +1, $rows[$i] + $j )->getValue() );
					$this->data['Scheduley']['deploy_name'] = str_replace("・", "･", $deploy_name);
					
					$this->data['Scheduley']['note'] = $note = trim( $sheet->getCellByColumnAndRow( $cols[$i] +2, $rows[$i] + $j )->getValue() );

					if($site_name1 <> ""){
						$site_names = explode("／", $site_name1);
						$j++;
//debug($site_names);
//debug( count($site_names) );
						$site_time1 = trim( $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue() );
						$site_times = $this->explode_time($site_time1);

						for($k=0; $k<count($site_names); $k++){
							$this->data['Scheduley']['site_name'] = $site_name = $site_names[$k];
							//if( isset($site_colors[$k]) )
								$site_color = $site_colors[$k];
							//else
							//	$site_color = $site_color1;

							$this->data['Scheduley']['site_color'] = $site_color;

							if($site_name <> ""){
								list($this->data['Scheduley']['site_time1'], $this->data['Scheduley']['site_time2'])
									= $this->guess_site_time( $site_names, $site_times, count($site_names), count($site_times), $k );
								$this->data['Scheduley']['id'] = null;

								if(!$this->Scheduley->save($this->data)){		//追加
									$errors = $this->Scheduley->invalidFields();
									$mes = '';
									foreach($errors as $field => $message){
										$mes .= $field." : ".$message."<br />\n";
									}
									debug('error_message:'.$mes);
								}
							}
						}
//debug($sh);
//debug($i);
//debug($j);

						
					}else{
						$j++;
					}
				}//end of for $j
			}//end of for $i
//exit();						
		}//end of for $sh

		// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
		$this->redirect(array('controller'=>'scheduley','action'=>'search'));

//	https://ameblo.jp/program-se-nikki/entry-12425034289.html

	}


	function guess_site_time($site_names, $site_times, $count_names, $count_times, $k){
		if($count_names == 1 ){
			return array("9:30", "16:30");

		}elseif($count_names == 2 and $count_times == 0 and $k == 0){
			return array("9:30", "12:00");
		}elseif($count_names == 2 and $count_times == 0 and $k == 1){
			return array("13:00", "16:30");

		}elseif($count_names == 2 and $count_times == 1){
			if( strtotime($site_times[0]) <= strtotime("9:30") and $k == 0)
				return array($site_times[0], "12:00");
			elseif( $k == 1 )
				return array($site_times[0], "16:30");
			else
				return array("13:00", "16:30");
		}elseif($count_names == 2 and $count_times == 2){
			if( strtotime($site_times[0]) <= strtotime("9:30") and $k == 0)
				return array($site_times[0], "12:00");
			elseif( $k == 1 )
				return array($site_times[1], "16:30");
			else
				return array("13:00", "16:30");


		}elseif($count_names == 3 and $count_times == 0 and $k == 0){
			return array("9:30", "12:00");
		}elseif($count_names == 3 and $count_times == 0 and $k == 1){
			return array("13:00", "15:00");
		}elseif($count_names == 3 and $count_times == 0 and $k == 2){
			return array("15:00", "16:30");

		}elseif($count_names == 3 and $count_times == 3){
			if( strtotime($site_times[0]) <= strtotime("9:30") and $k == 0)
				return array($site_times[0], "12:00");
			elseif( $k == 1 )
				return array($site_times[1], $site_times[2]);
			elseif( $k == 2 )
				return array($site_times[2], "16:30");
			else
				return array("15:00", "16:30");


		}elseif($count_names == 4 and $count_times == 0 and $k == 0){
			return array("9:30", "10:00");
		}elseif($count_names == 4 and $count_times == 0 and $k == 1){
			return array("10:00", "12:00");
		}elseif($count_names == 4 and $count_times == 0 and $k == 2){
			return array("13:00", "15:00");
		}elseif($count_names == 4 and $count_times == 0 and $k == 2){
			return array("15:00", "16:30");


		}elseif($count_names == 5 and $count_times == 0 and $k == 0){
			return array("9:30", "10:00");
		}elseif($count_names == 5 and $count_times == 0 and $k == 1){
			return array("10:00", "12:00");
		}elseif($count_names == 5 and $count_times == 0 and $k == 2){
			return array("13:00", "14:00");
		}elseif($count_names == 5 and $count_times == 0 and $k == 3){
			return array("14:00", "15:00");
		}elseif($count_names == 5 and $count_times == 0 and $k == 4){
			return array("15:00", "16:30");


		}elseif($count_names == 6 and $count_times == 0 and $k == 0){
			return array("9:30", "10:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 1){
			return array("10:00", "11:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 2){
			return array("11:00", "12:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 3){
			return array("13:00", "14:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 4){
			return array("14:00", "15:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 5){
			return array("15:00", "16:30");

		}elseif($count_names == 7 and $count_times == 0 and $k == 0){
			return array("9:30", "10:00");
		}elseif($count_names == 7 and $count_times == 0 and $k == 1){
			return array("10:00", "10:30");
		}elseif($count_names == 7 and $count_times == 0 and $k == 2){
			return array("10:30", "11:00");
		}elseif($count_names == 7 and $count_times == 0 and $k == 3){
			return array("11:00", "12:00");
		}elseif($count_names == 7 and $count_times == 0 and $k == 4){
			return array("13:00", "14:30");
		}elseif($count_names == 7 and $count_times == 0 and $k == 5){
			return array("14:30", "15:00");
		}elseif($count_names == 7 and $count_times == 0 and $k == 6){
			return array("15:00", "16:30");
		
		}else{
debug($this->data['Scheduley']['work_date']);
debug($this->data['Scheduley']['site_name']);
debug($this->data['Scheduley']['site_time1']);
debug($this->data['Scheduley']['site_time2']);
debug($site_names);
debug($site_times);
exit();
		}
	
	}
	
	function explode_time($t){
		$t = trim($t);
		if($t == "")
			return array();
		$t1 = mb_convert_kana( $t, "ask");
		$a = explode(" ", $t1);
//if( ($this->data['Scheduley']['work_date'] == "2021-05-29") and ( strstr($this->data['Scheduley']['site_name'], "ヴァンベールA・B")) ){
//if( ($this->data['Scheduley']['work_date'] == "2021-05-07") and ( strstr($this->data['Scheduley']['site_name'], "朝日シティパリオ西巣鴨")) ){
//	debug($t1);
//	debug($a);
	//exit();
//}

		$j = 0;
		for($i=0; $i<count($a); $i++){
			if($a[$i] <> "")
				$b[$j++] = $this->Common->ConvTime( trim($a[$i]) );
		}
//if( ($this->data['Scheduley']['work_date'] == "2021-05-29") and ( strstr($this->data['Scheduley']['site_name'], "ヴァンベールA・B")) ){
//if( ($this->data['Scheduley']['work_date'] == "2021-05-07") and ( strstr($this->data['Scheduley']['site_name'], "朝日シティパリオ西巣鴨")) ){
//	debug($b);
//	debug($this->data['Scheduley']['work_date']);
//	debug($this->data['Scheduley']['site_name']);
//	exit();
//}
		return $b;
	}



	

	/* =================== 予定表(工事)詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'scheduley','action'=>'index'));
		}

		$this->set('main_title', '予定表(工事)');
		$this->set('sub_title', '予定表(工事)　＞　詳細');

		if($arg){
			$this->Scheduley->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Scheduley->id = $this->Common->getPost($this, 'Scheduley', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Scheduley->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
			$this->set('data2', $this->data2);
		}else{
		}
		$this->set('login_category', $user0['User']['category']);
	}
	
	/* =================== 予定表(工事)修正 ======================= */
	function edit($arg=""){
		$arg1="";
//debug($arg);
//debug($arg1);

		$user0 = $this->Auth->user();

		$this->set('main_title', '予定表(工事)');
		$this->set('sub_title', '予定表(工事)　＞　修正');

		if($arg)
			$this->Scheduley->id = $arg;
		else
			$this->Scheduley->id = $this->Common->getPost($this, 'Scheduley', 'id');
//exit();
		if(empty($this->data)){
			$this->data = $this->Scheduley->read();	//読み出し
//debug($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$button2 = $this->Common->getPost($this, 'Scheduley', 'button2');
			$deploy_name1 = $this->Common->getPost($this, 'Scheduley', 'deploy_name1');
			$deploy_name2 = $this->Common->getPost($this, 'Scheduley', 'deploy_name2');
			$deploy_name3 = $this->Common->getPost($this, 'Scheduley', 'deploy_name3');

//debug($button2);			
//debug($deploy_name3);			

			if( ($button2 == "選択値取得") and ($deploy_name1 <> "") ){
				$deploy_name = $this->ConvDeployName($deploy_name1.",".$deploy_name3);
//debug($deploy_name1);			
//debug($deploy_name);			
//exit();
			}else{
				$this->data['Scheduley']['work_interval'] = "";
//debug($this->data['Scheduley']);
				if(!$this->Scheduley->save($this->data)){		//更新
					$errors = $this->Scheduley->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'scheduley','action'=>'search'));
				}
			}
			$this->data = $this->Scheduley->read();	//読み出し
			if(isset($deploy_name))
				$this->data['Scheduley']['deploy_name'] = $deploy_name;
			$this->set('data', $this->data);
		}
		$this->set('login_category', $user0['User']['category']);
		$this->set('next_site_time1', $this->GetNextSiteTime1($arg1, $this->data));
		$this->set('main_menu_no');
	}
	
	
	function ConvDeployName($deploy_names){
		$a = explode(",", $deploy_names);
		for($i=0; $i<count($a); $i++){
			$b = explode(" ", $a[$i]);
			if($i == 0){
				$e = $b[0];
				$f = $b[1];
			}else{
				$c[$i-1] = $b[0];
				$d[$i-1] = $b[1];
			}
		}
		
		$ret1 = $this->User->find('first', array('fields' => array('initial'), 'conditions' => array('name1' => $e, 'name2' => $f)));
//debug($ret1);
		$n[0] = $ret1['User']['initial'];
		if(count($a)==1)
			return $n[0];

		$ret = $this->User->find('all', array('fields' => array('initial'), 'conditions' => array('name1' => $c, 'name2' => $d)));
		for($i=0; $i<count($ret); $i++){
			$n[$i+1] = $ret[$i]['User']['initial'];
		}
		return implode("･", $n);
	}
	
	
	
	function GetNextSiteTime1($arg1, $data1){
		$data2 = $this->Scheduley->find('first', array('conditions' => array('id' => $arg1)));
//debug($data1);
//debug($data2);
//exit();
		if($data2['Scheduley']['work_date'] == $data1['Scheduley']['work_date']){
			if($data2['Scheduley']['work_group'] == $data1['Scheduley']['work_group']){
				return $data2['Scheduley']['site_time1'];
			}
		}
		return "";
	}

	/* =================== 予定表(工事)削除 ======================= */
	function delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] < 5){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Scheduley','action'=>'index'));
		}

		$this->set('main_title', '予定表(工事)');
		$this->set('sub_title', '予定表(工事)　＞　削除');

		if($arg)
			$this->Scheduley->id = $arg;
		else
			$this->Scheduley->id = $this->Common->getPost($this, 'Scheduley', 'id');

		if(empty($this->data)){
			$this->data = $this->Scheduley->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->Scheduley->delete($this->Scheduley->id)){		//削除
				$errors = $this->Scheduley->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'scheduley','action'=>'search'));
		}
		$this->set('login_category', $user0['User']['category']);
	}
	/* =================== 予定表(工事)新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();

		$this->set('main_title', '予定表(工事)');
		$this->set('sub_title', '予定表(工事)　＞　新規作成');

		if(empty($this->data)){
			$lastID = $this->Scheduley->getLastInsertID();
			if($lastID <= 0){
				$d = $this->Scheduley->find('first', array('fields' => array('Max(id) as max_id')));
				$lastID = $d[0]['max_id'];
			}
			$this->data = $this->Scheduley->find('first', array('conditions' => array('id' => $lastID)));

		}else{
			$button2 = $this->Common->getPost($this, 'Scheduley', 'button2');
			$deploy_name1 = $this->Common->getPost($this, 'Scheduley', 'deploy_name1');
			$deploy_name2 = $this->Common->getPost($this, 'Scheduley', 'deploy_name2');
			$deploy_name3 = $this->Common->getPost($this, 'Scheduley', 'deploy_name3');

//debug($button2);			
//debug($deploy_name3);			

			if( ($button2 == "選択値取得") and ($deploy_name1 <> "") ){
				$deploy_name = $this->ConvDeployName($deploy_name1.",".$deploy_name3);
//debug($deploy_name1);			
//debug($deploy_name);			
//exit();
				$lastID = $this->Scheduley->getLastInsertID();
				if($lastID <= 0){
					$d = $this->Scheduley->find('first', array('fields' => array('Max(id) as max_id')));
					$lastID = $d[0]['max_id'];
				}
				$this->data = $this->Scheduley->find('first', array('conditions' => array('id' => $lastID)));
				$this->data['Scheduley']['deploy_name'] = $deploy_name;
				
			}else{
				$this->data['Scheduley']['work_interval'] = "";
				$this->data['Scheduley']['id'] = null;
//debug($this->data['Scheduley']);
//exit();
				if(!$this->Scheduley->save($this->data)){		//新規作成
					$errors = $this->Scheduley->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'scheduley','action'=>'search'));

					$lastID = $this->Scheduley->getLastInsertID();
					if($lastID <= 0){
						$d = $this->Scheduley->find('first', array('fields' => array('Max(id) as max_id')));
						$lastID = $d[0]['max_id'];
					}
					$this->data = $this->Scheduley->find('first', array('conditions' => array('id' => $lastID)));
				}
			}
		}
		$this->set('data', $this->data);
		$this->set('login_category', $user0['User']['category']);
	}



	public function upload() {
		if(isset($_POST['submit'])) {
    		if(isset($_FILES['uploadFile']['name']) && $_FILES['uploadFile']['name'] != "") {
        		$allowedExtensions = array("xls","xlsx");
        		$ext = pathinfo($_FILES['uploadFile']['name'], PATHINFO_EXTENSION);
		
				if(in_array($ext, $allowedExtensions)) {
					// Uploaded file
               		
					$file = WWW_ROOT."files/scheduley/R/".$_FILES['uploadFile']['name'];
					
               		$isUploaded = copy($_FILES['uploadFile']['tmp_name'], $file);
			   		// check uploaded file
               		if($isUploaded) {
//debug($file);
//exit();
						$this->redirect(array('controller'=>'scheduley','action'=>'search'));
					}
	            	unlink($file);
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                } else {
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                }
        	} else {
            	echo '<span class="msg">Please upload excel sheet1.</span>';
				exit();
        	}
    	} else {
        	echo '<span class="msg">Please upload excel file2.</span>';
			exit();
    	}
	}

	private function xlsx_save_proc($up_file){
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once Classes."phpexcel/PHPExcel.php";
		/** IO Class */
		require_once Classes."phpexcel/PHPExcel/IOFactory.php";

		//Configure::write('debug', 2);  // debugコードを出す
		$sql = "TRUNCATE TABLE `scheduley`";
		$this->Scheduley->query($sql);

        //データの読み込み
        $readData = $this->Excel->readXls($up_file, 9);	
		// param string $filepath,  int $colCount (Optional),  int $rowCount (Optional),  mix $sheetIndex (Optional)
//debug($readData[0]['data']);
		$k = 0;
		$data = array();
		for($i=2; $i<=count($readData[0]['data']); $i++){
			$data['Scheduley'][] = array(
						'year' => $readData[0]['data'][$i][0],
						'month' => $readData[0]['data'][$i][1],
						'day' => $readData[0]['data'][$i][2],
						'from_time' => $this->Excel->num2time( $readData[0]['data'][$i][3] ),
						'to_time' => $this->Excel->num2time( $readData[0]['data'][$i][4] ),
						'title' => $readData[0]['data'][$i][5],
						'member' => $readData[0]['data'][$i][6],
						'mail' => $readData[0]['data'][$i][7],
						'place' => $readData[0]['data'][$i][8],
						'message' => $readData[0]['data'][$i][9]
						);
			
			$k++;
		}
//debug($data);
		if(!$this->Scheduley->saveAll($data['Scheduley'], array('atomic' => false))){		//更新
			$errors = $this->Scheduley->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
		}else{
			if($this->Scheduley->find('count') > 0){
				$this->set('error_message', "ファイル・アップロードに成功しました。");
			}else{
				$this->set('error_message', "ファイル・アップロードに失敗しました。");
debug($this->Scheduley->getAffectedRows());
			}

		}

	}

	private function csv_save_proc($up_file){
		$sql = "TRUNCATE TABLE `scheduley`";
//		$this->Scheduley->query($sql);

		$handle = @fopen($up_file, "r");
		if ($handle) {
			$line = "";
		    while (!feof($handle)) {
		        $buf = fgets($handle, 4096);
//echo "buf=[".$buf."]<hr>";
				$last = substr($buf, -3);
//echo "last=[".$last."]<hr>";
//echo "last=[".bin2hex($last)."]<hr>";
				if(($last == "\x22\x0d\x0a") || ($last == "\x22\x0a")){
					$line .= "\x22";
//echo $line."<hr>";
		//			$this->Common->save_csv_line($this->Scheduley, $line);
					$line = "";
				}else
					$line .= $buf;
		    }
		    fclose($handle);
			$this->set('error_message', "ファイル・アップロードに成功しました。");
		}
	}




}