<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/Schedule/

class ScheduleController extends AppController {
	public $name = 'Schedule';
	public $uses = array('User', 'Schedule', 'Logs');
	public $layout = 'dafault';

	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'
	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;
	private $debug = false;

    function beforeFilter() {
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

		$this->set('main_title', "点検予定表");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Schedule
		$this->set('URL_SELF', $this->URL_SELF);

		//$username = $this->Auth->user('username');
		//$this->set('username', $username);
		
		//$username = $this->User->field('User', array('username' => $username));
		//$this->set('username', $username);
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/Schedule_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'schedule','action'=>'search'));
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "点検予定表",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "点検予定表";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}



	/* =================== 　点検予定表検索　 ======================= */
	public function search() {
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'schedule','action'=>'index'));
		}
		$this->set('main_title', '点検予定表');
		$this->set('sub_title', '検索');

//****		//$this->MakeWorkIntervalTime();

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Schedule', 'search');
		$id = $this->Common->getPost($this, 'Schedule', 'id');

		$work_date = $this->Common->getPost($this, 'Schedule', 'work_date');

		$work_date1 = $this->Common->getPost($this, 'Schedule', 'work_date1');
		$work_date2 = $this->Common->getPost($this, 'Schedule', 'work_date2');
		if(!$work_date1){
			$a = $this->Common->GetModelAll("Schedule", "work_date");
			if(count($a) > 0)
				$work_date1 = $a[0];
			$this->set('work_date1', 	$work_date1);
		}
//debug($work_date1);

		if(!$work_date2){
			$a = $this->Common->GetModelAll("Schedule", "work_date");
			if(count($a) > 0)
				$work_date2 = $a[count($a)-1];
			$this->set('work_date2', 	$work_date2);
		}
//debug($work_date2);

		$work_group = $this->Common->getPost($this, 'Schedule', 'work_group');

		$site_name = $this->Common->getPost($this, 'Schedule', 'site_name');
		$site_color = $this->Common->getPost($this, 'Schedule', 'site_color');
		$site_time1 = $this->Common->getPost($this, 'Schedule', 'site_time1');
		$site_time2 = $this->Common->getPost($this, 'Schedule', 'site_time2');
		$car_no = $this->Common->getPost($this, 'Schedule', 'car_no');

		$deploy_name = $this->Common->getPost($this, 'Schedule', 'deploy_name');

		$note = $this->Common->getPost($this, 'Schedule', 'note');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Schedule', 'page');
		$direction = $this->Common->getPost($this, 'Schedule', 'direction');
		$sort = $this->Common->getPost($this, 'Schedule', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($work_date)
			$condition = array_merge_recursive($condition, array( "work_date like" => '%'.$work_date.'%'));
		if(($work_date1) and ($work_date2))
			$condition = array_merge_recursive($condition, array( 'work_date BETWEEN ? AND ?' => array($work_date1, $work_date2)));

		if($work_group)
			$condition = array_merge_recursive($condition, array( "work_group like" => $work_group));
		if($deploy_name)
			$condition = array_merge_recursive($condition, array( "deploy_name like" => '%'.$deploy_name.'%'));
		if($site_name)
			$condition = array_merge_recursive($condition, array( "site_name like" => '%'.$site_name.'%'));
		if($site_color)
			$condition = array_merge_recursive($condition, array( "site_color like" => '%'.$site_color.'%'));

		if($site_time1)
			$condition = array_merge_recursive($condition, array( "site_time1 like" => $site_time1));
		if($site_time2)
			$condition = array_merge_recursive($condition, array( "site_time2 like" => $site_time2));
		if($car_no)
			$condition = array_merge_recursive($condition, array( "car_no like" => '%'.$car_no.'%'));
		if($note)
			$condition = array_merge_recursive($condition, array( "note like" => '%'.$note).'%');


		$this->set('condition', $condition);
//debug($condition);
		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "work_date" => urlencode($work_date),
				     "work_date1" => urlencode($work_date1),
				     "work_date2" => urlencode($work_date2),
				     "work_group" => urlencode($work_group),
				     "deploy_name" => urlencode($deploy_name),
				     "site_name" => urlencode($site_name),
				     "site_color" => urlencode($site_color),
				     "site_time1" => urlencode($site_time1),
				     "site_time2" => urlencode($site_time2),
				     "car_no" => urlencode($car_no),
				     "note" => urlencode($note),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Schedule' => array('conditions' => $condition, 'limit'=>100, 
				'order'=>['work_date'=>'asc', 'deploy_name'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc']
				));		//'sort2'=>$sort, 'direction'=>$direction
		$this->data = $this->paginate('Schedule');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);
		$this->set('ExportDateY', date("Y"));
		$this->set('ExportDateM', date("m"));

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			//if(!$search)
			//	$this->redirect(array('controller'=>'schedule','action'=>'search', 'page:1/direction:asc/sort2:work_date'));
		}
//debug($sort);
	}

	function search_update(){
		$this->MakeWorkIntervalTime();
		$this->redirect(array('controller'=>'schedule','action'=>'search'));
	}

	function MakeWorkIntervalTime(){
		//$data = $this->Schedule->find('all', array('order' => ['work_date'=>'asc', 'deploy_name'=>'desc', "CAST( DATE_FORMAT(site_time1, '%H%i') AS UNSIGNED)" =>'desc'] ));
		$data = $this->Schedule->find('all', array('order' => ['work_date'=>'asc', 'deploy_name'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc'] ));
			 //'fields' => array('site_time1', "CAST(replace(site_time1, ':', '') AS UNSIGNED) as time"),
//debug($this->Schedule->getDataSource()->getLog(false, false));
//debug($data);
//exit();
		$work_group = 1;
		for($i=0; $i<count($data); $i++){
			$site_time1 = $data[$i]['Schedule']['site_time1'];
			$site_time2 = $data[$i]['Schedule']['site_time2'];
			
			$n1 = strtotime($site_time1);
			$n2 = strtotime($site_time2);
			$h = $n2 - $n1;
			if($h > 0){
				$h += strtotime('2012/01/01');
				$work_time = date("H:i", $h);
			}else{
			  	$work_time = "?";
			}
			$this->Schedule->set('id', $data[$i]['Schedule']['id']);
			$this->Schedule->saveField('work_time', $work_time);

			$work_interval = "";
			if(isset($data[$i+1]['Schedule']['work_date'])){
				if( ($data[$i+1]['Schedule']['work_date'] == $data[$i]['Schedule']['work_date'])
					and ($data[$i+1]['Schedule']['deploy_name'] == $data[$i]['Schedule']['deploy_name']) ){
			
					$next_site_time1 = $data[$i+1]['Schedule']['site_time1'];
			
					if($next_site_time1 <> ""){
						$n1 = strtotime($site_time2);
						$n2 = strtotime($next_site_time1);		//strtotime($data['Schedule']['site_time1']);
						$h = $n2 - $n1;

//debug($i);
//debug($h);
//debug($site_time2);
//debug($n1);
//debug($next_site_time1);
//debug($n2);

						if($h >= 0){
							$h += strtotime('2012/01/01');
							$work_interval = date("H:i", $h);
						}else{
					  		$work_interval  = "?";
//debug($data[$i]['Schedule']['work_date']);
//debug($site_time2);
//debug($next_site_time1);
//exit();
						}
					}
				}
			}

			if(isset($data[$i-1]['Schedule']['work_date'])){
				if($data[$i-1]['Schedule']['work_date'] != $data[$i]['Schedule']['work_date']){
					$work_group = 1;
				}elseif( ($data[$i-1]['Schedule']['work_date'] == $data[$i]['Schedule']['work_date'])
					and ($data[$i-1]['Schedule']['deploy_name'] != $data[$i]['Schedule']['deploy_name']) ){
					$work_group += 1;
				}
			}else{
				$work_group = 1;
			}
			$this->Schedule->set('id', $data[$i]['Schedule']['id']);
			$this->Schedule->saveField('work_interval', $work_interval);
			$this->Schedule->saveField('work_group', $work_group);
		}//end for
		
		$SqlStr = "SET @n := 0";
		$ret = $this->Schedule->query($SqlStr);
		$SqlStr = "UPDATE schedule SET id = (@n := @n +1)";
		$ret = $this->Schedule->query($SqlStr);
		//$this->DispTable($data);
	
	}
	
	function search_export(){
		$year = $this->Common->getPost($this, 'Schedule', 'ExportDateY');
		if($year == "")
			$year = "2021";
		// 月を指定
		$month = $this->Common->getPost($this, 'Schedule', 'ExportDateM');
		if($month == "")
			$month = '04';
		$first_date = date('Y-m-d', strtotime('first day of ' . $year."-".$month));
//debug($first_date);
		$week_num = date("w", strtotime($first_date));
//debug($week_num);
		if ($week_num == 0){
			//日曜日だった場合
  			$monday1 = date('Y/m/d', strtotime("-6 day", strtotime($first_date)));
		}else{
  			$monday1 = date('Y/m/d', strtotime("-{$week_num} day", strtotime($first_date) + 24*60*60));
		}
//debug($monday1);
//exit();
		$last_date = date('Y-m-d', strtotime('last day of ' . $year."-".$month));
//debug("指定月の初日：" . $first_date);
//debug("指定月の末日：" . $last_date);

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		//$xcellFile = $_SERVER['DOCUMENT_ROOT']."/inabou/app/webroot/files/schedule/ORG/schedule.xlsx";
		$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/schedule/ORG/schedule.xlsx");
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/schedule/".date("YmdHis")."schedule.xlsx");
		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/schedule/20210512_schedule.xlsx");
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);

		/** PHPExcelを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		// PHPExcelオブジェクトを生成する
		$obj = PHPExcel_IOFactory::createReader("Excel2007");
		$book = $obj->load($xcellFile);

		//$data = $this->Schedule->find('all', array('condition'=>array( 'work_date BETWEEN ? AND ?' => array($first_date, $last_date)), 
		//			'order' => ['work_date'=>'asc', 'deploy_name'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc'] ));
		
		$sql = "SELECT * FROM `schedule2` WHERE `work_date` BETWEEN '".$first_date."' and '".$last_date."' ORDER BY `work_date` asc, `deploy_name` asc, CAST(replace(site_time1, ':', '') AS UNSIGNED) asc, `id` asc ";
		$data = $this->Schedule->query($sql);

//$log = $this->Schedule->getDataSource()->getLog(false, false);       
//debug($log);
		$data_count = count($data);
//debug($data_count);
//debug($data);
//exit();
		$a = ["A2", "A18", "A34", "G2", "G18", "G34", "G50"]; //'日にちの配列
		$b = ["A12", "A28", "A44", "G12", "G28", "G44", "G54"]; //'曜日にちの配列
		$c = ["月", "火", "水", "木", "金", "土", "日"]; //'日にちの配列

		for($sh=0; $sh<5; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<count($a); $i++){
				// セルに値をセットする
				if($i == 0)
					$sheet->setCellValue($a[$i], date("n/d", strtotime($monday1)));
				else
					$sheet->setCellValue($a[$i], date("n/d", strtotime("+{$i} day", strtotime($monday1))));
				$sheet->setCellValue($b[$i], $c[$i]);
			}
			$monday1 = date('Y/m/d', strtotime( "+{$i} day", strtotime($monday1) ));
			//-----------------------------------------------
		}//endfor
		
		
        $rows = [2, 18, 34, 2, 18, 34, 50, 56];
        $cols = [2,  2,  2, 8,  8,  8, 8];
		
		$n = 0;
		$old_deploy_name = "";
		for($sh=0; $sh<5; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<count($a); $i++){
				$work_date1 = $year."/".$sheet->getCell( $a[$i] )->getValue();
				for($j=0; $j<16; ){		//1日分の行数
					//$data[$n]['Schedule'] = $data[$n]['schedule2'];
					if(isset($data[$n]['Schedule']['work_date']) == false){
//debug($data);
//exit();
						break;
					}
					$work_date2 = $data[$n]['Schedule']['work_date'];
//debug($work_date1);
//debug($work_date2);
					if(strtotime($work_date1) == strtotime($work_date2)){
						if($data[$n]['Schedule']['deploy_name'] != $old_deploy_name){
						// セルに値をセットする
//debug(($cols[$i] -1)."･".($rows[$i] + $j));
//debug($data[$n]['Schedule']['site_name']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $data[$n]['Schedule']['site_name']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] , $rows[$i] + $j, $data[$n]['Schedule']['car_no']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] +1, $rows[$i] + $j, $data[$n]['Schedule']['deploy_name']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] +2, $rows[$i] + $j, $data[$n]['Schedule']['note']);

							$j++;
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $data[$n]['Schedule']['site_time1']."-".$data[$n]['Schedule']['site_time2']);
							$j++;
							$old_deploy_name = $data[$n]['Schedule']['deploy_name'];
//exit();
						}else{
							$j -= 2;
//debug(($cols[$i] -1)."･".($rows[$i] + $j));
							$site_name1 = $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue();
//debug($site_name1);
//debug($data[$n]['Schedule']['site_name']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $site_name1.",".$data[$n]['Schedule']['site_name']);

							$j++;
							$site_time =  $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue();
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $site_time.",".$data[$n]['Schedule']['site_time1']."-".$data[$n]['Schedule']['site_time2']);
							$j++;
						}
						$n++;
					}else{
						break;
					}
					if($n >= $data_count) break;
				}	//end og for $j
				if($i == 8){
					debug("ループ・エラー". $i);
					exit();
				}
				if($n >= $data_count) break;
			}// end of for $i
			//-----------------------------------------------
			if($n >= $data_count) break;
		}//endfor $sh
		// Excel2007形式で保存する
		$writer = PHPExcel_IOFactory::createWriter($book, "Excel2007");
		$writer->save($xcellFile);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = "20210512_schedule.xlsx";
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		exit();
	
		$this->redirect(array('controller'=>'schedule','action'=>'search'));
	}
	
	
	
	
	
	function DispTable($list){
		//		https://teratail.com/questions/73006

		$header = ["id"=>"id","work_date"=>"作業日","work_group"=>"グループ","deploy_num"=>"配置No",  "deploy_name"=>"配置名",
			"site_name"=>"現場名", "site_color"=>"現場色", "site_time1"=>"現場時間1", "site_time2"=>"現場時間2",
			"work_time"=>"作業時間", "work_interval"=>"作業間隔",
			"car_no"=>"車No", "note"=>"備考"];

		$str="";
		$str.="<table>\n";
		$str.="<thead>\n";
		if(is_array($header)){
  			$str.="<tr>\n";
  			foreach($header as $val){$str.="<td>".htmlspecialchars($val)."</td>\n";}
  				$str.="</tr>\n";
		}
		$str.="</thead>\n";
		$str.="<tbody>\n";
		if(is_array($list)){
  			foreach($list as $row){
    			$str.="<tr>\n";
//print_r($row);
    			foreach($row['Schedule'] as $val){
      				$str.="<td>".htmlspecialchars($val)."</td>\n";
    			}
    			$str.="</tr>\n";
  			}
		}
		$str.="</tbody>\n";
		$str.="</table>\n";
		print $str;
exit();
	
	}
	
	

	/* =================== 点検予定表詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'schedule','action'=>'index'));
		}

		$this->set('main_title', '点検予定表');
		$this->set('sub_title', '点検予定表　＞　詳細');
		$this->set('sub_title2', '見積書　＞　詳細');

		if($arg){
			$this->Schedule->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Schedule->id = $this->Common->getPost($this, 'Schedule', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Schedule->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
			$this->set('data2', $this->data2);
		}else{
		}
		$this->set('login_category', $user0['User']['category']);
	}
	
	/* =================== 点検予定表修正 ======================= */
	function edit($arg=""){
		$arg1="";
//debug($arg);
//debug($arg1);

		$user0 = $this->Auth->user();

		$this->set('main_title', '点検予定表');
		$this->set('sub_title', '点検予定表　＞　修正');

		if($arg)
			$this->Schedule->id = $arg;
		else
			$this->Schedule->id = $this->Common->getPost($this, 'Schedule', 'id');
//exit();
		if(empty($this->data)){
			$this->data = $this->Schedule->read();	//読み出し
//debug($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$button2 = $this->Common->getPost($this, 'Schedule', 'button2');
			$deploy_name1 = $this->Common->getPost($this, 'Schedule', 'deploy_name1');
			$deploy_name2 = $this->Common->getPost($this, 'Schedule', 'deploy_name2');
			$deploy_name3 = $this->Common->getPost($this, 'Schedule', 'deploy_name3');

//debug($button2);			
//debug($deploy_name3);			

			if( ($button2 == "選択値取得") and ($deploy_name1 <> "") ){
				$deploy_name = $this->ConvDeployName($deploy_name1.",".$deploy_name3);
//debug($deploy_name1);			
//debug($deploy_name);			
//exit();
			}else{
				$this->data['Schedule']['work_interval'] = "";
//debug($this->data['Schedule']);
				if(!$this->Schedule->save($this->data)){		//更新
					$errors = $this->Schedule->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'schedule','action'=>'search'));
				}
			}
			$this->data = $this->Schedule->read();	//読み出し
			if(isset($deploy_name))
				$this->data['Schedule']['deploy_name'] = $deploy_name;
			$this->set('data', $this->data);
		}
		$this->set('login_category', $user0['User']['category']);
		$this->set('next_site_time1', $this->GetNextSiteTime1($arg1, $this->data));
		$this->set('main_menu_no');
	}
	
	
	function ConvDeployName($deploy_names){
		$a = explode(",", $deploy_names);
		for($i=0; $i<count($a); $i++){
			$b = explode(" ", $a[$i]);
			if($i == 0){
				$e = $b[0];
				$f = $b[1];
			}else{
				$c[$i-1] = $b[0];
				$d[$i-1] = $b[1];
			}
		}
		
		$ret1 = $this->User->find('first', array('fields' => array('initial'), 'conditions' => array('name1' => $e, 'name2' => $f)));
//debug($ret1);
		$n[0] = $ret1['User']['initial'];
		if(count($a)==1)
			return $n[0];

		$ret = $this->User->find('all', array('fields' => array('initial'), 'conditions' => array('name1' => $c, 'name2' => $d)));
		for($i=0; $i<count($ret); $i++){
			$n[$i+1] = $ret[$i]['User']['initial'];
		}
		return implode("･", $n);
	}
	
	
	
	function GetNextSiteTime1($arg1, $data1){
		$data2 = $this->Schedule->find('first', array('conditions' => array('id' => $arg1)));
//debug($data1);
//debug($data2);
//exit();
		if($data2['Schedule']['work_date'] == $data1['Schedule']['work_date']){
			if($data2['Schedule']['work_group'] == $data1['Schedule']['work_group']){
				return $data2['Schedule']['site_time1'];
			}
		}
		return "";
	}

	/* =================== 点検予定表削除 ======================= */
	function delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] < 5){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Schedule','action'=>'index'));
		}

		$this->set('main_title', '点検予定表');
		$this->set('sub_title', '点検予定表　＞　削除');

		if($arg)
			$this->Schedule->id = $arg;
		else
			$this->Schedule->id = $this->Common->getPost($this, 'Schedule', 'id');

		if(empty($this->data)){
			$this->data = $this->Schedule->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->Schedule->delete($this->Schedule->id)){		//削除
				$errors = $this->Schedule->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'schedule','action'=>'search'));
		}
		$this->set('login_category', $user0['User']['category']);
	}
	/* =================== 点検予定表新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();

		$this->set('main_title', '点検情報');
		$this->set('sub_title', '予定表　＞　新規作成');

		if(empty($this->data)){
			$lastID = $this->Schedule->getLastInsertID();
			if($lastID <= 0){
				$d = $this->Schedule->find('first', array('fields' => array('Max(id) as max_id')));
				$lastID = $d[0]['max_id'];
			}
			$this->data = $this->Schedule->find('first', array('conditions' => array('id' => $lastID)));

		}else{
			$button2 = $this->Common->getPost($this, 'Schedule', 'button2');
			$deploy_name1 = $this->Common->getPost($this, 'Schedule', 'deploy_name1');
			$deploy_name2 = $this->Common->getPost($this, 'Schedule', 'deploy_name2');
			$deploy_name3 = $this->Common->getPost($this, 'Schedule', 'deploy_name3');

//debug($button2);			
//debug($deploy_name3);			

			if( ($button2 == "選択値取得") and ($deploy_name1 <> "") ){
				$deploy_name = $this->ConvDeployName($deploy_name1.",".$deploy_name3);
//debug($deploy_name1);			
//debug($deploy_name);			
//exit();
				$lastID = $this->Schedule->getLastInsertID();
				if($lastID <= 0){
					$d = $this->Schedule->find('first', array('fields' => array('Max(id) as max_id')));
					$lastID = $d[0]['max_id'];
				}
				$this->data = $this->Schedule->find('first', array('conditions' => array('id' => $lastID)));
				$this->data['Schedule']['deploy_name'] = $deploy_name;
				
			}else{
				$this->data['Schedule']['work_interval'] = "";
				$this->data['Schedule']['id'] = null;
//debug($this->data['Schedule']);
//exit();
				if(!$this->Schedule->save($this->data)){		//新規作成
					$errors = $this->Schedule->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'schedule','action'=>'search'));

					$lastID = $this->Schedule->getLastInsertID();
					if($lastID <= 0){
						$d = $this->Schedule->find('first', array('fields' => array('Max(id) as max_id')));
						$lastID = $d[0]['max_id'];
					}
					$this->data = $this->Schedule->find('first', array('conditions' => array('id' => $lastID)));
				}
			}
		}
		$this->set('data', $this->data);
		$this->set('login_category', $user0['User']['category']);
	}



	public function upload() {
		$this->set('main_title', "アップロード");
		$this->set('sub_title',  '');
		$file_name = $this->Common->upload_proc("upload", $this, $up_file);
//debug($up_file);
		if($file_name){
			if(strstr($file_name, ".xlsx")){
				//$this->csv_save_proc($up_file);
				$this->xlsx_save_proc($up_file);
				//$this->redirect(array('controller'=>'schedule','action'=>'search'));
			}else
				$this->set('error_message', "ファイルのアップロードに失敗しました。[".$this->data['Upload']['file_name']['name']."]");
		}
	}

	private function xlsx_save_proc($up_file){
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once Classes."phpexcel/PHPExcel.php";
		/** IO Class */
		require_once Classes."phpexcel/PHPExcel/IOFactory.php";

		//Configure::write('debug', 2);  // debugコードを出す
		$sql = "TRUNCATE TABLE `schedule`";
		$this->Schedule->query($sql);

        //データの読み込み
        $readData = $this->Excel->readXls($up_file, 9);	
		// param string $filepath,  int $colCount (Optional),  int $rowCount (Optional),  mix $sheetIndex (Optional)
//debug($readData[0]['data']);
		$k = 0;
		$data = array();
		for($i=2; $i<=count($readData[0]['data']); $i++){
			$data['Schedule'][] = array(
						'year' => $readData[0]['data'][$i][0],
						'month' => $readData[0]['data'][$i][1],
						'day' => $readData[0]['data'][$i][2],
						'from_time' => $this->Excel->num2time( $readData[0]['data'][$i][3] ),
						'to_time' => $this->Excel->num2time( $readData[0]['data'][$i][4] ),
						'title' => $readData[0]['data'][$i][5],
						'member' => $readData[0]['data'][$i][6],
						'mail' => $readData[0]['data'][$i][7],
						'place' => $readData[0]['data'][$i][8],
						'message' => $readData[0]['data'][$i][9]
						);
			
			$k++;
		}
//debug($data);
		if(!$this->Schedule->saveAll($data['Schedule'], array('atomic' => false))){		//更新
			$errors = $this->Schedule->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
		}else{
			if($this->Schedule->find('count') > 0){
				$this->set('error_message', "ファイル・アップロードに成功しました。");
			}else{
				$this->set('error_message', "ファイル・アップロードに失敗しました。");
debug($this->Schedule->getAffectedRows());
			}

		}

	}

	private function csv_save_proc($up_file){
		$sql = "TRUNCATE TABLE `schedule`";
//		$this->Schedule->query($sql);

		$handle = @fopen($up_file, "r");
		if ($handle) {
			$line = "";
		    while (!feof($handle)) {
		        $buf = fgets($handle, 4096);
//echo "buf=[".$buf."]<hr>";
				$last = substr($buf, -3);
//echo "last=[".$last."]<hr>";
//echo "last=[".bin2hex($last)."]<hr>";
				if(($last == "\x22\x0d\x0a") || ($last == "\x22\x0a")){
					$line .= "\x22";
//echo $line."<hr>";
		//			$this->Common->save_csv_line($this->Schedule, $line);
					$line = "";
				}else
					$line .= $buf;
		    }
		    fclose($handle);
			$this->set('error_message', "ファイル・アップロードに成功しました。");
		}
	}



}