<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/quotation/

class QuotationController extends AppController {
	public $name = 'Quotation';
	public $uses = array('User', 'Quotation', 'Logs');
	public $layout = 'dafault';

	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'
	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;
	private $debug = false;

    function beforeFilter() {
		//define("Classes", $_SERVER["DOCUMENT_ROOT"]."/cakephp/class/");
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");
		if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
		}

		$this->set('main_title', "スケジュール");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/quotation
		$this->set('URL_SELF', $this->URL_SELF);

		//$username = $this->Auth->user('username');
		//$this->set('username', $username);
		
		//$username = $this->User->field('User', array('username' => $username));
		//$this->set('username', $username);
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/quotation_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'quotation','action'=>'search'));
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "見積書",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "見積書";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}

	/* =================== 　アクセス・ログ検索　 ======================= */
	public function accesslogs($main_menu=""){
		$this->set('main_menu', $main_menu);
	
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Logs','action'=>'index'));
		}
		$this->set('main_title', 'アクセス・ログ');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Logs', 'search');
		$id = $this->Common->getPost($this, 'Logs', 'id');
		$contents = $this->Common->getPost($this, 'Logs', 'contents');
		$username = $this->Common->getPost($this, 'Logs', 'username');
		$name1 = $this->Common->getPost($this, 'Logs', 'name1');
		$name2 = $this->Common->getPost($this, 'Logs', 'name2');
		$ip_address = $this->Common->getPost($this, 'Logs', 'ip_address');
		$accessed = $this->Common->getPost($this, 'Logs', 'accessed');
		$accessedY = $this->Common->getPost($this, 'Logs', 'accessedY');
		$accessedM = $this->Common->getPost($this, 'Logs', 'accessedM');
		$accessedD = $this->Common->getPost($this, 'Logs', 'accessedD');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Logs', 'page');
		$direction = $this->Common->getPost($this, 'Logs', 'direction');
		$sort = $this->Common->getPost($this, 'Logs', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($contents)
			//$condition = array_merge_recursive($condition, array( "contents like" => '%'.mb_convert_encoding($username, "UTF-8", "SJIS").'%'));
			$condition = array_merge_recursive($condition, array( "contents like" => '%'.$contents.'%'));
		if($username)
			$condition = array_merge_recursive($condition, array( "username like" => '%'.$username.'%'));
		if($name1)
			$condition = array_merge_recursive($condition, array( "name1 like" => '%'.$name1.'%'));
		if($name2)
			$condition = array_merge_recursive($condition, array( "name2 like" => '%'.$name2.'%'));
		if($ip_address)
			$condition = array_merge_recursive($condition, array( "ip_address like" => '%'.$ip_address.'%'));

		if($accessed){
			//$condition = array_merge_recursive($condition, array( "accessed" => $accessed ));
			$date1 = $accessed.' 00:00:00';
			$date2 = $accessed.' 23:59:59';
			$condition = array_merge_recursive($condition, array('accessed BETWEEN ? AND ?' => array($date1, $date2)));
		}

		if($accessedY and !$accessedM and !$accessed){
			$date1 = $accessedY.'-01-01 00:00:00';
			$date2 = $accessedY.'-12-31 23:59:59';
			$condition = array_merge_recursive($condition, array('accessed BETWEEN ? AND ?' => array($date1, $date2)));
		}
		if($accessedY and $accessedM and !$accessedD){
			$month = $accessedY."-".$accessedM;
			$date1 = date('Y-m-d', strtotime('first day of ' . $month)).' 00:00:00';
			$date2 = date('Y-m-d', strtotime( 'last day of ' . $month)).' 23:59:59';
//debug($date1);
//debug($date2);
			//$condition = array_merge_recursive($condition, array('accessed BETWEEN ? AND ?' => array($date1, $date2)));
			$condition = array_merge_recursive($condition, array('accessed >=' => $date1, 'accessed <=' => $date2));
		}

		if($accessedY and $accessedM  and $accessedD){
			$date1 = $accessedY."-".$accessedM."-".$accessedD.' 00:00:00';
			$date2 = $accessedY."-".$accessedM."-".$accessedD.' 23:59:59';
//debug($date1);
//debug($date2);
			//$condition = array_merge_recursive($condition, array('accessed BETWEEN ? AND ?' => array($date1, $date2)));
			$condition = array_merge_recursive($condition, array( 'accessed >=' => $date1, 'accessed <=' => $date2 ));
//debug($accessedY."-".$accessedM."-".$accessedD);
		}


		$this->set('condition', $condition);

		// 検索単語に基づき引数作成 
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "contents" => urlencode($contents),
				     "username" => urlencode($username),
				     "name1" => urlencode($name1),
				     "name2" => urlencode($name2),
				     "ip_address" => urlencode($ip_address),
				     "accessed" => urlencode($accessed),
				     "accessedY" => urlencode($accessedY),
				     "accessedM" => urlencode($accessedM),
				     "accessedD" => urlencode($accessedD),
		);
		// ページネーションの作成 
		$this->paginate = array('Logs' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Logs');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'quotation','action'=>'accesslogs', 'page:1/direction:asc/sort:id'));
		}

	}



	/* =================== 　見積書検索　 ======================= */
	public function search($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'quotation','action'=>'index'));
		}
		$this->set('main_title', '見積書');
		$this->set('sub_title', '検索');

		$cmd = $this->Common->getPost($this, 'Quotation', 'cmd');
		if($cmd == "クリア")
			$this->redirect(array('controller'=>'quotation','action'=>'index'));

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Quotation', 'search');
		
		$id = $this->Common->getPost($this, 'Quotation', 'id');	//	日付
		$estimate_date = $this->Common->getPost($this, 'Quotation', 'estimate_date');	//	日付

		$estimate_dateY = $this->Common->getPost($this, 'Quotation', 'estimate_dateY');	//	日付
		$estimate_dateM = $this->Common->getPost($this, 'Quotation', 'estimate_dateM');	//	日付
		$estimate_dateD = $this->Common->getPost($this, 'Quotation', 'estimate_dateD');	//	日付

		$responsible = $this->Common->getPost($this, 'Quotation', 'responsible');	//	担当者
		$dest_up = $this->Common->getPost($this, 'Quotation', 'dest_up');	//	送付先up

		$tax_rate = $this->Common->getPost($this, 'Quotation', 'tax_rate');	//	消費税率
		$remark = $this->Common->getPost($this, 'Quotation', 'remark');	//	備考拡張選択
		$class = $this->Common->getPost($this, 'Quotation', 'class');	//	送付先up

		$estimate_no = $this->Common->getPost($this, 'Quotation', 'estimate_no');	//	ｎ見積番号
		$creator = $this->Common->getPost($this, 'Quotation', 'creator');	//	作成者名
		$ext_recharge = $this->Common->getPost($this, 'Quotation', 'ext_recharge');	//	拡張再請求
		$tax_flag = $this->Common->getPost($this, 'Quotation', 'tax_flag');	//	消費税有無
		$remark_ext = $this->Common->getPost($this, 'Quotation', 'remark_ext');	//	備考拡張sec
		$invoice_no = $this->Common->getPost($this, 'Quotation', 'invoice_no');	//	ｎ請求番号
		$subject_up = $this->Common->getPost($this, 'Quotation', 'subject_up');	//	件名up
		$dest_low = $this->Common->getPost($this, 'Quotation', 'dest_low');	//	送付先low
		$subject_mid = $this->Common->getPost($this, 'Quotation', 'subject_mid');	//	件名mid
		$subject_low = $this->Common->getPost($this, 'Quotation', 'subject_low');	//	件名low
		$address = $this->Common->getPost($this, 'Quotation', 'address');	//	宛名
		$product_name = $this->Common->getPost($this, 'Quotation', 'product_name');	//	製品名
		$quantity = $this->Common->getPost($this, 'Quotation', 'quantity');	//	数量
		$qty_assist = $this->Common->getPost($this, 'Quotation', 'qty_assist');	//	数量補助
		$price = $this->Common->getPost($this, 'Quotation', 'price');	//	価格
		$amount_line = $this->Common->getPost($this, 'Quotation', 'amount_line');	//	ライン毎金額
		$remark = $this->Common->getPost($this, 'Quotation', 'remark');	//	備考
		$subtotal = $this->Common->getPost($this, 'Quotation', 'subtotal');	//	金額小計
		$labor_cost = $this->Common->getPost($this, 'Quotation', 'labor_cost');	//	労務費
		$choice = $this->Common->getPost($this, 'Quotation', 'choice');	//	セレクト
		$tax_adj = $this->Common->getPost($this, 'Quotation', 'tax_adj');	//	消費税調整
		$tax_calc_frame = $this->Common->getPost($this, 'Quotation', 'tax_calc_frame');	//	消費税計算枠
		$other_expense = $this->Common->getPost($this, 'Quotation', 'other_expense');	//	諸経費
		$subtotal_adj = $this->Common->getPost($this, 'Quotation', 'subtotal_adj');	//	小計調整
		$total_amount = $this->Common->getPost($this, 'Quotation', 'total_amount');	//	金額合計
		$discount = $this->Common->getPost($this, 'Quotation', 'discount');	//	値引額
		$max_estimated = $this->Common->getPost($this, 'Quotation', 'max_estimated');	//	見積最大値
		$max_invoice = $this->Common->getPost($this, 'Quotation', 'max_invoice');	//	請求最大値

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Quotation', 'page');
		$direction = $this->Common->getPost($this, 'Quotation', 'direction');
		$sort = $this->Common->getPost($this, 'Quotation', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($estimate_date)
			$condition = array_merge_recursive($condition, array( "estimate_date" => $estimate_date));

		if($estimate_dateY and !$estimate_dateM and !$estimate_dateD)
			$condition = array_merge_recursive($condition, array('estimate_date BETWEEN ? AND ?' => array($estimate_dateY.'-01-01', $estimate_dateY.'-12-31')));

		if($estimate_dateY and $estimate_dateM and !$estimate_dateD){
			$month = $estimate_dateY."-".$estimate_dateM;
			$firstDate = date('Y-m-d', strtotime('first day of ' . $month));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $month));
			$condition = array_merge_recursive($condition, array('estimate_date >=' => $firstDate, 'estimate_date <=' => $lastDate));
		}

		if($estimate_dateY and $estimate_dateM  and $estimate_dateD){
			$condition = array_merge_recursive($condition, array('estimate_date' => $estimate_dateY."-".$estimate_dateM."-".$estimate_dateD ));
//debug($estimate_dateY."-".$estimate_dateM."-".$estimate_dateD);
		}

		if($responsible)
			$condition = array_merge_recursive($condition, array( "responsible like" => $responsible));
		if($dest_up)	//	送付先low
			$condition = array_merge_recursive($condition, array( "dest_low like" => $dest_up));
		if($class)	//	送付先low
			$condition = array_merge_recursive($condition, array( "dest_low like" => $class));

		if($estimate_no)	//	ｎ見積番号
			$condition = array_merge_recursive($condition, array( "estimate_no" => $estimate_no));
		if($subject_up)	//	件名up
			$condition = array_merge_recursive($condition, array( "subject_up" => $subject_up));
		if($dest_low)	//	送付先low
			$condition = array_merge_recursive($condition, array( "dest_low like" => $dest_low));
		if($subject_mid)	//	件名mid
			$condition = array_merge_recursive($condition, array( "subject_mid" => $subject_mid));
		if($subject_low)	//	件名low
			$condition = array_merge_recursive($condition, array( "subject_low like" => $subject_low));
		if($product_name)	//	製品名
			$condition = array_merge_recursive($condition, array( "product_name like" => $product_name));

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "estimate_date" => urlencode($estimate_date),

				     "estimate_dateY" => urlencode($estimate_dateY),
				     "estimate_dateM" => urlencode($estimate_dateM),
				     "estimate_dateD" => urlencode($estimate_dateD),

				     "responsible" => urlencode($responsible),
				     "dest_up" => urlencode($dest_up),
				     "class" => urlencode($class),
				     "estimate_no" => urlencode($estimate_no),
				     "subject_up" => urlencode($subject_up),
				     "dest_low" => urlencode($dest_low),
				     "subject_mid" => urlencode($subject_mid),
				     "subject_low" => urlencode($subject_low),
				     "product_name" => urlencode($product_name),

		);
		/* ページネーションの作成 */
		$this->paginate = array('Quotation' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Quotation');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'quotation','action'=>'search', 'page:1/direction:asc/sort:id'));
		}
	}

	/* =================== 見積書詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'quotation','action'=>'index'));
		}

		$this->set('main_title', '見積書');
		$this->set('sub_title', '詳細');

		if($arg)
			$this->Quotation->id = $arg;
		else
			$this->Quotation->id = $this->Common->getPost($this, 'Quotation', 'id');

		if(empty($this->data)){
			$this->data = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->Quotation->find('count', array('conditions' => array('category LIKE' => $this->data['Quotation']['category'],
																		'id !=' => $this->Quotation->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'Quotation', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			//if(false){
				if(!$this->Quotation->save($this->data)){		//更新
					$errors = $this->Quotation->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'quotation','action'=>'search'));
				}
			//}
		}
		$this->set('category', $user0['User']['category']);
	}

	/* =================== ログイン管理修正 ======================= */
	function search_edit($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'quotation','action'=>'index'));
		}

		$this->set('main_title', '見積書情報');
		$this->set('sub_title', '見積書　＞　編集');

		if($arg)
			$this->Quotation->id = $arg;
		else
			$this->Quotation->id = $this->Common->getPost($this, 'Quotation', 'id');

		if(empty($this->data)){
			$this->data = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
//echo $this->Common->getPost($this, 'Quotation', 'password')."<br>";
//print_r($this->data);
			for($i=0; $i<12; $i++){
				$a[$i] = $this->data['Quotation']['product_name'][$i];
				$b[$i] = str_replace(',','',$this->data['Quotation']['quantity'][$i]);
				$c[$i] = $this->data['Quotation']['qty_assist'][$i];
				$d[$i] = str_replace(',','',$this->data['Quotation']['price'][$i]);
				$e[$i] = str_replace(',','',$this->data['Quotation']['amount_line'][$i]);
				$f[$i] = $this->data['Quotation']['remark'][$i];
			}
			$this->data['Quotation']['product_name'] = [];
			$this->data['Quotation']['quantity'] = [];
			$this->data['Quotation']['qty_assist'] = [];
			$this->data['Quotation']['price'] = [];
			$this->data['Quotation']['amount_line'] = [];
			$this->data['Quotation']['remark'] = [];

			$this->data['Quotation']['product_name'] = implode("/", $a);
			$this->data['Quotation']['quantity'] = implode("/", $b);
			$this->data['Quotation']['qty_assist'] = implode("/", $c);
			$this->data['Quotation']['price'] = implode("/", $d);
			$this->data['Quotation']['amount_line'] = implode("/", $e);
			$this->data['Quotation']['remark'] = implode("/", $f);
			
			$this->data['Quotation']['labor_cost'] = str_replace(',','', $this->data['Quotation']['labor_cost']);
			$this->data['Quotation']['subtotal'] = str_replace(',','', $this->data['Quotation']['subtotal']);
			$this->data['Quotation']['other_expense'] = str_replace(',','', $this->data['Quotation']['other_expense']);
			$this->data['Quotation']['tax_calc_frame'] = str_replace(',','', $this->data['Quotation']['tax_calc_frame']);
			$this->data['Quotation']['discount'] = str_replace(',','', $this->data['Quotation']['discount']);
			$this->data['Quotation']['total_amount'] = str_replace(',','', $this->data['Quotation']['total_amount']);
			$this->data['Quotation']['tax_adj'] = str_replace(',','', $this->data['Quotation']['tax_adj']);
			$this->data['Quotation']['subtotal_adj'] = str_replace(',','', $this->data['Quotation']['subtotal_adj']);
			$this->data['Quotation']['max_estimated'] = str_replace(',','', $this->data['Quotation']['max_estimated']);
			$this->data['Quotation']['max_invoice'] = str_replace(',','', $this->data['Quotation']['max_invoice']);

//$turn_number = str_replace(',','',$number);
//exit();
			//if(false){
				if(!$this->Quotation->save($this->data)){		//更新
					$errors = $this->Quotation->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'quotation','action'=>'search'));
				}
			//}
		}
		$this->set('category', $user0['User']['category']);
	}

	/* =================== ログイン管理削除 ======================= */
	function search_delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'quotation','action'=>'index'));
		}

		$this->set('main_title', '見積書情報');
		$this->set('sub_title', '見積書　＞　削除');

		if($arg)
			$this->Quotation->id = $arg;
		else
			$this->Quotation->id = $this->Common->getPost($this, 'Quotation', 'id');

		if(empty($this->data)){
			$this->data = $this->Quotation->read();	//読み出し
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->Quotation->delete($this->Quotation->id)){		//削除
				$errors = $this->Quotation->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'quotation','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
	}
	/* =================== ログイン管理新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'quotation','action'=>'index'));
		}

		$this->set('main_title', '見積書情報');
		$this->set('sub_title', '見積書　＞　新規作成');

		if(empty($this->data)){
			$this->data['Quotation']['category'] = null;
			$this->data['Quotation']['password'] = null;
			$this->data['Quotation']['work_type'] = 0;
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);

			$count = $this->Quotation->find('count', array('conditions' => array('category LIKE' => $this->data['Quotation']['category'])));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}

			$this->data['Quotation']['id'] = null;
//print_r($this->data); echo "<br>";
			if(!$this->Quotation->save($this->data)){		//新規作成
				$errors = $this->Quotation->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
			}else
				$this->redirect(array('controller'=>'quotation','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
	}







	public function upload() {
		$this->set('main_title', "アップロード");
		$this->set('sub_title',  '');
		$file_name = $this->Common->upload_proc("upload", $this, $up_file);
//debug($up_file);
		if($file_name){
			if(strstr($file_name, ".xlsx")){
				//$this->csv_save_proc($up_file);
				$this->xlsx_save_proc($up_file);
				//$this->redirect(array('controller'=>'quotation','action'=>'search'));
			}else
				$this->set('error_message', "ファイルのアップロードに失敗しました。[".$this->data['Upload']['file_name']['name']."]");
		}
	}

	private function xlsx_save_proc($up_file){
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once $this->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** IO Class */
		require_once $this->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		//Configure::write('debug', 2);  // debugコードを出す
		$sql = "TRUNCATE TABLE `quotation`";
//===============================================
		$this->Quotation->query($sql);
//===============================================
        //データの読み込み
        $readData = $this->Excel->readXls($up_file, 33);	
		// param string $filepath,  int $colCount (Optional),  int $rowCount (Optional),  mix $sheetIndex (Optional)
//debug($readData[0]['data']);
		$old_estimate_date = "2007-01-01";

//$val = $readData[0]['data'][6][0];
//debug(PHPExcel_Style_NumberFormat::toFormattedString($readData[0]['data'][2][0], PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD2));
//$estimate_date = date("Y-m-d", intval($readData[0]['data'][6][0])+1180523197);
//debug($readData[0]['data'][6][0]);
//debug(intval($readData[0]['data'][6][0]));
//debug($estimate_date);
//debug(strtotime("2007-5-31"));
//debug(1180562400 - 39203 );
//exit();
		$k = 0;
		$data = array();
		for($i=2; $i<=count($readData[0]['data']); $i++){
			$estimate_date = PHPExcel_Style_NumberFormat::toFormattedString($readData[0]['data'][$i][0], PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD2);
			if($readData[0]['data'][$i][0] == "")
				$estimate_date = $old_estimate_date;
			else
				$old_estimate_date = $estimate_date;
//debug($estimate_date);
//exit();			
			$data['Quotation'][] = array(
						'estimate_date' => $estimate_date,
						'responsible' => $readData[0]['data'][$i][1],
						'dest_up' => $readData[0]['data'][$i][2],
						'tax_rate' => $readData[0]['data'][$i][3],
						'remark_sel' => $readData[0]['data'][$i][4],
						'category' => $readData[0]['data'][$i][5],
						'estimate_no' => $readData[0]['data'][$i][6],
						'creator' => $readData[0]['data'][$i][7],
						'ext_recharge' => $readData[0]['data'][$i][8],
						'tax_flag' => $readData[0]['data'][$i][9],

						'remark_ext' => $this->ConvStr($readData[0]['data'][$i][10]),
						'invoice_no' => $this->ConvStr($readData[0]['data'][$i][11]),
						'subject_up' => $this->ConvStr($readData[0]['data'][$i][12]),
						'dest_low' => $this->ConvStr($readData[0]['data'][$i][13]),
						'subject_mid' => $this->ConvStr($readData[0]['data'][$i][14]),
						'subject_low' => $this->ConvStr($readData[0]['data'][$i][15]),
						'address' => $this->ConvStr($readData[0]['data'][$i][16]),
						'product_name' => $this->ConvStr($readData[0]['data'][$i][17]),

						'quantity' => $this->ConvStrNum($readData[0]['data'][$i][18]),
						'qty_assist' => $this->ConvStr($readData[0]['data'][$i][19]),
						'price' => $this->ConvStrPrice($readData[0]['data'][$i][20]),
						'amount_line' => $this->ConvStrNum($readData[0]['data'][$i][21]),
						'remark' => $this->ConvStr($readData[0]['data'][$i][22]),

						'subtotal' => $readData[0]['data'][$i][23],
						'labor_cost' => $readData[0]['data'][$i][24],
						'choice' => $readData[0]['data'][$i][25],
						'tax_adj' => $readData[0]['data'][$i][26],
						'tax_calc_frame' => $readData[0]['data'][$i][27],
						'other_expense' => $readData[0]['data'][$i][28],
						'subtotal_adj' => $readData[0]['data'][$i][29],
						'total_amount' => $readData[0]['data'][$i][30],
						'discount' => $readData[0]['data'][$i][31],
						'max estimated' => $readData[0]['data'][$i][32],
						'max_invoice' => $readData[0]['data'][$i][33]
						);
			$k++;
		}
//debug($data);
//		if(false){
		if(!$this->Quotation->saveAll($data['Quotation'], array('atomic' => false))){		//更新
			$errors = $this->Quotation->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
		}else{
			if($this->Quotation->find('count') > 0){
				$this->set('error_message', "ファイル・アップロードに成功しました。");
			}else{
				$this->set('error_message', "ファイル・アップロードに失敗しました。");
debug($this->Quotation->getAffectedRows());
			}

		}

	}

	private function csv_save_proc($up_file){
		$sql = "TRUNCATE TABLE `quotation`";
//		$this->Quotation->query($sql);

		$handle = @fopen($up_file, "r");
		if ($handle) {
			$line = "";
		    while (!feof($handle)) {
		        $buf = fgets($handle, 4096);
//echo "buf=[".$buf."]<hr>";
				$last = substr($buf, -3);
//echo "last=[".$last."]<hr>";
//echo "last=[".bin2hex($last)."]<hr>";
				if(($last == "\x22\x0d\x0a") || ($last == "\x22\x0a")){
					$line .= "\x22";
//echo $line."<hr>";
		//			$this->Common->save_csv_line($this->Quotation, $line);
					$line = "";
				}else
					$line .= $buf;
		    }
		    fclose($handle);
			$this->set('error_message', "ファイル・アップロードに成功しました。");
		}
	}


	private function ConvStr($s){
		$NowPos = 0;
		$buf = "";
		for($i=1; $i <= mb_strlen($s); $i++){
			$c = mb_substr($s, $NowPos, 1);
        	$n = ord($c);
        	// debug($c);
        	// debug($n);
        	If( $c == "'"){
            	$buf = $buf . "\'";
        	}elseif( $c == chr(10)){
            	$buf = $buf . " ";
        	}elseif( $c == chr(29)){
            	$buf = $buf . "/";
        	}elseif( $n == 9 ){
            	$buf = $buf . "_";
        	}elseif( $c == "/" ){
            	$buf = $buf . "／";
        	}elseif($n > 0 && $n <= 30){
debug("UnknownCH：[".$c."][".$n."]");
exit();
            	$buf = $buf . "?";
        	}else{
            	$buf = $buf . $c;
        	}
        	$NowPos = $NowPos + 1;
    	}
    	return $buf;
	}

	private function ConvStrNum($s){
		$NowPos = 0;
		$buf = "";
		for($i=1; $i <= mb_strlen($s); $i++){
			$c = mb_substr($s, $NowPos, 1);
        	$n = ord($c);
        	// debug($c);
        	// debug($n);
        	If( $c == "'"){
            	$buf = $buf . "\'";
        	}elseif( $c == chr(10)){
            	$buf = $buf . " ";
        	}elseif( $c == chr(29)){
            	$buf = $buf . "/";
        	}elseif( $n == 9 ){
            	$buf = $buf . "_";
//        	}elseif( $c == "/" ){
//            	$buf = $buf . "／";
//        	}elseif( $c == "式" or $c == "枚" or $c == "台" or $c == "上" or $c == "記" ){
//            	$buf = $buf;
        	}elseif(!preg_match('/[^一-龠]/u',$c)) {
debug("UnknownCH：[".$c."][".$n."]");
exit();
            	$buf = $buf . "?";
        	}elseif( $c == "/" ){
debug("UnknownCH：[".$c."][".$n."]");
exit();
        	}else{
            	$buf = $buf . $c;
        	}
        	$NowPos = $NowPos + 1;
    	}
    	return $buf;
	}


	private function ConvStrPrice($s){
		$NowPos = 0;
		$buf = "";
		for($i=1; $i <= mb_strlen($s); $i++){
			$c = mb_substr($s, $NowPos, 1);
        	$n = ord($c);
        	// debug($c);
        	// debug($n);
        	If( $c == "'"){
            	$buf = $buf . "\'";
        	}elseif( $c == chr(10)){
            	$buf = $buf . " ";
        	}elseif( $c == chr(29)){
            	$buf = $buf . "/";
        	}elseif( $n == 9 ){
            	$buf = $buf . "_";
//        	}elseif( $c == "/" ){
//            	$buf = $buf . "／";
        	}elseif( $c == "式" or $c == "枚" or $c == "台" or $c == "上" or $c == "記" or $c == "含" or $c == "個"  or $c == "所" ){
            	$buf = $buf;
        	}elseif(!preg_match('/[^一-龠]/u',$c)) {
debug("UnknownCH：[".$c."][".$n."]");
exit();
            	$buf = $buf . "?";
        	}elseif( $c == "/" ){
debug("UnknownCH：[".$c."][".$n."]");
exit();
        	}else{
            	$buf = $buf . $c;
        	}
        	$NowPos = $NowPos + 1;
    	}
    	return $buf;
	}

	private function ConvPath($s){
		$NowPos = 0;
		$buf = "";
		$c0 = mb_substr($s, 0, 1);
		for($i=1; $i <= mb_strlen($s); $i++){
			$c = mb_substr($s, $NowPos, 1);
        	$n = ord($c);
        	// debug($c);
        	// debug($n);
        	if( (($c0 == "C") or ($c0 == "D")) and ( $c == "/")){
            	$buf = $buf . "\\";
        	}elseif( (($c0 == "c") or ($c0 == "d")) and ( $c == "/")){
            	$buf = $buf . "\\";
        	}else{
            	$buf = $buf . $c;
        	}
        	$NowPos = $NowPos + 1;
    	}
    	return $buf;
	}
	
	function download($arg=""){
		$this->set('main_title', "ダウンロード");
		$this->set('sub_title',  '');
		
		if($arg)
			$this->Quotation->id = $arg;
		else
			$this->Quotation->id = $this->Common->getPost($this, 'Quotation', 'id');

		if(empty($this->data)){
			$this->data = $this->Quotation->read();	//読み出し
			$this->xlsx_write_proc();
		}else{
		
		}
//debug($up_file);
		$this->set('data', $this->data);
	}

	private function xlsx_write_proc(){
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/quotation/excel/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/quotation/excel/" );
		//$filename = "quotation_form.xlsx";
		$filename = "quotation_form.xls";

		$excel_file = $path.$filename;
		if(file_exists($excel_file))
			unlink($excel_file);
		copy($path0.$filename, $excel_file);
		
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once $this->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** IO Class */
		require_once $this->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );
//print_r($this->data); echo "<br>";
        //App::import('vendor','phpexcel/phpexcel');

        //ファイルを読み込む
        //$objReader = PHPExcel_IOFactory::createReader('Excel2007');
		$objReader = PHPExcel_IOFactory::createReader('Excel5');

        $objPHPExcel = $objReader->load($excel_file);
		$objPHPExcel->setActiveSheetIndex(0);
		
        $sheet = $objPHPExcel->getActiveSheet();
        //$sheet->setCellValueByColumnAndRow($c, $r+1, $v);

		$sheet->setCellValue('B6', $this->data['Quotation']['dest_up']);
		$sheet->setCellValue('B7', $this->data['Quotation']['dest_low']);
		$sheet->setCellValue('M7', $this->data['Quotation']['address']);

		$sheet->setCellValue('B14', $this->data['Quotation']['subject_up']);
		$sheet->setCellValue('B17', $this->data['Quotation']['subject_mid']);
		$sheet->setCellValue('B20', $this->data['Quotation']['subject_low']);
		
		$sheet->setCellValue('V2', $this->data['Quotation']['estimate_no']);
		$sheet->setCellValue('Q6', date('Y年m月d日', strtotime($this->data['Quotation']['estimate_date'])));
		$sheet->setCellValue('R26', $this->data['Quotation']['responsible']);
		
		$sheet->setCellValue('M28', $this->data['Quotation']['total_amount']);
		
		$a = explode("/", $this->data['Quotation']['product_name']);
		$b = explode("/", $this->data['Quotation']['quantity']);
		$c = explode("/", $this->data['Quotation']['qty_assist']);
		$d = explode("/", $this->data['Quotation']['price']);
		$e = explode("/", $this->data['Quotation']['amount_line']);
		$f = explode("/", $this->data['Quotation']['remark']);

//debug(count($a));
		if(count($a) >= 12)
			$n = 11;
		else
			$n = count($a);

		for($i=0; $i<$n; $i++){
			if(trim($a[$i].$b[$i].$c[$i].$d[$i].$e[$i]) != ""){
	        	$sheet->setCellValueByColumnAndRow(2, 34+$i, $this->zero_check( $a[$i] )); //C24
	        	$sheet->setCellValueByColumnAndRow(9, 34+$i, $this->zero_check( $b[$i] )); //J24
	        	$sheet->setCellValueByColumnAndRow(11, 34+$i, $this->zero_check( $c[$i] )); //L24
	        	$sheet->setCellValueByColumnAndRow(13, 34+$i, $this->zero_check( $d[$i] )); //N24
	        	$sheet->setCellValueByColumnAndRow(16, 34+$i, $this->zero_check( $e[$i] )); //Q24
	        	$sheet->setCellValueByColumnAndRow(20, 34+$i, $this->zero_check( $f[$i] )); //U24
			}
		}
		
		$sheet->setCellValue('I47', $this->zero_check($this->data['Quotation']['labor_cost']));
		$sheet->setCellValue('I48', $this->zero_check($this->data['Quotation']['other_expense']));
		$sheet->setCellValue('I43', $this->zero_check($this->data['Quotation']['discount']));

		$sheet->setCellValue('S47', $this->zero_check($this->data['Quotation']['subtotal']));
		$sheet->setCellValue('S48', $this->zero_check($this->data['Quotation']['tax_calc_frame']));
		$sheet->setCellValue('S49', $this->zero_check($this->data['Quotation']['total_amount']));

		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel5");
		$writer->save($excel_file);

//debug($this->data['Quotation']['dest_up']);
//debug($this->data['Quotation']['dest_low']);
		//$excel_file = $this->ConvPath( WWW_ROOT."files/quotation_form.xlsx" );
		
		$filename = $this->data['Quotation']['dest_low'];
		if($filename == "")
			$filename = $this->data['Quotation']['dest_up'];
		//$filename = date("Ymd_", strtotime($this->data['Quotation']['estimate_date'])) . $filename . "_見積書.xlsx";
		$filename = date("Ymd_", strtotime($this->data['Quotation']['estimate_date'])) . $filename . "_見積書.xls";
		// $this->Common->to_utf8();
		Configure::write('debug', 0);       // debugコードを非表示
		header("Content-disposition: attachment; filename={$filename}");    //ダウンロードさせるため
		header("Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; name={$filename}");
 
		$result = file_get_contents( $excel_file );   // ダウンロードするデータの取得
		print( $result );           // 出力
 //exit();
		return $filename;
	}

	private function zero_check($n){
		if($n == "")
			return "";
		elseif(is_numeric($n))
			return number_format(intval( $n ));
		else
			return $n;
	}

}