<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.inabous.net/inabou/Purchase/

class PurchaseController extends AppController {
	public $name = 'Purchase';
	public $uses = array('User', 'Purchase', 'Quotation', 'Logs', 'Delicom', 'Delicom2');
	public $layout = 'dafault';

	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'
	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;
	private $debug = false;

    function beforeFilter() {
	//	define("Classes", $_SERVER["DOCUMENT_ROOT"]."/cakephp/class/");
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");
		
		if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
		}

		$this->set('main_title', "発注書");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Purchase
		$this->set('URL_SELF', $this->URL_SELF);

		//$username = $this->Auth->user('username');
		//$this->set('username', $username);
		
		//$username = $this->Purchase->field('User', array('username' => $username));
		//$this->set('username', $username);
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->Purchase->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/purchase_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'purchase','action'=>'search'));
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "発注書",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "発注書";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}



	/* =================== 　発注書検索　 ======================= */
	public function search($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'purchase','action'=>'index'));
		}
		$this->set('main_title', '発注書(検索)');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Purchase', 'search');
		$id = $this->Common->getPost($this, 'Purchase', 'id');
		
		$ApplicationDate = $this->Common->getPost($this, 'Purchase', 'ApplicationDate');
		$ApplicationDate1 = $this->Common->getPost($this, 'Purchase', 'ApplicationDate1');
		$ApplicationDate2 = $this->Common->getPost($this, 'Purchase', 'ApplicationDate2');

		if(!$ApplicationDate1){
			$a = $this->Common->GetModelAll("Purchase", "ApplicationDate");
			if(count($a) > 0)
				$ApplicationDate1 = $a[0];
			$this->set('ApplicationDate1', 	$ApplicationDate1);
		}
//debug($ApplicationDate1);

		if(!$ApplicationDate2){
			$a = $this->Common->GetModelAll("Purchase", "ApplicationDate");
			if(count($a) > 0)
				$ApplicationDate2 = $a[count($a)-1];
			$this->set('ApplicationDate2', 	$ApplicationDate2);
		}
//debug($ApplicationDate2);

		$Applicant = $this->Common->getPost($this, 'Purchase', 'Applicant');
		$ApprovalDate = $this->Common->getPost($this, 'Purchase', 'ApprovalDate');

		$OrderDate = $this->Common->getPost($this, 'Purchase', 'OrderDate');

		$OrderName = $this->Common->getPost($this, 'Purchase', 'OrderName');
		$OrderNo = $this->Common->getPost($this, 'Purchase', 'OrderNo');

		$Supplier = $this->Common->getPost($this, 'Purchase', 'Supplier');
		$SupplierName = $this->Common->getPost($this, 'Purchase', 'SupplierName');
		$Subject = $this->Common->getPost($this, 'Purchase', 'Subject');

		$DeliveryTime = $this->Common->getPost($this, 'Purchase', 'DeliveryTime');

		$PaymentTerms = $this->Common->getPost($this, 'Purchase', 'PaymentTerms');
		$EstimateNo = $this->Common->getPost($this, 'Purchase', 'EstimateNo');

		$ProductName = $this->Common->getPost($this, 'Purchase', 'ProductName');
		$ModelNo = $this->Common->getPost($this, 'Purchase', '$ModelNo');
		$ProductCode = $this->Common->getPost($this, 'Purchase', 'ProductCode');
		$Qty = $this->Common->getPost($this, 'Purchase', 'Qty');
		$UnitPrice = $this->Common->getPost($this, 'Purchase', 'UnitPrice');
		$Amount = $this->Common->getPost($this, 'Purchase', 'Amount');

		$SubTotal = $this->Common->getPost($this, 'Purchase', 'SubTotal');
		$Tax = $this->Common->getPost($this, 'Purchase', 'Tax');
		$Total = $this->Common->getPost($this, 'Purchase', 'Total');
		$Note = $this->Common->getPost($this, 'Purchase', 'Note');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Purchase', 'page');
		$direction = $this->Common->getPost($this, 'Purchase', 'direction');
		$sort = $this->Common->getPost($this, 'Purchase', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($ApplicationDate)
			$condition = array_merge_recursive($condition, array( "ApplicationDate" => $ApplicationDate ));

	//------------------------------
		if($ApplicationDate)
			$condition = array_merge_recursive($condition, array( "ApplicationDate like" => $ApplicationDate));
		if($ApplicationDate1 and $ApplicationDate2)
			$condition = array_merge_recursive($condition, array('ApplicationDate BETWEEN ? AND ?' => array($ApplicationDate1, $ApplicationDate2)));
	//------------------------------
		if($Applicant)
			$condition = array_merge_recursive($condition, array( "Applicant like" => '%'.$Applicant.'%'));
		if($ApprovalDate)
			$condition = array_merge_recursive($condition, array( "ApprovalDate" => $ApprovalDate ));

	//------------------------------
		if($OrderDate)
			$condition = array_merge_recursive($condition, array( "OrderDate like" => $OrderDate));
	//------------------------------

		if($OrderName)
			$condition = array_merge_recursive($condition, array( "OrderName like" => '%'.$OrderName.'%'));

		if($OrderNo)
			$condition = array_merge_recursive($condition, array( "OrderNo like" => '%'.$OrderNo.'%'));

		if($Supplier)
			$condition = array_merge_recursive($condition, array( "Supplier like" => '%'.$Supplier.'%'));
		if($SupplierName)
			$condition = array_merge_recursive($condition, array( "SupplierName like" => '%'.$SupplierName.'%'));
		if($Subject)
			$condition = array_merge_recursive($condition, array( "Subject like" => '%'.$Subject.'%'));

	//-------------------------
		if($DeliveryTime)
			$condition = array_merge_recursive($condition, array( "DeliveryTime like" => $DeliveryTime));
	//--------------------------
		if($PaymentTerms)
			$condition = array_merge_recursive($condition, array( "PaymentTerms like" => $PaymentTerms));
		if($EstimateNo)
			$condition = array_merge_recursive($condition, array( "EstimateNo like" => $EstimateNo));

		if($ProductName)
			$condition = array_merge_recursive($condition, array( "ProductName like" => '%'.$ProductName.'%'));
		if($ModelNo)
			$condition = array_merge_recursive($condition, array( "ProductName like" => '%'.$ModelNo.'%'));
		if($ProductCode)
			$condition = array_merge_recursive($condition, array( "ProductCode like" => '%'.$ProductCode.'%'));
		if($Note)
			$condition = array_merge_recursive($condition, array( "Note like" => '%'.$Note.'%'));

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "ApplicationDate" => urlencode($ApplicationDate),
				     "Applicant" => urlencode($Applicant),
				     "ApprovalDate" => urlencode($ApprovalDate),

				     "OrderDate" => urlencode($OrderDate),

				     "OrderName" => urlencode($OrderName),
				     "OrderNo" => urlencode($OrderNo),

				     "Supplier" => urlencode($Supplier),
				     "SupplierName" => urlencode($SupplierName),
				     "Subject" => urlencode($Subject),

				     "DeliveryTime" => urlencode($DeliveryTime),

				     "PaymentTerms" => urlencode($PaymentTerms),
				     "ProductName" => urlencode($ProductName),
				     "ProductCode" => urlencode($ProductCode),
				     "Note" => urlencode($Note),
		);
		/* ページネーションの作成 */
		//$this->paginate = array('Purchase' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->paginate = array('Purchase' => array('conditions' => $condition, 'limit'=>100, 'order'=>array('id desc', 'ApplicationDate desc')));

		$this->data = $this->paginate('Purchase');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);
		$this->set('user_id', $user0['User']['id']);
		$this->set('login_user', $user0['User']);
		$this->set('ExportDateY', date("Y"));
		$this->set('ExportDateM', date("m"));

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			//if(!$search)
				//$this->redirect(array('controller'=>'purchase','action'=>'search', 'page:1/direction:asc/sort:id'));
		}
	}

	public function search_update(){
	
		$sql = "set @n:=0";
		$ret = $this->Purchase->query($sql);
		$sql = "update `purchase` set id=@n:=@n+1"; 
		$ret = $this->Purchase->query($sql);
		
		$this->redirect(array('controller'=>'purchase','action'=>'search'));
	}


	/* =================== 　発注書検索　 ======================= */
	public function search2($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'purchase','action'=>'index'));
		}
		$this->set('main_title', '商品検索2・請求書');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Purchase2', 'search');
		$id = $this->Common->getPost($this, 'Purchase2', 'id');
		$OrderName = $this->Common->getPost($this, 'Purchase2', 'OrderName');
		$ProductName = $this->Common->getPost($this, 'Purchase2', 'ProductName');
		$ProductCode = $this->Common->getPost($this, 'Purchase2', 'ProductCode');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Purchase2', 'page');
		$direction = $this->Common->getPost($this, 'Purchase2', 'direction');
		$sort = $this->Common->getPost($this, 'Purchase2', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($OrderName)
			$condition = array_merge_recursive($condition, array( "OrderName like" => '%'.$OrderName.'%'));

		if($ProductName)
			$condition = array_merge_recursive($condition, array( "ProductName like" => '%'.$ProductName.'%'));

		if($ProductCode)
			$condition = array_merge_recursive($condition, array( "ProductCode like" => '%'.$ProductCode.'%'));

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "OrderName" => urlencode($OrderName),
				     "ProductName" => urlencode($ProductName),
				     "ProductCode" => urlencode($ProductCode),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Purchase2' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Purchase2');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);
		$this->set('user_id', $user0['User']['id']);
		$this->set('login_user', $user0['User']);

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'purchase','action'=>'search2', 'page:1/direction:asc/sort:id'));
		}
	}



	/* =================== 発注書修正 ======================= */
	function search_edit($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'purchase','action'=>'index'));
		}

		$this->set('main_title', '発注書(編集)');
		$this->set('sub_title', '発注書　＞　編集');

		if($arg)
			$this->Purchase->id = $arg;
		else
			$this->Purchase->id = $this->Common->getPost($this, 'Purchase', 'id');

		if(empty($this->data)){
			$this->data = $this->Purchase->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			$a = $this->Common->getPost($this, 'Purchase', 'ProductName');
//debug($ProductName);
			$b = $this->Common->getPost($this, 'Purchase', 'ModelNo');
			$c = $this->Common->getPost($this, 'Purchase', 'ProductCode');
			
			$d = $this->Common->getPost($this, 'Purchase', 'Qty');
			$this->data['Purchase']['Qty'] = implode("|", $d);
			$e = $this->Common->getPost($this, 'Purchase', 'UnitPrice');
			$this->data['Purchase']['UnitPrice'] = implode("|", $e);
			$t = 0;
			for($i=0; $i<count($a); $i++){
				if(strlen($a[$i]) == 0)
					break;
				$a1[$i] = trim($a[$i]);
				$b1[$i] = trim($b[$i]);
				$c1[$i] = trim($c[$i]);
				$d1[$i] = trim(mb_convert_kana($d[$i], "as"));
				$e1[$i] = trim(mb_convert_kana($e[$i], "as"));
				$f1[$i] = $d1[$i] * $e1[$i];
				$t += $f1[$i];
			}
			$this->data['Purchase']['ProductName'] = mb_convert_kana( implode("|", $a1), "KVa");
			$this->data['Purchase']['ModelNo']     = mb_convert_kana( implode("|", $b1), "KVa");
			$this->data['Purchase']['ProductCode'] = mb_convert_kana( implode("|", $c1), "KVa");
			$this->data['Purchase']['Qty'] = implode("|", $d1);
			$this->data['Purchase']['UnitPrice'] = implode("|", $e1);
			$this->data['Purchase']['Amount'] = implode("|", $f1);
			
			$this->data['Purchase']['SubTotal'] = $t;
			$this->data['Purchase']['Tax'] = floor($t * 0.1);
			$this->data['Purchase']['Total'] = $t + $this->data['Purchase']['Tax'];
			
			if(isset($this->data['Purchase']['Approval'])){
			 	if($this->data['Purchase']['Approval'] == 1){
			 		$this->data['Purchase']['ApprovalDate'] = date("Y-m-d");
					//$this->send_mail($this->data['Purchase']);
				}
			}
			
			$Supplier = $this->Common->getPost($this, 'Purchase', 'Supplier');
			$Supplier = $this->Common->mb_str_replace("㈱","(株)",$Supplier,"UTF-8");
			$this->data['Purchase']['Supplier'] =  mb_convert_kana($Supplier, "KVa");

			$SupplierName = $this->Common->getPost($this, 'Purchase', 'SupplierName');
			$SupplierName = $this->Common->mb_str_replace("㈱","(株)",$SupplierName,"UTF-8");
			$this->data['Purchase']['SupplierName'] =  mb_convert_kana($SupplierName, "KVa");

			$Subject = $this->Common->getPost($this, 'Purchase', 'Subject');
			$this->data['Purchase']['Subject'] =  mb_convert_kana($Subject, "KVa");

			$PaymentTerms = $this->Common->getPost($this, 'Purchase', 'PaymentTerms');
			$this->data['Purchase']['PaymentTerms'] =  mb_convert_kana($PaymentTerms, "KVa");

			$EstimateNo = $this->Common->getPost($this, 'Purchase', 'EstimateNo');
			$this->data['Purchase']['EstimateNo'] =  mb_convert_kana($EstimateNo, "KVa");


//print_r($this->data);
//exit();

			if(!$this->Purchase->save($this->data)){		//更新
				$errors = $this->Purchase->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
				$this->set('data', $this->data);
			}else{
			  	if(!isset($this->data['Purchase']['ApprovalDate'])){
					$this->data['Purchase']['ApprovalDate'] = "0000-00-00";
				}
				if(strtotime($this->data['Purchase']['ApprovalDate']) < strtotime("2021-01-05")){
					if(isset($this->data['Purchase']['Approval'])){
						if($this->data['Purchase']['Approval'] == 1)
							$this->send_mail($this->data['Purchase']);
					}
				}
				$this->redirect(array('controller'=>'purchase','action'=>'search'));
				//$this->data = $this->Purchase->read();	//読み出し
				//$this->set('data', $this->data);
			}
		}
		$this->set('category', $user0['User']['category']);
		$this->set('user_id', $user0['User']['id']);
		$this->set('login_user', $user0['User']);
	}

	/* =================== 発注書削除 ======================= */
	function search_delete($arg=""){
		$user0 = $this->Auth->user();

		$this->set('main_title', '発注書(削除)');
		$this->set('sub_title', '発注書　＞　削除');

		if($arg)
			$this->Purchase->id = $arg;
		else
			$this->Purchase->id = $this->Common->getPost($this, 'Purchase', 'id');

		if(empty($this->data)){
			$this->data = $this->Purchase->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->Purchase->delete($this->Purchase->id)){		//削除
				$errors = $this->Purchase->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'purchase','action'=>'search'));
		}
		$this->set('category', $user0['User']['category']);
		$this->set('user_id', $user0['User']['id']);
		$this->set('login_user', $user0['User']);
	}
	
	
	
	/* =================== 発注書新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();

		$this->set('main_title', '発注書(新規作成)');
		$this->set('sub_title', '発注書　＞　新規作成');

		if(empty($this->data)){
			$lastID = $this->Purchase->getLastInsertID();
//echo $lastID."<br>";
			if($lastID <= 0){
				$d = $this->Purchase->find('first', array('fields' => array('Max(id) as max_id')));
//print_r($d);
//echo $d[0]['max_id'];
				$lastID = $d[0]['max_id'];
			}
			$this->data = $this->Purchase->find('first', array('conditions' => array('id' => $lastID)));
			$this->set('data', $this->data);
		}else{
			$a = $this->Common->getPost($this, 'Purchase', 'ProductName');
//debug($ProductName);
			$b = $this->Common->getPost($this, 'Purchase', 'ModelNo');
			$c = $this->Common->getPost($this, 'Purchase', 'ProductCode');
			
			$d = $this->Common->getPost($this, 'Purchase', 'Qty');
			$this->data['Purchase']['Qty'] = implode("|", $d);
			$e = $this->Common->getPost($this, 'Purchase', 'UnitPrice');
			$this->data['Purchase']['UnitPrice'] = implode("|", $e);
			$t = 0;
			for($i=0; $i<count($a); $i++){
				if(strlen($a[$i]) == 0)
					break;
				$a1[$i] = trim($a[$i]);
				$b1[$i] = trim($b[$i]);
				$c1[$i] = trim($c[$i]);
				$d1[$i] = trim(mb_convert_kana($d[$i], "as"));
				$e1[$i] = trim(mb_convert_kana($e[$i], "as"));
				$f1[$i] = $d1[$i] * $e1[$i];
				$t += $f1[$i];
			}
			$this->data['Purchase']['ProductName'] = mb_convert_kana( implode("|", $a1), "KVa");
			$this->data['Purchase']['ModelNo']     = mb_convert_kana( implode("|", $b1), "KVa");
			$this->data['Purchase']['ProductCode'] = mb_convert_kana( implode("|", $c1), "KVa");

			$this->data['Purchase']['Qty'] = implode("|", $d1);
			$this->data['Purchase']['UnitPrice'] = implode("|", $e1);
			$this->data['Purchase']['Amount'] = implode("|", $f1);
			
			$this->data['Purchase']['SubTotal'] = $t;
			$this->data['Purchase']['Tax'] = floor($t * 0.1);
			$this->data['Purchase']['Total'] = $t + $this->data['Purchase']['Tax'];
			
			if(isset($this->data['Purchase']['Approval'])){
			 if($this->data['Purchase']['Approval'] == 1)
			 	$this->data['Purchase']['ApprovalDate'] = date("Y-m-d");
			}
			
			$Supplier = $this->Common->getPost($this, 'Purchase', 'Supplier');
			$Supplier = $this->Common->mb_str_replace("㈱","(株)",$Supplier,"UTF-8");
			$this->data['Purchase']['Supplier'] =  mb_convert_kana($Supplier, "KVa");

			$SupplierName = $this->Common->getPost($this, 'Purchase', 'SupplierName');
			$SupplierName = $this->Common->mb_str_replace("㈱","(株)",$SupplierName,"UTF-8");
			$this->data['Purchase']['SupplierName'] =  mb_convert_kana($SupplierName, "KVa");

			$Subject = $this->Common->getPost($this, 'Purchase', 'Subject');
			$this->data['Purchase']['Subject'] =  mb_convert_kana($Subject, "KVa");
			
			$PaymentTerms = $this->Common->getPost($this, 'Purchase', 'PaymentTerms');
			$this->data['Purchase']['PaymentTerms'] =  mb_convert_kana($PaymentTerms, "KVa");

			$EstimateNo = $this->Common->getPost($this, 'Purchase', 'EstimateNo');
			$this->data['Purchase']['EstimateNo'] =  mb_convert_kana($EstimateNo, "KVa");
//print_r($this->data);
//exit();
			$this->data['Purchase']['id'] = null;

			if(!$this->Purchase->save($this->data)){		//更新
				$errors = $this->Purchase->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
				$this->set('data', $this->data);
			}else{
				$this->redirect(array('controller'=>'purchase','action'=>'search'));
				
			//	$this->data['Purchase']['id'] = $this->Purchase->getLastInsertID();
			//	$this->data = $this->Purchase->read();	//読み出し
			//	$this->set('data', $this->data);
			}
		}
		$this->set('category', $user0['User']['category']);
		$this->set('user_id', $user0['User']['id']);
		$this->set('login_user', $user0['User']);
	}


	function send_mail($data){
//debug($data);
		$user0 = $this->Auth->user();
		
		$a = explode(" ", $data['Applicant']);
		$ret = $this->User->find('first', array('fields' => array('email'), 'conditions' => array('name1' => $a[0], 'name2' => $a[1])));

		$from = "yn.inabou@docomo.ne.jp";
		$name_from = "奈良部 義彦";
//debug($from);
//debug($name_from);
//exit();
		//if(strstr($_SERVER['SERVER_NAME'], "p5.yoshikura.com")){
		if(strstr($_SERVER['SCRIPT_URI'], "p5.inabous.net/inabou/")){
			$to = $ret['User']['email'];
			$name_to = $data['Applicant'];
			$cc = "nakanishi@inabou.co.jp";		//"yoshikura@inabous.net";	//"nakanishi@inabou.co.jp"
			$bcc = "admin@inabous.net";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";
		}else{
			$to = "admin@inabous.net";
			$name_to = $data['Applicant'];
			$cc = "admin@inabous.net";		//"yoshikura@inabous.net";	//"nakanishi@inabou.co.jp"
			$bcc = "yoshikura@inabous.net";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";
		}
//debug($to);

		$subject = "発注内容が承認されました。";

		$mailbody = $from."\r\n".$name_from."\r\n";
		$mailbody .= "ID= ".$data['id']."\r\n";
		$mailbody .= "☆☆☆発注内容☆☆☆"."\r\n";
		
		$mailbody .= "登録日= ".$data['ApplicationDate']."\r\n";
		$mailbody .= "登録者= ".$data['Applicant']."\r\n";
		$mailbody .= "承認日= ".$data['ApprovalDate']."\r\n";
		$mailbody .= "材料使用日= ".$data['OrderDate']."\r\n";
		$mailbody .= "発注者= ".$data['OrderName']."\r\n";
		$mailbody .= "発注分類= ".$data['OrderNo']."\r\n";
		$mailbody .= "発注先= ".$data['Supplier']."\r\n";
		$mailbody .= "請求先= ".$data['SupplierName']."\r\n";
		$mailbody .= "件名= ".mb_convert_kana($data['Subject'],'K','utf-8')."\r\n";
		$mailbody .= "納期= ".$data['DeliveryTime']."\r\n";
		$mailbody .= "支払方法= ".$data['PaymentTerms']."\r\n";
		$mailbody .= "見積書No= ".$data['EstimateNo']."\r\n";
		$mailbody .= "品名= ".mb_convert_kana($data['ProductName'],'K','utf-8')."\r\n";
		$mailbody .= "型番= ".mb_convert_kana($data['ModelNo'],'K','utf-8')."\r\n";
		$mailbody .= "コード= ".mb_convert_kana($data['ProductCode'],'K','utf-8')."\r\n";
		
		$mailbody .= "数量= ".$this->Common->number_format2( $data['Qty'] )."\r\n";
		$mailbody .= "単価= ".$this->Common->number_format2( $data['UnitPrice'] )."\r\n";
		$mailbody .= "金額= ".$this->Common->number_format2( $data['Amount'] )."\r\n";
		
		$mailbody .= "小計= ".number_format( $data['SubTotal'] )."\r\n";
		$mailbody .= "税金= ".number_format( $data['Tax'] )."\r\n";
		$mailbody .= "合計金額= ".number_format( $data['Total'] )."\r\n";
		$mailbody .= "備考= ".$data['Note']."\r\n";


		if( $data['Attachment'] <> "" ){
			$mailbody .= "添付= ".$data['Attachment']."\r\n";
		}

		//$name_from .= "<".$from.">";

		//$this->set('send_mail', nl2br($to."\n------------------\n".$subject."\n-----------------\n".$mailbody."\n-----------------\n"));

		// $this->Qdmail->debug = $debug;
		$param = array(
		    'host' => 'ssl://mail.inabous.net',	//メールサーバー
		    'port' => 465,					//これはSMTPAuthの例。認証が必要ないなら　25　でＯＫ。
			'from' => 'admin@inabous.net',	//　Return-path: になります。
			'protocol' => 'SMTP_AUTH',		// 認証が必要ないなら、'SMTP'
		    'user' => 'admin@inabous.net',	//SMTPサーバーのユーザーID
		    'pass' => 'es10Um818'			//SMTPサーバーの認証パスワード
		);
		$this->Qdmail->smtpServer($param);
		$this->Qdmail->to( $to, $name_to );
		$this->Qdmail->cc( $cc, '中西' );
		$this->Qdmail->bcc( $bcc, 'bcc管理者' );
		
		$this->Qdmail->replyto($from, $name_from );
		$this->Qdmail->subject($subject);
		$this->Qdmail->from($from, $name_from );
		$this->Qdmail->text( $mailbody );
		$return_flag = $this->Qdmail->send();
		//debug($return_flag);

		if(!$return_flag){
			$this->set('error_message', "メール送信エラー");
debug("メール送信エラー");
			//return false;
		}else{
			//$this->set('error_message', "メール送信完了");
//debug("メール送信完了");
			//return true;
		}
//exit();
//		$this->redirect(array('controller'=>'users','action'=>'login'));

	}

	
	function search_app_mail($id){
		$data = $this->Purchase->find('first', array( 'conditions' => array('id' => $id)));
//debug($data);

		$a = explode(" ", $data['Purchase']['Applicant']);
//debug($a);
//exit();

		$ret = $this->User->find('first', array('fields' => array('email'), 'conditions' => array('name1' => $a[0], 'name2' => $a[1])));
		$from = $ret['User']['email'];
		$name_from = $data['Purchase']['Applicant'];
//debug($_SERVER['SCRIPT_URI']);	//D:/xampp/htdocs/inabou/app/webroot/index.php
//exit();
		if(strstr($_SERVER['SCRIPT_URI'], "p5.inabous.net/inabou/")){
			$to = "yn.inabou@docomo.ne.jp";
			$name_to = "奈良部 義彦";
		}else{
			$to = "admin@inabous.net";
			$name_to = "奈良部 義彦";
		}
//debug($to);
		$cc = "admin@inabous.net";		//"yoshikura@inabous.net";	//"nakanishi@inabou.co.jp"
		$bcc = "yoshikura@inabous.net";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";

		$subject = "発注承認依頼";

		$mailbody = $this->html_mail_body($data['Purchase'], $from, $name_from);
	
		$param = array(
		    'host' => 'ssl://mail.inabous.net',	//メールサーバー
		    'port' => 465,					//これはSMTPAuthの例。認証が必要ないなら　25　でＯＫ。
			'from' => 'admin@inabous.net',	//　Return-path: になります。
			'protocol' => 'SMTP_AUTH',		// 認証が必要ないなら、'SMTP'
		    'user' => 'admin@inabous.net',	//SMTPサーバーのユーザーID
		    'pass' => 'es10Um818'			//SMTPサーバーの認証パスワード
		);
		$this->Qdmail->smtpServer($param);
		$this->Qdmail->to( $to, $name_to );
		$this->Qdmail->cc( $cc, 'cc管理者' );
		$this->Qdmail->bcc( $bcc, 'bcc管理者' );
		
		$this->Qdmail->replyto($from, $name_from );
		$this->Qdmail->subject($subject);
		$this->Qdmail->from($from, $name_from );
		$this->Qdmail->text( $mailbody );
		
		if( $data['Purchase']['Attachment'] <> "" ){
			//添付ファイル
			if(strstr($_SERVER['SCRIPT_URI'], "p5.yoshikura.com/"))
				$file = WWW_ROOT."files/purchase/upload/".$data['Purchase']['Attachment'];
			else
				$file = WWW_ROOT."files/purchase/upload/".$this->Common->to_sjis( $data['Purchase']['Attachment'] );

			if(file_exists($file)){
				$attach[] = array($file, $data['Purchase']['Attachment']);
				//$attach[] = array('/etc/upload/attachfile.png', '添付ファイル名称2');
				$this->Qdmail-> attach ( $attach );
			}else{
				$this->set('error_message', "添付ファイルが無い");
debug($file);
debug("添付ファイルが無い");
exit();
			}
 		}
		
		$return_flag = $this->Qdmail->send();
		//debug($return_flag);

		if(!$return_flag){
			$this->set('error_message', "メール送信エラー");
debug("メール送信エラー");
			//return false;
		}
		
		if( $id > 0 ){
			$this->Purchase->id = $id;
			$this->Purchase->saveField('AppMailed', $data['Purchase']['AppMailed'] + 1);
		}else{
			$this->set('error_message', "IDエラー");
debug("メール送信エラー");
		
		}
//exit();
		//$this->redirect(array('controller'=>'purchase','action'=>'search'));
	}

	function html_mail_body($data, $from, $name_from){

		$mailbody = "\r\n登録者：".$name_from."<".$from.">\r\n\r\n";
	
		$mailbody .= "ID= ".$data['id']."\r\n";
		$mailbody .= "登録日= ".$data['ApplicationDate']."\r\n";
		$mailbody .= "登録者= ".$data['Applicant']."\r\n";
		$mailbody .= "承認日= ".$data['ApprovalDate']."\r\n";
		$mailbody .= "材料使用日= ".$data['OrderDate']."\r\n";
		$mailbody .= "発注者= ".$data['OrderName']."\r\n";
		$mailbody .= "発注分類= ".$data['OrderNo']."\r\n";
		$mailbody .= "発注先= ".$data['Supplier']."\r\n";
		$mailbody .= "請求先= ".$data['SupplierName']."\r\n";
		$mailbody .= "件名= ".mb_convert_kana($data['Subject'],'K','utf-8')."\r\n";
		$mailbody .= "納期= ".$data['DeliveryTime']."\r\n";
		$mailbody .= "支払方法= ".$data['PaymentTerms']."\r\n";
		$mailbody .= "見積書No= ".$data['EstimateNo']."\r\n";
		$mailbody .= "品名= ".mb_convert_kana($data['ProductName'],'K','utf-8')."\r\n";
		$mailbody .= "型番= ".mb_convert_kana($data['ModelNo'],'K','utf-8')."\r\n";
		$mailbody .= "コード= ".mb_convert_kana($data['ProductCode'],'K','utf-8')."\r\n";
		
		$mailbody .= "数量= ".$this->Common->number_format2( $data['Qty'] )."\r\n";
		$mailbody .= "単価= ".$this->Common->number_format2( $data['UnitPrice'] )."\r\n";
		$mailbody .= "金額= ".$this->Common->number_format2( $data['Amount'] )."\r\n";
		
		$mailbody .= "小計= ".number_format( $data['SubTotal'] )."\r\n";
		$mailbody .= "税金= ".number_format( $data['Tax'] )."\r\n";
		$mailbody .= "合計金額= ".number_format( $data['Total'] )."\r\n";
		$mailbody .= "備考= ".$data['Note']."\r\n";
		if( $data['Attachment'] <> "" ){
			$mailbody .= "添付= ".$data['Attachment']."\r\n";
		}else{
			$mailbody .= "添付= なし"."\r\n";
		}
		$mailbody .= "\r\n";

		$mailbody .= "承認のリンク：".$this->URL_SELF."appmail/yes/".$data['id']."\r\n\r\n";
		$mailbody .= "否認のリンク：".$this->URL_SELF."appmail/no/".$data['id']."\r\n";
		$mailbody .= "\r\n";
//debug($mailbody);
//exit();
		return $mailbody;
	}


	function search_export(){
		$year = $this->Common->getPost($this, 'Purchase', 'ExportDateY');
		if($year == "")
			$year = "2021";
		// 月を指定
		$month = $this->Common->getPost($this, 'Purchase', 'ExportDateM');
		if($month == "")
			$month = '04';
		$first_date = date('Y-m-d', strtotime('first day of ' . $year."-".$month));
//debug($first_date);
		$week_num = date("w", strtotime($first_date));
//debug($week_num);
		if ($week_num == 0){
			//日曜日だった場合
  			$monday1 = date('Y/m/d', strtotime("-6 day", strtotime($first_date)));
		}else{
  			$monday1 = date('Y/m/d', strtotime("-{$week_num} day", strtotime($first_date) + 24*60*60));
		}
//debug($monday1);
//exit();
		$last_date = date('Y-m-d', strtotime('last day of ' . $year."-".$month));
//debug("指定月の初日：" . $first_date);
//debug("指定月の末日：" . $last_date);

		App::import('Helper', 'Html');
        $html = new HtmlHelper();

		$excel_file0 = "purchase.xls";
		$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/purchase/ORG/".$excel_file0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$excel_file = date("YmdHis")."_".$excel_file0;
		$excel_file = date("Ym", strtotime($first_date))."_".$excel_file0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/purchase/".$excel_file);
		//$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/purchase/20210516_".$excel_file0);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);

		/** PHPExcelを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		// PHPExcelオブジェクトを生成する
		//$obj = PHPExcel_IOFactory::createReader("Excel2007");
		//$obj = PHPExcel_IOFactory::createReader($book, 'Excel5');
		//$book = $obj->load($xcellFile);

		//$book = new PHPExcel();
		$book = PHPExcel_IOFactory::load($xcellFile);

		$data = $this->Purchase->find('all', array('conditions' => array( 'ApplicationDate BETWEEN ? AND ?' => array($first_date, $last_date)), 
					'order' => ['ApplicationDate'=>'asc', 'id'=>'asc'] ));
		
		//$sql = "SELECT * FROM `purchase` WHERE `ApplicationDate` BETWEEN '".$first_date."' and '".$last_date."' ORDER BY `ApplicationDate` asc, `deploy_name` asc, CAST(replace(site_time1, ':', '') AS UNSIGNED) asc, `id` asc ";
		//$data = $this->Purchase->query($sql);

//$log = $this->Purchase->getDataSource()->getLog(false, false);       
//debug($log);
		$data_count = count($data);
//debug($data_count);
//debug($data);
//exit();

		$sh=0;
		//for($sh=0; $sh<5; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<$data_count; $i++){
				// セルに値をセットする
				$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 1, $i + 2,  $data[$i]['Purchase']['id']);
				$sheet->setCellValueByColumnAndRow( 2, $i + 2,  $data[$i]['Purchase']['ApplicationDate']);
				$sheet->setCellValueByColumnAndRow( 3, $i + 2,  $data[$i]['Purchase']['Applicant']);
				$sheet->setCellValueByColumnAndRow( 4, $i + 2,  $data[$i]['Purchase']['ApprovalDate']);
				
				$Approval = $data[$i]['Purchase']['Approval'];
				if($Approval == 1){
					$sheet->setCellValueByColumnAndRow( 5, $i + 2,  "承認");
				}elseif($Approval == 0){
					$sheet->setCellValueByColumnAndRow( 5, $i + 2,  "否認");
					//$sheet->getStyleByColumnAndRow( 5, $i + 2)->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_RED);
					$sheet->getStyleByColumnAndRow( 5, $i + 2)->getFont()->getColor()->setARGB('FF0000'); 
				}else{
					$sheet->setCellValueByColumnAndRow( 5, $i + 2,  "未承認");
					//$sheet->getStyleByColumnAndRow( 5, $i + 2)->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_GREEN);
					$sheet->getStyleByColumnAndRow( 5, $i + 2)->getFont()->getColor()->setARGB('00FF00'); 
				}

				$sheet->setCellValueByColumnAndRow( 6, $i + 2,  $data[$i]['Purchase']['OrderDate']);
				$sheet->setCellValueByColumnAndRow( 7, $i + 2,  $data[$i]['Purchase']['OrderName']);
				$sheet->setCellValueByColumnAndRow( 8, $i + 2,  $data[$i]['Purchase']['OrderNo']);
				$sheet->setCellValueByColumnAndRow( 9, $i + 2,  $data[$i]['Purchase']['Supplier']);
				$sheet->setCellValueByColumnAndRow( 10, $i + 2,  $data[$i]['Purchase']['SupplierName']);
				$sheet->setCellValueByColumnAndRow( 11, $i + 2,  mb_convert_kana($data[$i]['Purchase']['Subject'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 12, $i + 2,  $data[$i]['Purchase']['DeliveryTime']);
				$sheet->setCellValueByColumnAndRow( 13, $i + 2,  $data[$i]['Purchase']['PaymentTerms']);
				$sheet->setCellValueByColumnAndRow( 14, $i + 2,  $data[$i]['Purchase']['EstimateNo']);
				$sheet->setCellValueByColumnAndRow( 15, $i + 2,  mb_convert_kana($data[$i]['Purchase']['ProductName'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 16, $i + 2,  mb_convert_kana($data[$i]['Purchase']['ModelNo'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 17, $i + 2,  mb_convert_kana($data[$i]['Purchase']['ProductCode'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 18, $i + 2,  $data[$i]['Purchase']['Qty']);
				$sheet->setCellValueByColumnAndRow( 19, $i + 2,  $data[$i]['Purchase']['UnitPrice']);
				$sheet->setCellValueByColumnAndRow( 20, $i + 2,  $data[$i]['Purchase']['Amount']);
				$sheet->setCellValueByColumnAndRow( 21, $i + 2,  $data[$i]['Purchase']['SubTotal']);
				$sheet->setCellValueByColumnAndRow( 22, $i + 2,  $data[$i]['Purchase']['Tax']);
				$sheet->setCellValueByColumnAndRow( 23, $i + 2,  $data[$i]['Purchase']['Total']);
				$sheet->setCellValueByColumnAndRow( 24, $i + 2,  $data[$i]['Purchase']['Note']);
//break;
			}
			//-----------------------------------------------
		
		//}//endfor $sh
		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($book, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel5');
		$writer->save($xcellFile);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		//exit();
	
		$this->redirect(array('controller'=>'purchase','action'=>'search'));
	}
	


	/* =================== 発注書詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'purchase','action'=>'index'));
		}

		$this->set('main_title', '発注書');
		$this->set('sub_title', '発注書　＞　詳細');
		$this->set('sub_title2', '見積書　＞　詳細');

		if($arg){
			$this->Purchase->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Purchase->id = $this->Common->getPost($this, 'Purchase', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Purchase->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
			$this->set('data2', $this->data2);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->Purchase->find('count', array('conditions' => array('category LIKE' => $this->data['Purchase']['category'],
																		'id !=' => $this->Purchase->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "データが既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'Purchase', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			if(false){
				if(!$this->Purchase->save($this->data)){		//更新
					$errors = $this->Purchase->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'purchase','action'=>'search'));
				}
			}
		}
		$this->set('category', $user0['User']['category']);
	}

	
	function download($arg=""){
		$this->set('main_title', "ダウンロード");
		$this->set('sub_title',  '');
		
		if($arg){
			$this->Purchase->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Quotation->id = $this->Purchase->id = $this->Common->getPost($this, 'Purchase', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Purchase->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
			$this->xlsx_write_proc();
		}else{
		
		}
//debug($up_file);
		$this->set('data', $this->data);
	}

	function xlsx_write_proc(){
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/purchase/excel/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/purchase/excel/" );
		//$filename = "purchase_form.xlsx";
		$filename = "purchase_form.xls";

		$excel_file = $path.$filename;
		if(file_exists($excel_file))
			unlink($excel_file);
		copy($path0.$filename, $excel_file);
		
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** IO Class */
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );
//print_r($this->data); echo "<br>";
        //App::import('vendor','phpexcel/phpexcel');

        //ファイルを読み込む
        //$objReader = PHPExcel_IOFactory::createReader('Excel2007');
		$objReader = PHPExcel_IOFactory::createReader('Excel5');

        $objPHPExcel = $objReader->load($excel_file);
		$objPHPExcel->setActiveSheetIndex(0);
		
        $sheet = $objPHPExcel->getActiveSheet();
        //$sheet->setCellValueByColumnAndRow($c, $r+1, $v);

		$sheet->setCellValue('B6', $this->data2['Quotation']['dest_up']);
		$sheet->setCellValue('B7', $this->data2['Quotation']['dest_low']);
		$sheet->setCellValue('M7', $this->data2['Quotation']['address']);

		$sheet->setCellValue('B14', $this->data2['Quotation']['OrderNo_up']);
		$sheet->setCellValue('B17', $this->data2['Quotation']['OrderNo_mid']);
		$sheet->setCellValue('B20', $this->data2['Quotation']['OrderNo_low']);
		
		$sheet->setCellValue('V2', $this->data2['Quotation']['EstimateNo']);
		$sheet->setCellValue('Q6', date('Y年m月d日', strtotime($this->data['Purchase']['DeliveryTime'])));
		$sheet->setCellValue('R26', $this->data2['Quotation']['OrderNo']);
		
		$sheet->setCellValue('M28', $this->data2['Quotation']['Total_Amount']);
		
		$a = explode("/", $this->data2['Quotation']['ProductName']);
		$b = explode("/", $this->data2['Quotation']['quantity']);
		$c = explode("/", $this->data2['Quotation']['Qty_assist']);
		$d = explode("/", $this->data2['Quotation']['price']);
		$e = explode("/", $this->data2['Quotation']['Amount_line']);
		$f = explode("/", $this->data2['Quotation']['remark']);

//debug(count($a));
		if(count($a) >= 12)
			$n = 11;
		else
			$n = count($a);

		for($i=0; $i<$n; $i++){
			if(trim($a[$i].$b[$i].$c[$i].$d[$i].$e[$i]) != ""){
	        	$sheet->setCellValueByColumnAndRow(2, 34+$i, $this->zero_check( $a[$i] )); //C24
	        	$sheet->setCellValueByColumnAndRow(9, 34+$i, $this->zero_check( $b[$i] )); //J24
	        	$sheet->setCellValueByColumnAndRow(11, 34+$i, $this->zero_check( $c[$i] )); //L24
	        	$sheet->setCellValueByColumnAndRow(13, 34+$i, $this->zero_check( $d[$i] )); //N24
	        	$sheet->setCellValueByColumnAndRow(16, 34+$i, $this->zero_check( $e[$i] )); //Q24
	        	$sheet->setCellValueByColumnAndRow(20, 34+$i, $this->zero_check( $f[$i] )); //U24
			}
		}
		
		$sheet->setCellValue('I47', $this->zero_check($this->data2['Quotation']['labor_cost']));
		$sheet->setCellValue('I48', $this->zero_check($this->data2['Quotation']['other_expense']));
		$sheet->setCellValue('I43', $this->zero_check($this->data2['Quotation']['discount']));

		$sheet->setCellValue('S47', $this->zero_check($this->data2['Quotation']['subTotal']));
		$sheet->setCellValue('S48', $this->zero_check($this->data2['Quotation']['Tax_calc_frame']));
		$sheet->setCellValue('S49', $this->zero_check($this->data2['Quotation']['Total_Amount']));

		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel5");
		$writer->save($excel_file);

//debug($this->data['Quotation']['dest_up']);
//debug($this->data['Quotation']['dest_low']);
		//$excel_file = $this->ConvPath( WWW_ROOT."files/quotation_form.xlsx" );
		
		$filename = $this->data2['Quotation']['dest_low'];
		if($filename == "")
			$filename = $this->data2['Quotation']['dest_up'];
		//$filename = date("Ymd_", strtotime($this->data2['Quotation']['estimate_date'])) . $filename . "_見積書.xlsx";
		$filename = date("Ymd_", strtotime($this->data2['Quotation']['estimate_date'])) . $filename . "_見積書.xls";
		// $this->Common->to_utf8();
		Configure::write('debug', 0);       // debugコードを非表示
		header("Content-disposition: attachment; filename={$filename}");    //ダウンロードさせるため
		header("Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; name={$filename}");
 
		$result = file_get_contents( $excel_file );   // ダウンロードするデータの取得
		print( $result );           // 出力
 //exit();
		return $filename;
	}

	function zero_check($n){
		if($n == "")
			return "";
		elseif(is_numeric($n))
			return number_format(intval( $n ));
		else
			return $n;
	}
	

	public function upload(){
		$id = $this->Common->getPost($this, 'Purchase', 'id');
		if(isset($_POST['submit']) and ($id > 0)){
    		if(isset($_FILES['uploadFile']['name']) && $_FILES['uploadFile']['name'] != "") {
        		$allowedExtensions = array("pdf", "jpg", "xls", "xlsx");
        		$ext = pathinfo($_FILES['uploadFile']['name'], PATHINFO_EXTENSION);
//debug($ext);		
				if(in_array($ext, $allowedExtensions)) {
					// Uploaded file
					$upfile = $id."_".$_FILES['uploadFile']['name'];
       				if(strstr($_SERVER['SCRIPT_URI'], "p5.yoshikura.com/"))
						$file = WWW_ROOT."files/purchase/upload/".$upfile;
					else
						$file = WWW_ROOT."files/purchase/upload/".$this->Common->to_sjis( $upfile );
					if(file_exists($file))
						unlink($file);
           			$isUploaded = copy($_FILES['uploadFile']['tmp_name'], $file);
		   			// check uploaded file
   	       			if($isUploaded) {
						$this->Purchase->id = $id;
						$this->Purchase->saveField('Attachment', $upfile);
//debug($file);
//debug($id);
//exit();
						$this->redirect(array('controller'=>'purchase','action'=>'search_edit', $id));
					}else{
	                    echo '<span class="msg">File not uploaded!</span>';
						debug($ext);
						exit();
					}
                } else {
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                }
        	} else {
            	echo '<span class="msg">Please upload excel sheet1.</span>';
				exit();
        	}
    	} else {
        	echo '<span class="msg">Please upload excel file2.</span>';
			exit();
    	}
	}
	
	public function attach_delete($id=0){
		if($id == 0)
			$id = $this->Common->getPost($this, 'Purchase', 'id');
		if($id > 0){
			$this->Purchase->id = $id;
			$this->Purchase->saveField('Attachment', "");
			$this->redirect(array('controller'=>'purchase','action'=>'search_edit', $id));
        } else {
            echo '<span class="msg">IDがない!</span>';
			exit();
		}
	}

}