<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/Inventory/

class InventoryController extends AppController {
	public $name = 'Inventory';
	public $uses = array('User', 'Inventory', 'Quotation', 'Logs', 'Delicom2');
	public $layout = 'dafault';

	public $components = array('Auth', 'Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'
	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;
	private $debug = false;

    function beforeFilter() {
	//	define("Classes", $_SERVER["DOCUMENT_ROOT"]."/cakephp/class/");
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");
		
		if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
		}

		$this->set('main_title', "棚卸明細");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Inventory
		$this->set('URL_SELF', $this->URL_SELF);

		//$username = $this->Auth->user('username');
		//$this->set('username', $username);
		
		//$username = $this->Inventory->field('User', array('username' => $username));
		//$this->set('username', $username);
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['User']['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->Inventory->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/inventory_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'inventory','action'=>'search'));
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "棚卸明細",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "棚卸明細";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}



	/* =================== 　棚卸明細検索　 ======================= */
	public function search($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'inventory','action'=>'index'));
		}
		$this->set('main_title', '棚卸明細(検索)');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Inventory', 'search');
		$id = $this->Common->getPost($this, 'Inventory', 'id');
		$product_name2 = $this->Common->getPost($this, 'Inventory', 'product_name2');
		
		$manufacturer = $this->Common->getPost($this, 'Inventory', 'manufacturer');

		$product_name = $this->Common->getPost($this, 'Inventory', 'product_name');
		$product_no = $this->Common->getPost($this, 'Inventory', 'product_no');

		$partition = $this->Common->getPost($this, 'Inventory', 'partition');

		$note = $this->Common->getPost($this, 'Inventory', 'note');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Inventory', 'page');
		$direction = $this->Common->getPost($this, 'Inventory', 'direction');
		$sort = $this->Common->getPost($this, 'Inventory', 'sort');

		$submit = $this->Common->getPost($this, 'Inventory', 'submit');
		if(strstr($submit, "検索クリア")){
			$id="";
			$this->set('id', $id);
			$product_name2="";
			$this->set('product_name2', $product_name2);
			$manufacturer = "";
			$this->set('manufacturer', $manufacturer);
			$product_name = "";
			$this->set('product_name', $product_name);
			$product_no = "";
			$this->set('product_no', $product_no);
		}



		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($manufacturer)
			$condition = array_merge_recursive($condition, array( "manufacturer" => $manufacturer ));

		if($product_name2){
			$condition = array_merge_recursive($condition, array( 
				'OR' => array(
            		array( 'product_name like' => '%'.$product_name2.'%'),
            		array( 'product_no   like' => '%'.$product_name2.'%'),
        		),
			));
		}

	//------------------------------
		if($product_name)
			$condition = array_merge_recursive($condition, array( "product_name like" => '%'.$product_name.'%'));
		if($product_no)
			$condition = array_merge_recursive($condition, array( "product_no" => $product_no ));

	//------------------------------
		if($partition)
			$condition = array_merge_recursive($condition, array( "partition like" => $partition));
	//------------------------------

		if($note)
			$condition = array_merge_recursive($condition, array( "note like" => '%'.$note.'%'));

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "manufacturer" => urlencode($manufacturer),
				     "product_name" => urlencode($product_name),
				     "product_no" => urlencode($product_no),
				     "partition" => urlencode($partition),
				     "note" => urlencode($note),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Inventory' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Inventory');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['User']['category']);
		$this->set('user_id', $user0['User']['id']);
		$this->set('login_user', $user0['User']);
		$this->set('ExportDateY', date("Y"));
		$this->set('ExportDateM', date("m"));

		if(($sort == null) or ($sort == "")){	// 初期ダウンロードのsort設定
			if(!$search)
				$this->redirect(array('controller'=>'inventory','action'=>'search', 'page:1/direction:asc/sort:id'));
		}
	}




}