<?php
class CronController extends AppController {

//	http://vps.waa.jp/schedule/cron/
//	wget 'http://vps.waa.jp/schedule/cron/' -O -

	public $name = 'Cron';

	public $layout = null;
	//public $layout = 'dafault';

	//public $autoRender = false;	// View Off

	public $uses = array('Schedule');

	//public $components = array('Common', 'Mail', 'Email', 'Excel');	//'Session', , 'Qdmail'
	public $components = array('Common', 'Qdmail', 'Excel');	//'Session', , 'Mail', 'Email'

	public $helpers = array('Common', 'Html', 'Form', 'Calender', 'Holiday');	//'Javascript', , 'Tabular'

	public $URL_SELF;

    function beforeFilter() {
	//	$this->autoRender = false;     // Viewを使わない
	//	Configure::write('debug', 0);  // debugコードを出さない
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

		$this->set('main_title', "スケジュール");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/schedule
		$this->set('URL_SELF', $this->URL_SELF);
	}

	public function index(){
		$this->redirect(array('controller'=>'cron','action'=>'mail_send'));
	}


	public function mail_send() {
		$this->set('main_title', "メール送信");
		$this->set('sub_title',  '');
		$this->set('send_mail', "送信メールがありません。1");
		
		$dt1 = mktime(date("H"), date("i")-5, date("s"), date("m"), date("d")+1, date("Y"));
		$dt2 = mktime(date("H"), date("i")+30, date("s"), date("m"), date("d")+1, date("Y"));
		$conditions = array(		//date("Y-m-d H:i:s");
				'year' => date("Y", $dt1),
				'month' => date("m", $dt1),
				'day' => date("d", $dt1),
				"from_time BETWEEN ? AND ?" => array( date("H:i:s", $dt1), date("H:i:s", $dt2) ),
				'mailed' => null
			);
		$data = $this->Schedule->find('all', array('conditions' => $conditions, 'order' => array('from_time ASC')));	//DESC
//debug(date("Y-m-d H:i:s"));
//debug(date("Y-m-d H:i:s", $dt1));
//debug(date("Y-m-d H:i:s", $dt2));
//debug($conditions);
//debug($data);
		for($i=0; $i<$this->Schedule->getNumRows(); $i++){
			$year = $data[$i]['Schedule']['year'];
			$month = $data[$i]['Schedule']['month'];
			$day = $data[$i]['Schedule']['day'];
			$from_time = substr($data[$i]['Schedule']['from_time'], 0, 5);
			$to_time = substr($data[$i]['Schedule']['to_time'], 0, 5);
			$title = $data[$i]['Schedule']['title'];
			$member = $data[$i]['Schedule']['member'];
			$mail = $data[$i]['Schedule']['mail'];
			$place = $data[$i]['Schedule']['place'];
			$message = $data[$i]['Schedule']['message'];
			
			$body = "件名：".$title."\n\n";

			$week = $this->Common->conv_week($year, $month, $day);
			$body .= sprintf("日時：%d年%d月%d日(%s) %s～%s\n\n", $year, $month, $day, $week, $from_time, $to_time);

			$body .= "場所：".$place."\n\n";
			$body .= "メンバー：".$member."\n\n";
			$body .= "※出席できない方は、info@sanbangai.net　までご連絡下さい。\n\n";
			$body .= "※".$message."\n\n";
//debug($body);
			$subject = $title."のお知らせ";
			if($this->send_mail($mail, $subject, $body)){
				$this->Schedule->set('id', $data[$i]['Schedule']['id']);
				$this->Schedule->saveField("mailed", date("Y-m-d H:i:s"));
			}
		}

	}


	function send_mail($to, $subject, $mailbody){
		//$from = "yoshikura3@gmail.com";
		//$from = "jichikai@sanbangai.net";
		
		$from = "yoji@yoshikura.com";
		$name_from = "自治会カレンダー";

		//$name_from .= "<".$from.">";

		$this->set('send_mail', nl2br($to."\n------------------\n".$subject."\n-----------------\n".$mailbody."\n-----------------\n"));

		//$this->Qdmail->debug = $debug;
		$param = array(
		    'host' => 'smtp.yoshikura.com',	//メールサーバー
		    'port' => 587,					//これはSMTPAuthの例。認証が必要ないなら　25　でＯＫ。
			'from' => 'yoji@yoshikura.com',	//　Return-path: になります。
			'protocol' => 'SMTP_AUTH',		// 認証が必要ないなら、'SMTP'
		    'user' => 'yoji@yoshikura.com',	//SMTPサーバーのユーザーID
		    'pass' => 'kayoken2'			//SMTPサーバーの認証パスワード
		);
		$this->Qdmail->smtpServer($param);
		$this->Qdmail->to( $to, '自治会ML' );
		$this->Qdmail->subject($subject);
		$this->Qdmail->from($from, '自治会カレンダー' );
		$this->Qdmail->text( $mailbody );
		$return_flag = $this->Qdmail -> send();
		//debug($return_flag);

		if(!$return_flag){
			$this->set('error_message', "メール送信エラー");
			//return false;
		}else{
			$this->set('error_message', "メール送信完了");
			//return true;
		}

	}
	

}	// end of class
