<?php
//	REF:http://www.webdesignersblog.jp/archives/2010/02/10192251.php

class CommonComponent extends Object
{

	function number_format2($n){
		$a = explode("|", $n);
		$b = array();
		for($i=0; $i<count($a); $i++){
			$b[$i] = number_format( $a[$i] );
		}
		return implode("|", $b);
	}

	function mb_str_replace($search, $replace, $haystack, $encoding="UTF-8")
	{
    	// 検索先は配列か？
    	$notArray = !is_array($haystack) ? TRUE : FALSE;
    	// コンバート
    	$haystack = $notArray ? array($haystack) : $haystack;
    	// 検索文字列の文字数取得
    	$search_len = mb_strlen($search, $encoding);
    	// 置換文字列の文字数取得
	    $replace_len = mb_strlen($replace, $encoding);

    	foreach ($haystack as $i => $hay){
	        // マッチング
        	$offset = mb_strpos($hay, $search);
    	    // 一致した場合
	        while ($offset !== FALSE){
            	// 差替え処理
            	$hay = mb_substr($hay, 0, $offset).$replace.mb_substr($hay, $offset + $search_len);
            	$offset = mb_strpos($hay, $search, $offset + $replace_len);
        	}
        	$haystack[$i] = $hay;
    	}
    	return $notArray ? $haystack[0] : $haystack;
	}



	function GetCarUserName($car_plate){
		switch( $car_plate ){
			case '多摩483の119':
				return( "林" );
			case '多摩483て119':
				return( "岡島" );
			case '多摩483ひ119':
				return( "篠原・唐沢" );
			case '多摩483と119':
				return( "勝将" );
			case '多摩340め119':
				return( "中西" );
			case '多摩431ま119':
				return( "西田" );
			case '多摩431の119':
				return( "興津・五十嵐" );
			case '多摩431て119':
				return( "田中" );
			case '多摩431も119':
				return( "人見" );
			case '多摩483る119':
				return( "新井" );
			case '多摩431な119':
				return( "櫻内" );
			case '多摩431む119':
				return( "植木" );

			case '多摩330や6667':
				return( "社長" );
			case '多摩480せ2180':
				return( "社長" );
			case '多摩330ら6667':
				return( "社長" );
			case '多摩530ひ6667':
				return( "社長" );
			case '多摩330る6667':
				return( "社長" );

			default:
				echo "Unkown: ".$car_plate."<br>";
				exit();
				return( "社長" );
			break;
		}
	}
	
	
	function CheckUserAuth($auth){
		$model = ClassRegistry::getObject('User');
		$model->id = $auth->user("id");
		$model->read();
//debug($model->id);
//debug($model);
//debug($model->data["User"]["one_time_key"]);
//debug($model->data["User"]["one_time_key2"]);
//debug($model->data["User"]["received"]);
		$diff_hours = (time() - strtotime($model->data["User"]["received"])) / 3600;
//debug($diff_hours);
		if(($model->data["User"]["one_time_key"] == $model->data["User"]["one_time_key2"]) AND ($diff_hours < 10)){
			//debug("時間内");
			return true;
		}else{
			$model->id = $auth->user("id");
			$model->saveField("one_time_key2", "0000-00-00");
			//debug("時間切れ");
			return false;
		}
	}


	function GetDetail($detail){
		$model = ClassRegistry::getObject('Workreport');
		$ret = $model->find('all', array('conditions' => array($field.' <>' => ""), 'order' => array($field => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Workreport'][$field];
		}
		return $names;
	
	}


	function GetPhotoName($page, $no){
		$dir = $this->ConvPath( WWW_ROOT."files/workreport/jpg/" );	//D:\xampp\htdocs\inabou\app\webroot\files\workreport\jpg
		// 既知のディレクトリをオープンし、その内容を読み込みます。
		if (is_dir($dir)) {
    		if ($dh = opendir($dir)) {
				$s = "";
        		while (($file = readdir($dh)) !== false) {
					if(strstr($file, ".jpg") or strstr($file, ".JPG")){	//1_1_20200722_131335.jpg
						if(strstr($file, $page."_".$no."_"))
		            		$s = $file;	// : filetype: " . filetype($dir . $file) . "\n";
					}
        		}
	        	closedir($dh);
    		}
		}
		return $s;
	}

	function str_fold($s){	//9:00,11:00,13:00,15:00,16:30
		$a = explode(",", $s);
		$n = count($a);
		if($n >= 3){
			$buf = "";
			for($i=0; $i<$n; $i++){
				if($i != 0)
					$buf = $buf . ",";
				if(($i == 2) or ($i == 4))
					$buf = $buf . "\n<br>";

				$buf = $buf . $a[$i];
			}
		}else{
			$buf = $s;
		}
		return $buf;
	}

	function str_fold2($s, $ret=10){	//シルビアPARTⅡ,コーポシルビア,松本自動車（サングレース）
		$n = mb_strlen($s);
		if($n >= $ret){
			$buf = mb_substr($s, 1, $ret) . "\n<br>";
			if(($n - $ret) >= $ret){
				$buf = $buf . mb_substr($s, $ret, $ret) . "\n<br>";
				if(($n - $ret+2) >= $ret){
					$buf = $buf . mb_substr($s, $ret+2, $ret) . "\n<br>";
				}else{
					$buf = $buf . mb_substr($s, $ret+2);
				}
			}else{
				$buf = $buf . mb_substr($s, $ret);
			}
		}else{
			$buf = $s;
		}
		return $buf;
	}

	function mbTrim($pString){
	    return preg_replace('/\A[\p{C}\p{Z}]++|[\p{C}\p{Z}]++\z/u', '', $pString);
	}



	function GetModelAll($table, $field){		//万能タイプ
		$model = ClassRegistry::getObject($table); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('DISTINCT '.$field), 'conditions' => array($field.' <>' => ""), 'order' => array($field => 'asc')));
		$count = count($ret);
//debug($count);
		if($count==0){
			return array();
		}
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i][$table][$field];
		}
		return $names;
	}



	function GetUserAll($field){
		$model = ClassRegistry::getObject('User'); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('DISTINCT '.$field), 'conditions' => array($field.' <>' => ""), 'order' => array($field => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['User'][$field];
		}
		return $names;
	}

	function GetUser2All(){
		$model = ClassRegistry::getObject('User'); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('name1', 'name2'), 'conditions' => array('division >' => 0), 'order' => array('id' => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['User']['name1']. " " . $ret[$i]['User']['name2'];
		}
		return $names;
	}

	function GetUser3All($division=0){
		$model = ClassRegistry::getObject('User'); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('name1', 'name2', 'initial'), 
				'conditions' => array('division' => array($division, 3)), 
				'order' => array('id' => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[0][$i] = $ret[$i]['User']['name1']. " " . $ret[$i]['User']['name2'];
			$names[1][$i] = $ret[$i]['User']['initial'];
		}
		return $names;
	}


	function GetScheduleAll($field){
		$model = ClassRegistry::getObject('Schedule'); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('DISTINCT '.$field), 'conditions' => array($field.' <>' => ""), 'order' => array($field => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Schedule'][$field];
		}
		return $names;
	}

	function GetLogsAll($field){
		$model = ClassRegistry::getObject('Logs'); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('DISTINCT '.$field), 'conditions' => array($field.' <>' => ""), 'order' => array($field => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Logs'][$field];
		}
		return $names;
	}

	function GetInvoiceAll($field){
		$model = ClassRegistry::getObject('Invoice'); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('DISTINCT '.$field), 'conditions' => array($field.' <>' => ""), 'order' => array($field => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Invoice'][$field];
		}
		return $names;
	}

	function GetPurchaseAll($field){
		$model = ClassRegistry::getObject('Purchase'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT '.$field), 'conditions' => array($field.' <>' => ""), 'order' => array($field => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Purchase'][$field];
		}
		return $names;
	}

	function GetQuotationAll($field){
		$model = ClassRegistry::getObject('Quotation'); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		if($field == "responsible")
			$ret = $model->find('all', array('fields' => array('DISTINCT responsible'), 'conditions' => array('responsible <>' => ""), 'order' => array('responsible' => 'asc')));
		elseif($field == "dest_up")
			$ret = $model->find('all', array('fields' => array('DISTINCT dest_up'), 'conditions' => array('dest_up <>' => ""), 'order' => array('dest_up' => 'asc')));
		else
			$ret = $model->find('all', array('fields' => array('DISTINCT '.$field), 'conditions' => array($field.' <>' => ""), 'order' => array($field => 'asc')));
		
		$count = count($ret);
		if($count==0){
			return array();
		}
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Quotation'][$field];
		}
		return $names;
	}

	function GetLogsDateY(){
		$model = ClassRegistry::getObject('Logs'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT YEAR(accessed) as years'), 'conditions' => array('accessed >' => '0000-00-00'), 'order' => array('accessed' => 'asc')));
//print_r($ret);
		$count = count($ret);
		if($count==0){
			return array();
		}
		for($i=0; $i<$count; $i++){
			$years[$i] = $ret[$i][0]['years'];
		}
		//$years[$i + 1] = "0000-00-00"
//print_r($years);
		return $years;		//2019-08-07  2022-04-01
	}

	function GetScheduleDateY(){
		$model = ClassRegistry::getObject('Schedule'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT YEAR(site_date) as years'), 'conditions' => array('site_date >' => '0000-00-00'), 'order' => array('site_date' => 'asc')));
//print_r($ret);
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$years[$i] = $ret[$i][0]['years'];
		}
		//$years[$i + 1] = "0000-00-00"
//print_r($years);
		return $years;		//2019-08-07  2022-04-01
	}
	
	
	function GetOrderDateY(){
		$model = ClassRegistry::getObject('Invoice'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT YEAR(order_date) as years'), 'conditions' => array('order_date >' => '0000-00-00'), 'order' => array('order_date' => 'asc')));
//print_r($ret);
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$years[$i] = $ret[$i][0]['years'];
		}
		//$years[$i + 1] = "0000-00-00"
//print_r($years);
		return $years;		//2019-08-07  2022-04-01
	}



	function GetDeliveryDateY(){
		$model = ClassRegistry::getObject('Invoice'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT YEAR(delivery_date) as years'), 'conditions' => array('delivery_date >' => '0000-00-00'), 'delivery' => array('delivery_date' => 'asc')));
//print_r($ret);
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$years[$i] = $ret[$i][0]['years'];
		}
		//$years[$i + 1] = "0000-00-00"
//print_r($years);
		return $years;		//2019-08-07  2022-04-01
	}




	function GetInvoiceDateY(){
		$model = ClassRegistry::getObject('Invoice'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT YEAR(invoice_date) as years'), 'conditions' => array('invoice_date >' => '0000-00-00'), 'order' => array('invoice_date' => 'asc')));
//print_r($ret);
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$years[$i] = $ret[$i][0]['years'];
		}
		//$years[$i + 1] = "0000-00-00"
//print_r($years);
		return $years;		//2019-08-07  2022-04-01
	}

	function GetEstimateDateY(){
		$model = ClassRegistry::getObject('Quotation'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT YEAR(estimate_date) as years'), 'conditions' => array('estimate_date >' => '0000-00-00'), 'order' => array('estimate_date' => 'asc')));
//print_r($ret);
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$years[$i] = $ret[$i][0]['years'];
		}
		//$years[$i + 1] = "0000-00-00"
//print_r($years);
		return $years;		//2019-08-07  2022-04-01
	}

	function GetLastDay($DeliDateY, $DeliDateM){
		$month = $DeliDateY."-".$DeliDateM;
		// $firstDate = date('Y-m-d', strtotime('first day of ' . $month));
		// $lastDate = date('Y-m-d', strtotime('last day of ' . $month));
		$lastDay = date('d', strtotime('last day of ' . $month));
		return $lastDay + 1;
	}

	function GetDeliDateY(){
		$model = ClassRegistry::getObject('Delidoc'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT YEAR(DeliDate) as years'), 'conditions' => array('DeliDate >' => '0000-00-00'), 'order' => array('DeliDate' => 'asc')));
//print_r($ret);
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$years[$i] = $ret[$i][0]['years'];
		}
		//$years[$i + 1] = "0000-00-00"
//print_r($years);
		return $years;		//2019-08-07  2022-04-01
	}

	function GetProduct($ProductID){
		$model = ClassRegistry::getObject('Product'); 
		$ret = $model->find('all', array('fields' => array('*'), 'conditions' => array('ID' => $ProductID)));
//print_r($ret);
		return $ret;
	}

	function GetDeliTable($DelidocID){
		$model = ClassRegistry::getObject('Delitable'); 
		$ret = $model->find('all', array('fields' => array('*'), 'conditions' => array('DeliDocID' => $DelidocID), 'order' => array('ProductID' => 'asc')));
//print_r($ret);
		return $ret;
	}

	function DeliDocNote(){
		$model = ClassRegistry::getObject('Delidoc'); 
		$ret = $model->find('all', array('fields' => array('DISTINCT Note'), 'conditions' => array('Note <>' => ""), 'order' => array('Note' => 'asc')));
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Delidoc']['Note'];
		}
		return $names;
	}

	function GetQty( $ProductID ){
		$model = ClassRegistry::getObject('Delitable'); 
		if($ProductID == 0)
			return "";
		//$sql = "SELECT sum(`Qty`) as qty FROM `delitable` WHERE `ProductID`=".$ProductID;
		//$ret = $this->Delitable->query($sql);
		$ret = $model->find('all', array('fields' => array('Qty', 'SUM(Qty) as qty'), 'conditions' => array('ProductID' => $ProductID)));
//print_r($ret);
		return $ret[0][0]['qty'];
	}

	function GetDeliDocID( $ProductID ){
		$model = ClassRegistry::getObject('Delitable'); 
		if($ProductID == 0)
			return "";
		//$sql = "SELECT distinct(`DeliDocID`) FROM `delitable` WHERE `ProductID`=".$ProductID." order by `DeliDocID`;";
		//$ret = $this->Delitable->query($sql);
		$ret = $model->find('all', array('fields' => array('DISTINCT DeliDocID'), 'conditions' => array('ProductID' => $ProductID), 'order' => array('DeliDocID' => 'asc')));
		$count = count($ret);
		$s = "";
		for($i=0; $i<$count; $i++){
			if($i <> 0)
				$s = $s . ",";
			$s = $s . $ret[$i]['Delitable']['DeliDocID'];
		}
		return $s;
	}

	function GetOrderName2( $OrderID ){
		$model = ClassRegistry::getObject('Order'); 
		//$sql = "SELECT `OrderName` FROM `order` WHERE `ID` =".$OrderID;
		//$ret = $this->Order->query($sql);
		$ret = $model->find('all', array('fields' => array('OrderName'), 'conditions' => array('ID' => $OrderID)));
		return $ret[0]['Order']['OrderName'];
	}

	function GetClientName2($ClientID){
		$model = ClassRegistry::getObject('Client'); 
		//$sql = "SELECT `ClientName` FROM `client` WHERE `ID` =".$ClientID;
		//$ret = $this->Client->query($sql);
		$ret = $model->find('all', array('fields' => array('ClientName'), 'conditions' => array('ID' => $ClientID)));
		return $ret[0]['Client']['ClientName'];
	}

	function OrderName(){
		$model = ClassRegistry::getObject('Order'); 
		//$sql = "SELECT `OrderName` FROM `order` WHERE 1 ORDER BY `OrderName`";
		//$ret = $this->Order->query($sql);
		$ret = $model->find('all', array('fields' => array('OrderName'), 'conditions' => array('ID >' => 0), 'order' => array('OrderName' => 'asc')));
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Order']['OrderName'];
		}
		return $names;
	}

	function ClientName(){
		$model = ClassRegistry::getObject('Client'); 
		//$sql = "SELECT `ClientName` FROM `client` WHERE 1 ORDER BY `ClientName`";
		//$ret = $this->Client->query($sql);
		$ret = $model->find('all', array('fields' => array('ClientName'), 'conditions' => array('ID >' => 0), 'order' => array('ClientName' => 'asc')));
		$count = count($ret);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Client']['ClientName'];
		}
		return $names;
	}

	function GetDeliComAll(){
		$model = ClassRegistry::getObject('Delicom');
		
		$ret = $model->find('all');
//debug($ret);
		for($i=0; $i<count($ret); $i++){
			$id = $ret[$i]['Delicom']['ID'];
			$Delicom = $ret[$i]['Delicom']['DeliCom'];
			//$Delicom2 = $ret[$i]['Delicom']['DeliCom2'];
			if(!$Delicom){
				continue;
//debug($id);
//exit();
			}
			$d = str_replace('株式会社', '', $ret[$i]['Delicom']['DeliCom']);
			$d = str_replace('有限会社', '', $d);
			$d = str_replace('一般社団法人', '', $d);
			$d = str_replace('(中央)', '', $d);
			$d = str_replace('(関西)', '', $d);
			$d = str_replace('(首都圏)', '', $d);
//debug($d);
			$model->set('id', $ret[$i]['Delicom']['ID']);
			$model->id = $ret[$i]['Delicom']['ID'];
			$model->saveField('DeliCom2', $d);
		}
//$log = $model->getDataSource()->getLog(false, false);       
//debug($log);
//exit();
		//$sql = "SELECT DeliCom FROM DeliCom WHERE 1 ORDER BY DeliCom";
		//$ret = $this->Delicom->query($sql);
		//$sort = "REPLACE(REPLACE('Delicom', '株式会社', ''), '有限会社', '')";
		
		//$ret = $model->find('all', array('fields' => array('DeliCom'), 'conditions' => array('ID >' => 0), 'order' => array( $sort => 'asc')));
		$ret = $model->find('all', array('fields' => array('DISTINCT DeliCom2'), 'order' => array('DeliCom2' => 'asc')));

//$log = $model->getDataSource()->getLog(false, false);       
//debug($log);

		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Delicom']['DeliCom2'];
		}
		return $names;
	}

	function GetMfgAll(){
		$model = ClassRegistry::getObject('Product'); 
		//$sql = "SELECT distinct(`Mfg`) FROM `Product` WHERE `Mfg` <> '' order by `Mfg`";
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('DISTINCT Mfg'), 'conditions' => array('Mfg <>' => ""), 'order' => array('Mfg' => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[$i] = $ret[$i]['Product']['Mfg'];
		}
		return $names;
	}

	function GetDeliDocID2( $ProductID ){
		$model = ClassRegistry::getObject('Delitable'); 
		//$sql = "SELECT distinct(`DeliDocID`) FROM `delitable` WHERE `ProductID`=".$ProductID." order by `DeliDocID`;";
		//$ret = $model->query($sql);

		$ret = $model->find('all', array('fields' => array('DeliDocID'), 'conditions' => array('ProductID' => $ProductID), 'order' => array('DeliDocID' => 'asc')));
		$count = count($ret);
		$s = $ret[0]['Delitable']['DeliDocID'];
		if($count > 1)
			return $s = $s . "*";
		else
			return $s;
	}

	function GetDeliCom($DeliComID){
//debug($DeliComID);
		if($DeliComID == 0)
			return "";
		else
			$sql = "SELECT DeliCom FROM DeliCom WHERE ID=".$DeliComID;
//debug($sql);
		$model = ClassRegistry::getObject('Delicom'); 
		//$ret = $model->query($sql);
		$ret = $model->find('all', array('fields' => array('DeliCom'), 'conditions' => array('ID' => $DeliComID), 'order' => array('DeliCom' => 'asc')));
		$count = count($ret);
//debug($count);
//print_r($ret);
		if($count > 0)
			return $ret[0]['Delicom']['DeliCom'];
		else
			return "";
	}



	function get_date_num($date_str){
		list($date, $time) = explode(" ", $date_str);
		$date_num = str_replace("-", "", $date);
		return substr($date_num, 2);
	}
	
	function get_plan_data($plan_id=0){
		$model = ClassRegistry::getObject('Plan'); 
		$plan_data = $model->find('first', array('conditions' => array("id" => $plan_id) ));
		return $plan_data;
	}

	function sum_people($peoples_str){
		$peoples = explode(",", $peoples_str);
		$sum = 0;
		for($i=0; $i<count($peoples); $i++){
			$sum += $peoples[$i];
		}
		return $sum;
	}

	function get_implode($peoples_str, $n){
//debug("str=[".$peoples_str."]", false, false);
//debug($peoples_str);
		$peoples = explode(",", $peoples_str);
		if(isset($peoples[$n]))
			return $peoples[$n];
		else
			return "-";
	}
	function get_implode_n($peoples_str, $n){
		if($n > 6)
			$n = 6;
		$num = $this->get_implode($peoples_str, $n);
		if($num == "-")
			return $num;
		else
			return number_format($num);
	}

	
	
	public function make_mail_proc($user_data, $book_data, $filename="newreg_mail.txt"){
		$text = file_get_contents(WWW_ROOT."files/".$filename);
		$text = str_replace("\r", "", $text);
		$text = str_replace("\a", "", $text);
//debug($user_data);
		$lines = explode("\n", $text);
		$subject = $body = "";
		for($i=0; $i<count($lines); $i++){
			//echo $lines[$i]."<br>";
			if($i == 0)
				$subject = $lines[$i];
			else
				$body .= $lines[$i]."\n";
		}
		$items = array("mail", "username", "password", "name", "name_furi", "mailC", "pref", "post", "city", "twn_add", "bild", "Contact", "tel", "Ctime");
		for($i=0; $i<count($items); $i++){
			$body = str_replace("<?".$items[$i]."?>", $user_data[ $items[$i] ], $body);
		}
		
		if(strstr($filename, "cancel_mail.txt") || strstr($filename, "booking_mail.txt")){
			$items = array("Rtime", "TRF", "memo", "text");
			for($i=0; $i<count($items); $i++){
				$body = str_replace("<?".$items[$i]."?>", $book_data[ $items[$i] ], $body);
			}
		}
	//	echo $subject."<br>";
	//	echo nl2br($body)."<br>";
	//exit();
		return array($subject, $body);
//		list($subject, $mailbody)
	}
	

	public function redirect_post($url, $data){
//debug($data);
		$data = http_build_query($data, "", "&");
		$header = array(
    		"Content-Type: application/x-www-form-urlencoded",
			"Content-Length: ".strlen($data)
			);

		$context = array(
			"http" => array(
      		"method"  => "POST",
      		"header"  => implode("\r\n", $header),
        	"content" => $data
    		)
		);

		echo file_get_contents($url, false, stream_context_create($context));
		exit();
	}


	function ConvPath($s){
		$NowPos = 0;
		$buf = "";
		$c0 = mb_substr($s, 0, 1);
		for($i=1; $i <= mb_strlen($s); $i++){
			$c = mb_substr($s, $NowPos, 1);
        	$n = ord($c);
        	// debug($c);
        	// debug($n);
        	if( (($c0 == "C") or ($c0 == "D")) and ( $c == "/")){
            	$buf = $buf . "\\";
        	}elseif( (($c0 == "c") or ($c0 == "d")) and ( $c == "/")){
            	$buf = $buf . "\\";
        	}else{
            	$buf = $buf . $c;
        	}
        	$NowPos = $NowPos + 1;
    	}
    	return $buf;
	}








	public function download_proc($excel_file){
		$key = $this->key;

		//$filename = "shoplist".date("Ymd-hi").".csv";
		$path_filename = $excel_file;
		if(file_exists($path_filename))
			unlink($path_filename);
		if (!$handle = fopen($path_filename, 'a')) {
			echo "Cannot open file ($path_filename)";
			exit;
		}

		for($i=0; $i<count($data); $i++){
			$line = "";
			for($j=1; $j<count($key); $j++){
				if($j != 1)
					$line .= ",";
				$line .= "\"".$data[$i]['Shop'][ $key[$j] ]."\"";
			}
			//echo "line=[".$line."]<hr>";
			if (fwrite($handle, $line."\n") === FALSE) {
				echo "Cannot write to file ($filename)";
				exit;
			}
		}
		fclose($handle);
		chmod($path_filename, 0777);
		/////////////////////////////////////////////////////////////////////////////
		if( !is_file($path_filename) ){
			return false;
		}

		$this->autoRender = false; // Viewを使わないように
		Configure::write('debug', 0); // debugコードを出さないように

		$fp = fopen($path_filename, 'rb');
		$buf = fread($fp, filesize($path_filename));

		header ("Content-disposition: attachment; filename=" . $filename);
		header ("Content-type: application/octet-stream; name=" . $filename);
		print($buf); // 出力
		exit;
		return true;
	}


	public function save_csv_line($shop, $line){
		$data = explode(",", $line);
		$j = 1;
		$key = $this->key;

		$data1[$key[0]] = null;
		$str1 = null;
		for($i=0; $i<count($data); $i++){
			if(!isset($key[$j])){
				echo "Error: CSVファイルのフィールド数が不足<hr>";
				print_r($data1);
				exit;
			}
			if(substr($data[$i], 0, 1) == "\x22"){
				if(substr($data[$i], -1) == "\x22"){
					$data1[$key[$j++]] = substr($data[$i], 1, strlen($data[$i]) - 2);
					//echo "str1=[".$data1[$key[$j++]]."]<br>";
				}else{
					$str1 = substr($data[$i], 1).",";
				}
			}else{
				if(substr($data[$i], -1) == "\x22"){
					if($str1){
						$data1[$key[$j++]] = $str1.substr($data[$i], 0, strlen($data[$i]) - 1);
						//echo "str3=[".$data1[$key[$j++]]."]<br>";
					}else{
						$data1[$key[$j++]] = substr($data[$i], 0, strlen($data[$i]) - 1);
						//echo "str2=[".$data1[$key[$j++]]."]<br>";
					}

				}else{
					if($str1)
						$str1 .= $data[$i].",";
					else{
						$data1[$key[$j++]] = $data[$i];
						//echo "str0=[".$data1[$key[$j++]]."]<br>";
					}
				}
			}
		}
		//-------------------------------------------------------------
		//print_r($data1);
		//exit;
		$data1 = $this->sjis2utf8($data1);
		if($shop->save($data1)){
			return true;
		}else{
			//$this->AppliSub->error_proc($shop->invalidFields(), "Shop");
			echo "Error: ファイル保存";
			exit;
			return false;
		}
	}

	public function make_html($id, $html_text=""){
		$html_file = WWW_ROOT."files/html/auth.html";
		$file = new File($html_file, true);
		$html_text = $file->read().$html_text;
		$file->close();

		$html_file = WWW_ROOT."files/html/".$id.".html";
		if(file_exists($html_file))
			unlink($html_file);

		$file = new File($html_file, true);
		$file->write($html_text);
		$file->close();
		chmod($html_file, 0666);

		App::import('Helper', 'Html');
		$html = new HtmlHelper();
		//return $html->url('/', true)."files/html/".$id.".html";
		return $id.".html";
	}




	public function array_to_string($arr){
		$s = "";
//debug($arr);
		foreach ($arr as $key => $value)
			$s .= "/".$key.":".$value;
		return $s;
	}

	function getPost($obj, $model='Product', $post){
		if(isset($obj->params['data'][$model][$post])){
			if(!is_array($obj->params['data'][$model][$post]))
				$ret = trim($obj->params['data'][$model][$post]);
			else
				$ret = $obj->params['data'][$model][$post];
		}elseif(isset($obj->passedArgs[$post]))
			$ret = $obj->passedArgs[$post];
		else
			$ret = null;
		$obj->set($post, $ret);
		return $ret;
	}

	function getPost2($obj, $model='Product', $post){
		$ret = null;
		$obj->set($post, $ret);
		return $ret;
	}

	function getPost3($obj, $model='Product', $post){

		$ret = $this->getPost($obj, $model='Product', $post);
//debug($model."-".$post."-step1=".$ret."=".strpos($ret,'-'));
		if(strpos($ret,'-') === false){  //'abcd'のなかに'bc'が含まれていない場合
			if( (strlen($ret) == 4) && (substr($ret,0,2) == "12") ){
				$ret = "2019-12-" . substr($ret,2,2);
			}elseif(strlen($ret) == 3){
				$ret = "2020-0" . substr($ret,0,1) . "-" . substr($ret,1,2);
			}elseif(strlen($ret) == 4){
				$ret = "2019-" . substr($ret,0,2) . "-" . substr($ret,2,2);
			}elseif(strlen($ret) == 8){
				$ret = substr($ret,0,4) . "-" . substr($ret,4,2) . "-" . substr($ret,6,2);
			}
		}
		$obj->set($post."_", $ret);
		return $ret;
	}
	
	function convert_date($sdate){
		$ret = $sdate;
		if(strpos($sdate,'-') === false){  //'abcd'のなかに'bc'が含まれていない場合
			if( (strlen($sdate) == 4) && (substr($sdate,0,2) == "12") ){
				$ret = "2019-12-" . substr($sdate,2,2);
			}elseif(strlen($sdate) == 3){
				$ret = "2020-0" . substr($sdate,0,1) . "-" . substr($sdate,1,2);
			}elseif(strlen($sdate) == 4){
				$ret = "2019-" . substr($sdate,0,2) . "-" . substr($sdate,2,2);
			}elseif(strlen($sdate) == 8){
				$ret = substr($sdate,0,4) . "-" . substr($sdate,4,2) . "-" . substr($sdate,6,2);
			}
		}
		//$obj->set($post."_", $ret);
		return $ret;
	}

/**
 * ファイルアップロードメソッド
 */
	public function upload_proc($up_path, $obj, &$up_file=""){
		$obj->set('error_message', "");
		$obj->set('upload_file', "");
		$obj->set('file_name', "");
		$obj->set('up_file', "");
		$obj->set('up_url', "");
		$file_name = null;
		if (!empty($obj->data) && isset($obj->data['Upload']['file_name']['tmp_name'])) {

//debug($obj->data['Upload']['file_name']['tmp_name']);
			if( is_uploaded_file($obj->data['Upload']['file_name']['tmp_name']) ){
				if( strlen($obj->data['Upload']['file_name']['name']) == mb_strlen($obj->data['Upload']['file_name']['name']) ){
					//アップロードするファイルの場所
					$uploaddir = WWW_ROOT."files/".$up_path;	//Configure::read('upload.path');
					$uploadfile = $this->ConvPath( $uploaddir.DS.basename($obj->data['Upload']['file_name']['name']) );
					if(file_exists($uploadfile)){
						unlink($uploadfile);
					}
					$info = pathinfo($uploadfile);
					$file_name = $info['basename'];
					//$obj->data['Upload']['file_name']['name'] = $file_name;

					/*
					// 同じ名前のファイルがすでに存在すれば、別名に変える
					$i = 1;
					while( file_exists($uploadfile) ){
						$i++;
						$file_name = basename($info['basename'],'.'.$info['extension']).
							'_'.$i.'.'.$info['extension'];
						$uploadfile = $info['dirname'].DS.$file_name;
						$obj->log('アップロードファイル名を再作成：'.$uploadfile, LOG_DEBUG);
						$obj->data['Upload']['file_name']['name'] = $file_name;
					}
					*/

					//画像をテンポラリーの場所から、正式な置き場所へ移動
					if (move_uploaded_file($obj->data['Upload']['file_name']['tmp_name'], $uploadfile)){
						chmod($uploadfile, 0666);
						$obj->set('error_message', "ファイルのアップロードに成功しました。");
						App::import('Helper', 'Html');
						$html = new HtmlHelper();
						$up_url = $html->url('/', true)."files/".$up_path."/".$file_name;
						$up_file = $this->ConvPath( WWW_ROOT."files/".$up_path."/".$file_name );

						$obj->set('up_file', $up_file);
						$obj->set('up_url', $up_url);
						$obj->set('file_name', $file_name);
					} else {
						//失敗
						$obj->set('error_message', "ファイルのアップロードに失敗しました。");
					}
				}else{
					$obj->set('error_message', "ファイル名に全角文字は使用できません。[".$obj->data['Upload']['file_name']['name']."]");
				}
			}else{
				//$obj->Upload->invalidate("file_name","ファイルをアップロードしてください。");
			}
			$obj->data = array();
		}
//debug($obj->data);
//debug($obj->data['Upload']['file_name']['tmp_name']);
//debug($file_name);
		return $file_name;
	}


	public function to_sjis($str){
		return mb_convert_encoding($str, "SJIS", "auto");
	}

	public function to_utf8($str){
		return mb_convert_encoding($str, "UTF-8", "auto");
	}

	public function sjis2utf8($data){
		return $this->mb_convert_proc($data, "SJIS, auto", "UTF-8");

//		$data2 =  $this->mb_convert_proc($data, "SJIS, auto", "UTF-8");
//		print_r($data);
//		echo "<hr>";
//		print_r($data2);
//		exit;
	}

	public function utf82sjis($data){
		return $this->mb_convert_proc($data, "UTF-8, auto", "SJIS");
	}
	
	private function mb_convert_proc($data, $from, $to){
		if(empty($data))
			return array();

		foreach($data as $key1 => $value1) {
			if(!is_array($value1)){
				if(is_null($value1))
					$data[$key1] = null;
				elseif($this->IsAllNum($value1))
					$data[$key1] = $value1;
				elseif(is_string($value1))
					$data[$key1] = mb_convert_encoding($value1, $to, $from);
				else
					$data[$key1] = $value1;
			}else{
				foreach ($value1 as $key2 => $value2) {
					//echo "Key: $key2; Value: $value2<br />\n";
					if(!is_array($value2)){
						if(is_null($value2))
							$data[$key1][$key2] = null;
						elseif($this->IsAllNum($value2))
							$data[$key1][$key2] = $value2;
						elseif(is_string($value2)){
							$data[$key1][$key2] = mb_convert_encoding($value2, $to, $from.", auto");
//echo "value2=[".$value2."]<br>";
//exit;
						}else
							$data[$key1][$key2] = $value2;
					}else{
						foreach ($value2 as $key3 => $value3) {
							//echo "Key: $key3; Value: $value3<br />\n";
							if(!is_array($value3)){
								if(is_null($value3))
									$data[$key1][$key2][$key3] = null;
								elseif($this->IsAllNum($value3))
									$data[$key1][$key2][$key3] = $value3;
								elseif(is_string($value3))
									$data[$key1][$key2][$key3] = mb_convert_encoding($value3, $to, $from);
								else
									$data[$key1][$key2][$key3] = $value3;
							}
						}
					}
				}
			}
		}
		return $data;
	}



//*******************************************************************
	function IsKanji($d){
		$c = ord($d);
	
		if(($c >= 0x81) && ($c <=0x9F) || ($c >= 0xE0) && ($c <= 0xFC))
			return True;
		else
			return False;
	}
//*******************************************************************
	function IsKanji2($d){
		$c = ord($d);

		if(($c >= 0x40) && ($c <= 0xFC) && ($c != 0x7F))
			return True;
		else
			return False;
	}
//*******************************************************************
	function OmitNumTitle($s){
		$out = "";
		for($i=0; $i<3; $i++){
			$c = substr($s, $i, 1);
			if(!$this->IsNum($c))
				$out .= $c;
		}
		return ($out . substr($s, 3));
	}
//*******************************************************************
	function StlipNum($s){
		$out = "";
		for($i=0; $i<strlen($s); $i++){
			$c = substr($s, $i, 1);
			if($this->IsKanji($c)){
				$i++;
			}elseif($this->IsNum($c)){
				$out .= $c;
			}
		}
		return intval($out);
	}
//*******************************************************************
	function IsNum($d){
		$c = ord($d);

		if(($c >= 0x30) && ($c <= 0x39))
		//if(($c >= 48) && ($c <= 57))
			return True;
		else
			return False;
	}
//*******************************************************************
//文字列は数字か？
	function IsAllNum($buf){
	    $s = Trim($buf);
	//DEBUG("ARG=" . $s);
	
		for($i=0; $i<strlen($s); $i++){
			$c = substr($s, $i, 1);
			if($this->IsNum($c) == False){
			    return False;	
			} 
		}
	    return True;
	}
//*******************************************************************
	function ConvApost($s){
		$outs="";
		
		for($i=0; $i<strlen($s); $i++){
			$c = substr($s, $i, 1);
			if(IsKanji($c) == True){
				$i++;
				$outs .= $c. substr($s, $i, 1);
			}elseif($c == "'"){
				$outs .= "''";
			}elseif($c == "\\"){
				$outs .= "";
			}else{
				$outs .= $c;
	
			}
		}
	    return $outs;
	}
//*******************************************************************


	function conv_week($y, $m, $d){
		//曜日番号に対応する日本語の曜日リスト
		$weekjp_array = array('日', '月', '火', '水', '木', '金', '土');
		//今日の曜日
		$weekno = date('w', mktime(0, 0, 0, $m, $d, $y));
		$weekjp = $weekjp_array[$weekno];
		//echo $weekjp . '曜日です';
		return $weekjp;
	}

	function ConvTime($s){
		$outs="";
		if($s == "")
			return "";
		
		for($i=0; $i<strlen($s); $i++){
			$c = substr($s, $i, 1);
			if($this->IsNum($c) == True){
				$outs .= $c;
			}elseif($c == ":"){
				$outs .= $c;
			}elseif($c == "?"){
				$outs .= $c;
			}
		}
	    return $outs;
	}


}
